<?php

namespace App\Console\Commands;

use App\Models\User;
use Rats\Zkteco\Lib\ZKTeco;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Http;

class SyncEmployee extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:sync-employee';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        try {
            $this->SyncUser();
            $this->SyncUserToDatabase();
        } catch (\Exception $e) {
            throw $e;
        }
    }
    public function SyncUser()
    {
        DB::beginTransaction();

        try {
            $zk = new ZKTeco('192.168.0.173', 4370);
            $zk->connect();
            $zk->enableDevice();

            $users = DB::connection('mysql_live')->table('users')->get();

            foreach($users as $user) {
                $uid = $user->id;
                $userid = $user->fingerprint_id;
                $name = $user->first_name . ' ' . $user->last_name;
                $password = '';
                $role = 0;
                $cardno = 0;
                $zk->setUser($uid, $userid, $name, $password, $role, $cardno);
            }

            $zk->disableDevice();
            $zk->disconnect();
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            throw $e;
        }
    }

    public function SyncUserToDatabase()
    {
        DB::beginTransaction();

        try {
            $zk = new ZKTeco('192.168.0.173', 4370);
            $zk->connect();
            $zk->enableDevice();
            $users = $zk->getUser();

            foreach ($users as $user) {
                $existingUser = User::where('fingerprint_id', $user['userid'])->first();

                if (!$existingUser) {
                    $user = new User();
                    $user->fingerprint_id = $user['userid'];
                    $user->first_name = $user['name'];
                    $user->last_name = $user['name'];
                    $user->save();
                }
            }

            $zk->disableDevice();
            $zk->disconnect();

            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            throw $e;
        }
    }
}
