<?php

namespace App\Http\Controllers;

use App\Models\Donar;
use App\Traits\SmsTrait;
use App\Models\DonarType;
use App\Models\SmsStatus;
use App\Traits\DeleteTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Validator;

class DonarController extends Controller
{
    use SmsTrait;
    use DeleteTrait;
    public function DonarType(Request $request)
    {
        try {
            if ($request->ajax()) {
                    $data = DB::table('donar_types')->whereNull('deleted_at')->orderBy('id', 'desc')->get();

                return Datatables::of($data)

                    ->addColumn('action', function ($data) {

                        $edit = '<a id="edit" href="' . route('donar.type.edit', $data->id) . ' " class="btn btn-sm btn-primary edit" title="Edit" data-toggle="modal" data-target="#editClass"><i class="fa fa-edit"></i></a> ';

                        $delete = '';
                        if ($this->DeleteData()) {
                            $delete = '<button id="messageShow" class="btn btn-sm btn-danger btn-delete" data-remote=" ' . route('donar.type.destroy', $data->id) . ' " title="Delete"><i class="fa fa-trash-alt"></i></button>';
                        }

                        return $edit . $delete;
                    })

                    ->addIndexColumn()
                    ->rawColumns(['action'])
                    ->toJson();
            }
            return view('dashboard.donars.donar_type');
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function DonarTypeStore(Request $request)
    {
        if ($request->ajax()) {
            $data = Validator::make($request->all(), [
                'name' => 'required|string|unique:donar_types,name,NULL,id,deleted_at,NULL',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }

            try {
                $data = new DonarType();
                $data->name = $request->name;
                $data->save();

                return response()->json([
                    'success' => true,
                    'message' => 'Donar type created successfully',
                ]);

            } catch (\Exception $exception) {
                return response()->json([
                    'error' => false,
                    'message' => $exception->getMessage(),
                ]);
            }
        }
    }

    public function DonarTypeEdit($id)
    {
        $data = DonarType::findOrFail($id);
        return response()->json($data);
    }

    public function DonarTypeUpdate(Request $request, $id)
    {
        $data = Validator::make($request->all(), [
            'name' => 'required|string|unique:donar_types,name,' . $id . ',id,deleted_at,NULL',
        ]);

        if ($data->fails()) {
            return response()->json([
                'success' => false,
                'message' => $data->errors()->all(),
            ]);
        }

        try {
            $data = DonarType::findOrFail($id);
            $data->name = $request->name;
            $data->save();

            return response()->json([
                'success' => true,
                'message' => 'Donar type updated successfully',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => $exception->getMessage(),
            ]);
        }
    }

    public function DonarTypeDestroy($id)
    {
        DB::beginTransaction();

        try {
            $donarType = DonarType::findOrFail($id);

            $donars = Donar::where('donar_type_id', $donarType->id)->get();

            $tablesWithDonarId = DB::select("
                SELECT TABLE_NAME
                FROM INFORMATION_SCHEMA.COLUMNS
                WHERE COLUMN_NAME = 'donar_id'
                AND TABLE_SCHEMA = DATABASE()
            ");

            foreach ($donars as $donar) {
                foreach ($tablesWithDonarId as $table) {
                    if ($table->TABLE_NAME !== 'donars') {
                        DB::table($table->TABLE_NAME)
                            ->where('donar_id', $donar->id)
                            ->delete();
                    }
                }
                $donar->delete();
            }

            $tablesWithDonarType = DB::select("
                SELECT TABLE_NAME
                FROM INFORMATION_SCHEMA.COLUMNS
                WHERE COLUMN_NAME = 'donar_type_id'
                AND TABLE_SCHEMA = DATABASE()
            ");

            foreach ($tablesWithDonarType as $table) {
                if ($table->TABLE_NAME !== 'donar_types') {
                    DB::table($table->TABLE_NAME)
                        ->where('donar_type_id', $donarType->id)
                        ->delete();
                }
            }

            $donarType->delete();

            DB::commit();

            return response()->json([
                'success' => true,
                'message' => 'Donar type deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            DB::rollBack();

            return response()->json([
                'success' => false,
                'message' => 'Donar type delete failed',
                'error' => $exception->getMessage(),
            ]);
        }
    }

    public function DonarList(Request $request)
    {
        try {
            if ($request->ajax()) {

                $data = Donar::with('types')->select('id','donar_type_id','name','phone','address')->get();

                return Datatables::of($data)

                    ->addColumn('type', function ($data) {
                        $type = $data->types ? $data->types->name : '';
                        return $type;
                    })

                    ->addColumn('action', function ($data) {

                        $edit = '<a id="edit" href="' . route('donar.edit', $data->id) . ' " class="btn btn-sm btn-primary edit" title="Edit" data-toggle="modal" data-target="#editClass"><i class="fa fa-edit"></i></a> ';

                        $delete = '';
                        if ($this->DeleteData()) {
                            $delete = '<button id="messageShow" class="btn btn-sm btn-danger btn-delete" data-remote=" ' . route('donar.destroy', $data->id) . ' " title="Delete"><i class="fa fa-trash-alt"></i></button>';
                        }

                        return $edit . $delete;
                    })

                    ->addIndexColumn()
                    ->rawColumns(['type','action'])
                    ->toJson();
            }
            $donarTypes = DonarType::select('id','name')->get();
            return view('dashboard.donars.donar_list', compact('donarTypes'));
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function DonarStore(Request $request)
    {
        if ($request->ajax()) {
            $data = Validator::make($request->all(), [
                'phone' => 'required|string|unique:donars,phone,NULL,id,deleted_at,NULL',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }

            try {
                $data = new Donar();
                $data->name = $request->name;
                $data->phone = $request->phone;
                $data->donar_type_id = $request->donar_type_id;
                $data->address = $request->address;
                $data->created_by = Auth::user()->id;
                $data->save();

                $type = DonarType::findOrFail($request->donar_type_id);
                $status = optional(SmsStatus::first())->donar_admission;
                $site = DB::table('settings')->first();

                $to = $data->phone;
                $text = $site->name . ', '. $data->name . ', আপনি '. $type->name . ' স্পনসর হিসেবে আমাদের সাথে যুক্ত হয়েছেন';
                if($status == 1){
                    $this->SendSms($to, $text);
                }

                return response()->json([
                    'success' => true,
                    'message' => 'Donar created successfully',
                ]);

            } catch (\Exception $exception) {
                return response()->json([
                    'error' => false,
                    'message' => $exception->getMessage(),
                ]);
            }
        }
    }

    public function DonarEdit($id)
    {
        $data = Donar::findOrFail($id);
        return response()->json($data);
    }

    public function DonarUpdate(Request $request, $id)
    {
        $data = Validator::make($request->all(), [
            'phone' => 'required|string|unique:donars,phone,' . $id . ',id,deleted_at,NULL',
        ]);

        if ($data->fails()) {
            return response()->json([
                'success' => false,
                'message' => $data->errors()->all(),
            ]);
        }

        try {
            $data = Donar::findOrFail($id);
            $data->name = $request->name;
            $data->phone = $request->phone;
            $data->donar_type_id = $request->donar_type_id;
            $data->address = $request->address;
            $data->created_by = Auth::user()->id;
            $data->save();

            $type = DonarType::findOrFail($request->donar_type_id);
            $status = optional(SmsStatus::first())->donar_admission;
            $site = DB::table('settings')->first();$site->name . ', '.
            $to = $data->phone;
            $text = $site->name . ', '. $data->name . ', আপনি '. $type->name . ' স্পনসর হিসেবে আমাদের সাথে যুক্ত হয়েছেন';
            if($status == 1){
                $this->SendSms($to, $text);
            }

            return response()->json([
                'success' => true,
                'message' => 'Donar updated successfully',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => $exception->getMessage(),
            ]);
        }
    }

    public function DonarDestroy($id)
    {
        try {
            $data = Donar::findOrFail($id);
            $tables = DB::select("
            SELECT TABLE_NAME
            FROM INFORMATION_SCHEMA.COLUMNS
            WHERE COLUMN_NAME = 'donar_id'
            AND TABLE_SCHEMA = DATABASE()
            ");

            foreach ($tables as $table) {
                if ($table->TABLE_NAME !== 'donars') {
                    DB::table($table->TABLE_NAME)->where('donar_id', $data->id)->delete();
                }
            }

            $data->delete();
            return response()->json([
                'success' => true,
                'message' => 'Donar deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Donar delete failed',
            ]);
        }
    }
}
