<?php

namespace App\Http\Controllers\BackEnd\Student;

use Carbon\Carbon;
use App\Traits\SmsTrait;
use Illuminate\Http\Request;
use App\Models\BackEnd\Student;
use Illuminate\Support\Facades\DB;
use App\Models\BackEnd\BankAccount;
use App\Models\BackEnd\Transaction;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Redirect;
use Yajra\DataTables\Facades\DataTables;
use App\Models\BackEnd\MobileBankingAccount;

class FeeCollectController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        try {

        if ($request->ajax()) {

            $data = DB::table('transactions')
                ->Join('students', 'students.id', '=', 'transactions.student_id')
                ->select('transactions.*','students.*')
                ->whereNull('transactions.deleted_at')
                ->whereIn('transactions.transaction_type', [2, 3])
                ->groupBy(['transactions.salary_month', 'transactions.student_id'])
                ->get();

                return Datatables::of($data)

                    ->addColumn('month', function ($data) {
                        $month = Carbon::parse($data->fees_month)->format('F, Y');
                        return $month;
                    })

                    ->addColumn('totalAmount', function ($data) {

                        // $monthlyFee = $data->monthly_fee ?? 0;
                        // $mealCost = $data->meal_cost ?? 0;
                        // $examFee = $data->receive_exam_fee ?? 0;
                        // $adjustAmount = $data->adjust_amount ?? 0;

                        // if(2 == $data->adjust_type){
                        //     $total = ($monthlyFee + $mealCost + $examFee) - ($adjustAmount);
                        // }else{
                        //     $total = ($monthlyFee + $mealCost + $examFee) + ($adjustAmount);
                        // }
                        $total = DB::table('transactions')->where('student_id', $data->student_id)->where('fees_month', $data->fees_month)->whereNull('deleted_at')->whereIn('transaction_type', [2,3])->sum('total_amount');

                        // $total = $data->total_amount;
                        return number_format($total, 2);
                    })

                    ->addColumn('receiveAmount', function ($data) {

                        $receiveAmount = DB::table('transactions')->where('student_id', $data->student_id)->where('fees_month', $data->fees_month)->whereNull('deleted_at')->whereIn('transaction_type', [2,3])->sum('amount');

                        // $Fee = $data->receive_fee ?? 0;
                        // $mealCost = $data->receive_meal_cost ?? 0;
                        // $examFee = $data->receive_exam_fee ?? 0;
                        // $duePaid = $data->amount ?? 0;
                        // $total = $Fee + $mealCost + $examFee + $dueReceive;
                        // $receiveAmount = 0;
                        // $receiveAmount += $data->amount;
                        return number_format($receiveAmount, 2);
                    })

                    ->addColumn('dueAmount', function ($data) {

                        $total = DB::table('transactions')->where('student_id', $data->student_id)->where('fees_month', $data->fees_month)->whereNull('deleted_at')->whereIn('transaction_type', [2,3])->sum('total_amount');

                        $receiveAmount = DB::table('transactions')->where('student_id', $data->student_id)->where('fees_month', $data->fees_month)->whereNull('deleted_at')->whereIn('transaction_type', [2,3])->sum('amount');

                        $due = $total - $receiveAmount;
                        return number_format($due, 2);
                            // $monthlyFee = $data->monthly_fee ?? 0;
                        // $mealCost = $data->meal_cost ?? 0;
                        // $receiveExamFee = $data->receive_exam_fee ?? 0;
                        // $adjustAmount = $data->adjust_amount ?? 0;

                        // if(2 == $data->adjust_type){
                        //     $total = ($monthlyFee + $mealCost + $receiveExamFee) - ($adjustAmount);
                        // }else{
                        //     $total = ($monthlyFee + $mealCost + $receiveExamFee) + ($adjustAmount);
                        // }

                        // $receiveFee = $data->receive_fee ?? 0;
                        // $receiveMealCost = $data->receive_meal_cost ?? 0;

                        // $totalReceive = $receiveFee + $receiveMealCost + $receiveExamFee + $dueReceive;
                        // $total = $data->total_amount;
                        // $receiveAmount = $data->amount;
                        })



                    ->addColumn('feeStatus', function ($data) {
                        // $dueReceive = DB::table('transactions')->where('student_id', $data->student_id)->where('fees_month', $data->fees_month)->where('transaction_type', 3)->sum('amount');

                        // $monthlyFee = $data->monthly_fee ?? 0;
                        // $mealCost = $data->meal_cost ?? 0;
                        // $receiveExamFee = $data->receive_exam_fee ?? 0;
                        // $adjustAmount = $data->adjust_amount ?? 0;

                        // if(2 == $data->adjust_type){
                        //     $total = ($monthlyFee + $mealCost + $receiveExamFee) - ($adjustAmount);
                        // }else{
                        //     $total = ($monthlyFee + $mealCost + $receiveExamFee) + ($adjustAmount);
                        // }

                        // $receiveFee = $data->receive_fee ?? 0;
                        // $receiveMealCost = $data->receive_meal_cost ?? 0;

                        // $totalReceive = $receiveFee + $receiveMealCost + $receiveExamFee + $dueReceive;
                        // $due = $total - $totalReceive;

                        $total = DB::table('transactions')->where('student_id', $data->student_id)->where('fees_month', $data->fees_month)->whereNull('deleted_at')->whereIn('transaction_type', [2,3])->sum('total_amount');

                        $receiveAmount = DB::table('transactions')->where('student_id', $data->student_id)->where('fees_month', $data->fees_month)->whereNull('deleted_at')->whereIn('transaction_type', [2,3])->sum('amount');

                        $due = $total - $receiveAmount;

                         if($due == 0){
                            $status ='<span class="badge badge-success" title="Paid">Paid</span>';
                        }else{
                            $status ='<a href="' . route('due-collect', $data->id) . ' " class="badge badge-danger" title="Due">Due</a>';
                         }

                        return $status ;
                    })

                    ->addColumn('action', function ($data) {

                        $btn = '<a id="details" href="' . route('student-monthly-fees', $data->student_id . '/' .$data->fees_month) . ' " class="btn btn-sm btn-primary show" title="Details"><i class="fa fa-eye"></i></a>';

                        return $btn ;
                    })

                    ->addIndexColumn()
                    ->rawColumns(['month','totalAmount','receiveAmount','dueAmount','feeStatus','action'])
                    ->toJson();
                }
            return view('backend.students.fee_collect.index');

            } catch (\Exception $exception) {
                return redirect()->back()->with('error', $exception->getMessage());
            }
        }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    use SmsTrait;
    public function store(Request $request)
    {
        $messages = array(
            'fees_month.required'   => 'Enter month',
            'date.required'   => 'Enter date',
        );

        $this->validate($request, array(
            'payment_method' => 'required|',
            'fees_month'   => 'required|',
        ), $messages);

        // if ($request->receive_amount > $request->total_rent) {
        //     return redirect()->back()->with('error', "Received amount can't be more than total amount");
        // }
        DB::beginTransaction();

        try {
            $data = new Transaction();
            $data->student_id            = $request->student_id;
            $data->date                  = $request->date;
            $data->fees_month            = $request->fees_month;
            $data->adjust_type           = $request->adjust_type;
            $data->adjust_amount         = $request->adjust_amount;
            $data->monthly_fee           = $request->monthly_fee;
            $data->amount                = $request->amount;
            $data->total_amount          = $request->total_amount;
            $data->exam_fee              = $request->exam_fee;
            $data->meal_cost             = $request->meal_cost;
            $data->receive_fee           = $request->receive_fee;
            $data->receive_exam_fee      = $request->receive_exam_fee;
            $data->receive_meal_cost     = $request->receive_meal_cost;
            $data->adjust_reason         = $request->adjust_reason;
            $data->transaction_purpose   = $request->transaction_purpose;
            $data->transaction_type      = $request->transaction_type;
            $data->account_id            = $request->account_id;
            $data->mobile_banking_id     = $request->mobile_banking_id;
            $data->payment_method        = $request->payment_method;
            $data->mobile_transaction_id = $request->mobile_transaction_id;
            $data->description           = $request->description;
            $data->created_by            = 1;
            $data->save();

            // $student = Student::with('departments')->findOrFail($data->student_id);
            // $name = $student->name ?? '';
            // $department = $student->departments->department_name ?? '';
            // $contact = $student->contact_no ?? '';
            // $email = $student->email ?? '';
            // $salary = $student->monthly_fee ?? '';
            // $bonus = $data->adjust_amount ?? '';
            // $receivedmount = $data->amount ?? '';
            // $month = Carbon::parse($data->salary_month)->format('F , Y');
            // $date = Carbon::parse($data->date)->format('d M, Y');
            // $totalSalary = is_numeric($receivedmount) + is_numeric($bonus) ;
            // $due = is_numeric($totalSalary) - is_numeric($receivedmount);

            // $msg = "Date : $date, Name : $name, Department : $department, E-mail : $email, Phone : $contact, Salary Month : $month, Salary : $salary, Adjust Amount : $bonus, Total Amount : $totalSalary, Salary Paid : $receivedmount, Salary Due : $due ";
            // $this->SendSms($contact, $msg);
            // if($data){
            //     $this->SendSms($contact, $msg);
            //     // Mail::to($email)->send(new SendEmail($tenant, $due));
            // }

            DB::commit();

            return redirect()->route('fee-collect.index')
                ->with('success', 'Fee collect successfully');
        } catch (\Exception $exception) {
            DB::rollBack();
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $data = Transaction::with('students')->findOrFail($id);

        $total = DB::table('transactions')->where('student_id', $data->student_id)->where('fees_month', $data->fees_month)->whereNull('deleted_at')->whereIn('transaction_type', [2,3])->sum('total_amount');

        $receivedAmount = DB::table('transactions')->where('student_id', $data->student_id)->where('fees_month', $data->fees_month)->whereNull('deleted_at')->whereIn('transaction_type', [2,3])->sum('amount');

        $due = $total - $receivedAmount;

        return view('backend.students.fee_collect.show', compact('data','receivedAmount','due'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Transaction::with('students')->findOrFail($id);
        $banks = BankAccount::with('banks')->where('status', 1)->get();
        $mobilebanks = MobileBankingAccount::with('mobileBankings')->where('status', 1)->get();

        return view('backend.students.fee_collect.edit', compact('data','banks','mobilebanks'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $messages = array(
            'fees_month.required'   => 'Enter month',
            'date.required'   => 'Enter date',
        );

        $this->validate($request, array(
            'payment_method' => 'required|',
            'fees_month'   => 'required|',
        ), $messages);

        // if ($request->receive_amount > $request->total_rent) {
        //     return redirect()->back()->with('error', "Received amount can't be more than total amount");
        // }

        DB::beginTransaction();

        try {
            $data = Transaction::findOrFail($id);
            $data->student_id            = $request->student_id;
            $data->date                  = $request->date;
            $data->fees_month            = $request->fees_month;
            $data->adjust_type           = $request->adjust_type;
            $data->adjust_amount         = $request->adjust_amount;
            $data->monthly_fee           = $request->monthly_fee;
            $data->exam_fee              = $request->exam_fee;
            $data->meal_cost             = $request->meal_cost;
            $data->amount                = $request->amount;
            $data->receive_fee           = $request->receive_fee;
            $data->receive_exam_fee      = $request->receive_exam_fee;
            $data->receive_meal_cost     = $request->receive_meal_cost;
            $data->adjust_reason         = $request->adjust_reason;
            $data->transaction_purpose   = $request->transaction_purpose;
            $data->transaction_type      = $request->transaction_type;
            $data->account_id            = $request->account_id;
            $data->mobile_banking_id     = $request->mobile_banking_id;
            $data->payment_method        = $request->payment_method;
            $data->mobile_transaction_id = $request->mobile_transaction_id;
            $data->description           = $request->description;
            $data->created_by            = 1;
            $data->update();

            // $student = Student::with('departments')->findOrFail($data->student_id);
            // $name = $student->name ?? '';
            // $department = $student->departments->department_name ?? '';
            // $contact = $student->contact_no ?? '';
            // $email = $student->email ?? '';
            // $salary = $student->monthly_fee ?? '';
            // $bonus = $data->adjust_amount ?? '';
            // $receivedmount = $data->amount ?? '';
            // $month = Carbon::parse($data->salary_month)->format('F , Y');
            // $date = Carbon::parse($data->date)->format('d M, Y');
            // $totalSalary = is_numeric($receivedmount) + is_numeric($bonus) ;
            // $due = is_numeric($totalSalary) - is_numeric($receivedmount);

            // $msg = "Date : $date, Name : $name, Department : $department, E-mail : $email, Phone : $contact, Salary Month : $month, Salary : $salary, Adjust Amount : $bonus, Total Amount : $totalSalary, Salary Paid : $receivedmount, Salary Due : $due ";
            // $this->SendSms($contact, $msg);
            // if($data){
            //     $this->SendSms($contact, $msg);
            //     // Mail::to($email)->send(new SendEmail($tenant, $due));
            // }

            DB::commit();

            return Redirect::route('student-monthly-fees', array('id' => $data->student_id, 'month' => $data->fees_month))
                ->with('success', 'Fee collect updated successfully');

        } catch (\Exception $exception) {
            DB::rollBack();
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try{
            $data = Transaction::findOrFail($id);
            $data->delete();
            return response()->json([
                'success' => true,
                'message' => 'Fee collect deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Fee collect delete failed',
            ]);
        }
    }

    public function DueCollect($id)
    {
        $data = Transaction::with('students')->findOrFail($id);
        $banks = BankAccount::with('banks')->where('status', 1)->get();
        $mobilebanks = MobileBankingAccount::with('mobileBankings')->where('status', 1)->get();

        $total = DB::table('transactions')->where('student_id', $data->student_id)->where('fees_month', $data->fees_month)->whereNull('deleted_at')->whereIn('transaction_type', [2,3])->sum('total_amount');

        $receiveAmount = DB::table('transactions')->where('student_id', $data->student_id)->where('fees_month', $data->fees_month)->whereNull('deleted_at')->whereIn('transaction_type', [2,3])->sum('amount');

        $due = $total - $receiveAmount;

        return view('backend.students.fee_collect.due_collect', compact('data','banks','mobilebanks','due'));
    }

    public function DueEdit($id)
    {
        $data = Transaction::with('students')->findOrFail($id);
        $banks = BankAccount::with('banks')->where('status', 1)->get();
        $mobilebanks = MobileBankingAccount::with('mobileBankings')->where('status', 1)->get();
        $total = DB::table('transactions')->where('student_id', $data->student_id)->where('fees_month', $data->fees_month)->whereNull('deleted_at')->whereIn('transaction_type', [2,3])->sum('total_amount');

        $receiveAmount = DB::table('transactions')->where('student_id', $data->student_id)->where('fees_month', $data->fees_month)->whereNull('deleted_at')->whereIn('transaction_type', [2,3])->sum('amount');

        $due =  ($total + $data->amount)- $receiveAmount  ;

        return view('backend.students.fee_collect.due_edit', compact('data','banks','mobilebanks','due'));
    }

    public function FeesTransaction($id, $month)
    {
        try {
            $month = $month;
            $id = $id;
            $student = Transaction::with('students')->where('student_id', $id)->first();
            return view('backend.students.fee_collect.monthlyfee', compact('month','id','student'));
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function FeesList(Request $request)
    {
        try {
            if ($request->ajax()) {

                $data = DB::table('transactions')->where('student_id', $request->id)->where('fees_month', $request->month)->whereNull('deleted_at')->orderBy('id')->get();

                $totalAmount = DB::table('transactions')->where('student_id', $request->id)->where('fees_month', $request->month)->whereNull('deleted_at')->whereNull('deleted_at')->sum('amount');


                return Datatables::of($data)

                    ->addColumn('date', function ($data) {
                        $date = Carbon::parse($data->date)->format('d F, Y');
                        return $date;
                    })

                    ->addColumn('receiveFee', function ($data) {
                        $amount = $data->receive_fee;
                        return number_format($amount, 2);
                    })

                    ->addColumn('receiveExamFee', function ($data) {
                        $amount = $data->receive_exam_fee;
                        return number_format($amount, 2);
                    })

                    ->addColumn('receiveMealCost', function ($data) {
                        $amount = $data->receive_meal_cost;
                        return number_format($amount, 2);
                    })

                    ->addColumn('totalReceive', function ($data) {
                        $amount = $data->amount;
                        return number_format($amount, 2);
                    })

                    ->addColumn('collectionType', function ($data) {
                        if ($data->transaction_type == 2) {
                            $purpose = 'Fees Collect';
                        } elseif ($data->transaction_type == 3) {
                            $purpose = 'Due Collect';
                        } elseif ($data->transaction_type == 4) {
                            $purpose = 'Exam Fee Collect';
                        }elseif ($data->transaction_type == 5) {
                            $purpose = 'Meal Cost Collect';
                        }
                        return $purpose;
                    })


                    ->addColumn('action', function ($data) {

                        $result = '';

                        $details = '<li><a class="dropdown-item" href="' . route('fee-collect.show', $data->id) . ' " ><i class="fa fa-eye text-blue" ></i> Details</a></li>';

                        if($data->transaction_type == 2){
                            $edit = '<li><a class="dropdown-item" href="' . route('fee-collect.edit', $data->id) . ' "><i class="fa fa-edit text-green"></i> Edit</a></li>';
                        }else{
                            $edit = '<li><a class="dropdown-item" href="' . route('fee-due.edit', $data->id) . ' "><i class="fa fa-edit text-green"></i> Edit</a></li>';
                        }

                        $delete = '<li><a class="dropdown-item btn-delete" href="#" data-remote=" ' . route('fee-collect.destroy', $data->id) . ' "><i class="fa fa-trash text-red"></i> Delete</a></li>';


                        $result = $details . $edit . $delete;

                        return '<div class="btn-group open">
                        <a class="badge badge-primary dropdown-toggle" href="#" role="button"  data-toggle="dropdown">Actions<i class="ik ik-chevron-down mr-0 align-middle"></i></a>
                        <ul class="dropdown-menu" role="menu" style="width:auto; min-width:auto;">'.$result.'
                        </ul>
                    </div>';

                    })
                    ->with('totalAmount', number_format($totalAmount, 2))
                    ->addIndexColumn()
                    ->rawColumns(['date', 'receiveFee', 'receiveExamFee','receiveMealCost','totalReceive','collectionType','action'])
                    ->toJson();
            }

        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }
}
