<?php

namespace App\Http\Controllers\BackEnd;

use Carbon\Carbon;
use App\Traits\SmsTrait;
use App\Traits\DeleteTrait;
use Illuminate\Http\Request;
use App\Models\BackEnd\Student;
use App\Models\BackEnd\Department;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\BackEnd\MoneyReceipt;
use Yajra\DataTables\Facades\DataTables;

class MoneyReceiptController extends Controller
{
    use SmsTrait;
    use DeleteTrait;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function paymentlist(Request $request)
    {
        try {

        if ($request->ajax()) {

            $data = MoneyReceipt::with('students','departments')->get();

            return Datatables::of($data)

                ->addColumn('department', function ($data) {
                    $value = isset($data->students->class) ? $data->students->class->department_name : '--';
                    return $value;
                })

                ->addColumn('student', function ($data) {
                    $value = isset($data->students) ? $data->students->name : '--';
                    return $value;
                })

                ->addColumn('action', function ($data) {

                        $result = '';

                        $details = '<li><a class="dropdown-item" href="' . route('money-receipt.show', $data->id) . ' " ><i class="fa fa-eye" ></i> Details</a></li>';

                        $edit = '<li><a class="dropdown-item" href="' . route('money-receipt.edit', $data->id) . ' "><i class="fa fa-edit"></i> Edit</a></li>';

                        $delete = '<li><a class="dropdown-item btn-delete" href="#" data-remote=" ' . route('money-receipt.destroy', $data->id) . ' "><i class="fa fa-trash"></i> Delete</a></li>';

                        $result = $details. $edit. $delete;

                        return '<div class="btn-group open">
                        <a class="badge badge-primary dropdown-toggle" href="#" role="button"  data-toggle="dropdown">Actions<i class="ik ik-chevron-down mr-0 align-middle"></i></a>
                        <ul class="dropdown-menu" role="menu" style="width:auto; min-width:auto;">'.$result.'
                        </ul>
                    </div>';

                })

                ->addIndexColumn()
                ->rawColumns(['department','action','student'])
                ->toJson();
            }
        //  return view('backend.money_receipt.index');
         return view('backend.payments.index');
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $bn_numbers = ["১", "২", "৩", "৪", "৫", "৬", "৭", "৮", "৯", "০"];
        $en_numbers = ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0"];
        $id = MoneyReceipt::count();
        $receipt = str_replace($en_numbers, $bn_numbers,($id + 1));
        $departments = Department::where('status', 1)->get();
        return view('backend.money_receipt.create', compact('receipt', 'departments'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // $messages = array(
        //     'receipt_no.required' => 'Enter receipt no',
        //     'name.required' => 'Enter student name',
        //     'date.required' => 'Enter date',
        //     'amount.required' => 'Enter amount',
        //     'department_id.required' => 'Select class',
        //     'month.required' => 'Enter month',
        //     'received_purpose.required' => 'Enter on account of',
        // );

        // $this->validate($request, array(
        //     'receipt_no' => 'required',
        //     'date' => 'required',
        //     'name' => 'required',
        //     'amount' => 'required',
        //     'month' => 'required',
        //     'received_purpose' => 'required',
        // ), $messages);

        DB::beginTransaction();

        try {
            // $bn_numbers = ["১", "২", "৩", "৪", "৫", "৬", "৭", "৮", "৯", "০"];
            // $en_numbers = ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0"];

            $data = new MoneyReceipt();
            $data->student_id         = $request->student_id;
            $data->register_no        = $request->register_no;
            $data->date               = Carbon::parse($request->date)->format('Y-m-d');
            $data->name               = $request->name;
            $data->department_id      = $request->department_id;
            $data->month              = $request->month;
            $data->amount             = $request->amount;
            $data->note               = $request->note;
            $data->save();

            // $student = MoneyReceipt::with('students')->findOrFail($data->id);

            // $bn_months = ["জানুয়ারী", "ফেব্রুয়ারী ", "মার্চ", "এপ্রিল", "মে", "জুন", "জুলাই", "অগাস্ট", "সেপ্টেম্বর", "অক্টোবর", "নভেম্বর", "ডিসেম্বর"];

            // $en_months = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];

            // $date = str_replace($en_numbers, $bn_numbers, Carbon::parse($data->date)->format('d/m/Y'));
            // $month = str_replace($en_months, $bn_months, Carbon::parse($data->month)->format('F'));

            // $amount = $request->amount;
            // $phone = str_replace($bn_numbers, $en_numbers, $student->students->gurdian_mobile);
            // $mobile = str_replace($en_numbers, $bn_numbers, $student->students->gurdian_mobile);
            // $class = $student->students->departments->department_name;

            // if($student->students->student_type == 1){
            //     $type = 'আবাসিক';
            // }elseif($student->students->student_type == 2){
            //     $type = 'অনাবাসিক';
            // }

            // $msg = "দারুল উলুম সরকারপাড়া মাদরাসা, রিসিট নং : $request->receipt_no, তারিখ : $date, নাম : $student->name, ক্লাস : $class, ছাত্রের ধরন : $type, মোবাইল : $mobile, $student->received_purpose, আপনি $month মাসের $amount টাকা পরিশোধ করেছেন, জাযাকাল্লাহ । ";

            // $this->SendSms($phone, $msg);

            DB::commit();

            return redirect()->route('payment.list')
                ->with('success', 'Money received successfully');
        } catch (\Exception $exception) {
            DB::rollBack();
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $data = MoneyReceipt::with('students')->findOrFail($id);
        $bn_numbers = ["১", "২", "৩", "৪", "৫", "৬", "৭", "৮", "৯", "০"];
        $en_numbers = ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0"];

        $bn_months = ["জানুয়ারী", "ফেব্রুয়ারী ", "মার্চ", "এপ্রিল", "মে", "জুন", "জুলাই", "অগাস্ট", "সেপ্টেম্বর", "অক্টোবর", "নভেম্বর", "ডিসেম্বর"];

        $en_months = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];

        $receiptNo = str_replace($en_numbers, $bn_numbers, $data->receipt_no);
        $date = str_replace($en_numbers, $bn_numbers, Carbon::parse($data->date)->format('d/m/Y'));

        $monthFormat = Carbon::parse($data->month)->format('F, Y');

        $month1 = str_replace($en_numbers, $bn_numbers, $monthFormat);

        $month = str_replace($en_months, $bn_months, $month1);

        return view('backend.money_receipt.show', compact('data','receiptNo','date','month'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = MoneyReceipt::with('students')->findOrFail($id);
        $bn_numbers = ["১", "২", "৩", "৪", "৫", "৬", "৭", "৮", "৯", "০"];
        $en_numbers = ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0"];

        $receiptNo = str_replace($en_numbers, $bn_numbers, $data->receipt_no);
        $amount = str_replace($en_numbers, $bn_numbers, $data->amount);
        return view('backend.money_receipt.edit', compact('data','receiptNo','amount'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $messages = array(
            'receipt_no.required' => 'Enter receipt no',
            'name.required' => 'Enter student name',
            'date.required' => 'Enter date',
            'amount.required' => 'Enter amount',
            'department_id.required' => 'Select class ',
            'month.required' => 'Enter month',
            'received_purpose.required' => 'Write on account of',
        );

        $this->validate($request, array(
            'receipt_no' => 'required',
            'date' => 'required',
            'name' => 'required',
            'amount' => 'required',
            'month' => 'required',
            'received_purpose' => 'required',
        ), $messages);

        DB::beginTransaction();

        try {
            $bn_numbers = ["১", "২", "৩", "৪", "৫", "৬", "৭", "৮", "৯", "০"];
            $en_numbers = ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0"];

            $data = MoneyReceipt::with('students')->findOrFail($id);
            $data->student_id         = $request->student_id;
            $data->receipt_no         = str_replace($bn_numbers, $en_numbers, $request->receipt_no);
            $data->register_no        = $request->register_no;
            $data->date               = Carbon::parse($request->date)->format('Y-m-d');
            $data->name               = $request->name;
            $data->department_id      = $request->department_id;
            $data->month              = str_replace($bn_numbers, $en_numbers, $request->month);
            $data->amount             = str_replace($bn_numbers, $en_numbers, $request->amount);
            $data->in_word            = $request->in_word;
            $data->received_purpose   = $request->received_purpose;
            $data->note               = $request->note;
            $data->update();

            $bn_months = ["জানুয়ারী", "ফেব্রুয়ারী ", "মার্চ", "এপ্রিল", "মে", "জুন", "জুলাই", "অগাস্ট", "সেপ্টেম্বর", "অক্টোবর", "নভেম্বর", "ডিসেম্বর"];

            $en_months = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];

            $date = str_replace($en_numbers, $bn_numbers, Carbon::parse($data->date)->format('d/m/Y'));
            $month = str_replace($en_months, $bn_months, Carbon::parse($data->month)->format('F'));

            $amount = $request->amount;
            $phone = str_replace($bn_numbers, $en_numbers, $data->students->gurdian_mobile);
            $mobile = str_replace($en_numbers, $bn_numbers, $data->students->gurdian_mobile);
            $class = $data->students->departments->department_name;

            if($data->students->student_type == 1){
                $type = 'আবাসিক';
            }elseif($data->students->student_type == 2){
                $type = 'অনাবাসিক';
            }


            $msg = "দারুল উলুম সরকারপাড়া মাদরাসা, রিসিট নং : $request->receipt_no, তারিখ : $date, নাম : $data->name, ক্লাস : $class, ছাত্রের ধরন : $type, মোবাইল : $mobile, $request->received_purpose, আপনি $month মাসের $amount টাকা পরিশোধ করেছেন তা আপডেট করা হলো, জাযাকাল্লাহ । ";

            $this->SendSms($phone, $msg);

            DB::commit();

            return redirect()->route('money-receipt.show', $data->id)
                ->with('success', 'Money received updated successfully');
        } catch (\Exception $exception) {
            DB::rollBack();
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try{
            $data = MoneyReceipt::findOrFail($id);
            $data->delete();
            return response()->json([
                'success' => true,
                'message' => 'Money receipt deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Money receipt delete failed',
            ]);
        }
    }
    public function print($id)
    {
        $data = MoneyReceipt::with('students')->findOrFail($id);

        $bn_numbers = ["১", "২", "৩", "৪", "৫", "৬", "৭", "৮", "৯", "০"];
        $en_numbers = ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0"];

        $receiptNo = str_replace($en_numbers, $bn_numbers, $data->receipt_no);
        $month = str_replace($en_numbers, $bn_numbers, Carbon::parse($data->month)->format('m/ Y'));
        $amount = str_replace($en_numbers, $bn_numbers, $data->amount);

        $date = str_replace($en_numbers, $bn_numbers, Carbon::parse($data->date)->format('d/m/Y'));

        $bn_months = ["জানুয়ারী", "ফেব্রুয়ারী ", "মার্চ", "এপ্রিল", "মে", "জুন", "জুলাই", "অগাস্ট", "সেপ্টেম্বর", "অক্টোবর", "নভেম্বর", "ডিসেম্বর"];

        $en_months = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];

        $receiptNo = str_replace($en_numbers, $bn_numbers, $data->receipt_no);
        $date = str_replace($en_numbers, $bn_numbers, Carbon::parse($data->date)->format('d/m/Y'));

        $monthFormat = Carbon::parse($data->month)->format('F, Y');

        $month1 = str_replace($en_numbers, $bn_numbers, $monthFormat);

        $month = str_replace($en_months, $bn_months, $month1);

        return view('backend.money_receipt.print', compact('data','receiptNo','date','month','amount'));
    }

    // public function paymentlist()
    // {
    //     return view('backend.payments.index');
    // }

    public function paymentcreate()
    {
        $students = Student::with('class')->get();
        return view('backend.payments.create',compact('students'));
    }
}
