<?php

namespace App\Http\Controllers\BackEnd;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\BackEnd\MoneyReceipt;
use Carbon\Carbon;
use Yajra\DataTables\Facades\DataTables;

class ReportController extends Controller
{
    public function revenue(Request $request)
    {
        try {

        if ($request->ajax()) {

            $data = MoneyReceipt::with('students','departments')->orderBy('id', 'DESC');

            return Datatables::of($data)

                ->addColumn('date', function ($data) {
                    $date = Carbon::parse($data->date)->format('d F, Y');
                    return $date;
                })
                ->addColumn('class', function ($data) {
                    $class = isset($data->students->departments) ? $data->departments->department_name : '--';
                    return $class;
                })

                ->addColumn('name', function ($data) {
                    $name = isset($data->students) ? $data->students->name : '--';
                    return $name;
                })

                ->addColumn('amount', function ($data) {
                    $bn_numbers = ["১", "২", "৩", "৪", "৫", "৬", "৭", "৮", "৯", "০"];
                    $en_numbers = ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0"];
                    $amount = str_replace($en_numbers, $bn_numbers, number_format($data->amount));
                    return $amount;

                })

                ->addIndexColumn()
                ->rawColumns(['date','class','name','amount'])
                ->toJson();
            }
         return view('backend.report.revenue');
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }
}
