<?php
namespace App\Http\Controllers;

use App\Models\AdmissionFee;
use App\Models\AdmitCard;
use App\Models\AttendanceSetting;
use App\Models\DataDelete;
use App\Models\DeviceSetting;
use App\Models\ExamRouting;
use App\Models\ExamRoutingDetails;
use App\Models\ExamSeat;
use App\Models\ExamWiseGrades;
use App\Models\FundType;
use App\Models\HelpLine;
use App\Models\InvoiceDesign;
use App\Models\Licence;
use App\Models\Notice;
use App\Models\Setting;
use App\Models\Shop;
use App\Models\SmsSetting;
use App\Models\SmsStatus;
use App\Models\Student;
use App\Models\StudentClass;
use App\Models\StudentComment;
use App\Models\StudentExam;
use App\Models\StudentSection;
use App\Models\StudentSession;
use App\Models\Subject;
use App\Models\SubjectAssign;
use App\Models\SubjectGrade;
//grade mark update by ashiq 21.05.25
use App\Models\SubjectWiseGrades;
//grade mark update by ashiq end 21.05.25
use App\Models\TeacherResponsibility;
use App\Models\User;
use App\Traits\DeleteTrait;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Yajra\DataTables\Facades\DataTables;

class SettingController extends Controller
{
    use DeleteTrait;

    public function SiteSettings()
    {
        try {
            $data = Setting::first();
            return view('dashboard.settings.site_setting', compact('data'));
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function SettingStore(Request $request)
    {
        try {
            if (! $request->id) {
                $request->validate([
                    'name'      => 'required',
                    'long_name' => 'required',
                    'website'   => 'required',
                    'email'     => 'required',
                    'phone'     => 'required',
                    'address'   => 'required',
                    'favicon'   => 'required',
                    'logo'      => 'required',
                ]);

                $data = new Setting();
            } else {
                $data = Setting::findOrFail($request->id);
            }
            if ($request->file('logo')) {
                $file     = $request->file('logo');
                $filename = time() . $file->getClientOriginalName();
                $file->move(public_path('/img/'), $filename);
                $data->logo = $filename;
            }
            if ($request->file('favicon')) {
                $file            = $request->file('favicon');
                $filenamefavicon = time() . $file->getClientOriginalName();
                $file->move(public_path('/img/'), $filenamefavicon);
                $data->favicon = $filenamefavicon;
            }
            $data->name      = $request->name;
            $data->long_name = $request->long_name;
            $data->website   = $request->website;
            $data->email     = $request->email;
            $data->phone     = $request->phone;
            $data->address   = $request->address;
            $data->map       = $request->map;

            if (! $request->id) {
                $data->save();
                return redirect()->route('site.settings')->with('success', ' Site settings created successfull');
            } else {
                $data->update();
                return redirect()->route('site.settings')->with('success', 'Site settings updated successfull');
            }
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }
    public function DataDelete()
    {
        try {
            $data = DataDelete::first();
            return view('dashboard.settings.data_delete', compact('data'));
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function DataDeleteStore(Request $request)
    {
        try {
            $request->validate([
                'day' => 'required',
            ]);

            $data       = new DataDelete();
            $data->day  = $request->day;
            $data->date = now()->format('Y-m-d');
            $data->save();

            return redirect()->back()->with('success', ' Settings created successfull');
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }
    public function PasswordChange()
    {
        try {
            $data = User::findOrFail(Auth::user()->id);
            return view('dashboard.settings.password_change', compact('data'));
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function PasswordChangeStore(Request $request)
    {
        try {

            $request->validate([
                'old_pass'     => 'required',
                'password'     => 'required|min:6',
                'confirm_pass' => 'required|same:password',
            ]);

            $data = User::findOrFail(Auth::user()->id);

            if ($request->old_pass != $data->show_pass) {
                return redirect()->back()->with('error', 'Old password does not match');
            }
            if ($request->password != $request->confirm_pass) {
                return redirect()->back()->with('error', 'Password and confirm password do not match');
            }

            $data->password  = Hash::make($request->password);
            $data->show_pass = $request->password;
            $data->save();

            return redirect()->route('password.change')->with('success', 'Password changed successfully');
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', 'An error occurred: ' . $exception->getMessage());
        }
    }
    public function InvoiceDesign()
    {
        try {
            $data = InvoiceDesign::first();
            return view('dashboard.settings.invoice_design', compact('data'));
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function GetInvoiceDesign()
    {
        try {
            $invoice = InvoiceDesign::first();
            return response()->json([
                'header' => $invoice->invoice_header,
                'footer' => $invoice->invoice_footer,
            ]);
        } catch (\Exception $exception) {
            return response()->json(['error' => $exception->getMessage()], 500);
        }
    }

    public function InvoiceDesignStore(Request $request)
    {
        try {
            if (! $request->id) {
                $data = new InvoiceDesign();
            } else {
                $data = InvoiceDesign::findOrFail($request->id);
            }

            // Handle header image
            if ($request->hasFile('invoice_header')) {
                // Delete old file if exists
                if ($data->invoice_header && file_exists(public_path('img/' . $data->invoice_header))) {
                    unlink(public_path('img/' . $data->invoice_header));
                }

                $file  = $request->file('invoice_header');
                $image = time() . $file->getClientOriginalName();
                $file->move(public_path('img'), $image);
                $data->invoice_header = $image;
            }
            // Don't set to null if no file is uploaded - preserve existing value

            // Handle footer image
            if ($request->hasFile('invoice_footer')) {
                // Delete old file if exists
                if ($data->invoice_footer && file_exists(public_path('img/' . $data->invoice_footer))) {
                    unlink(public_path('img/' . $data->invoice_footer));
                }

                $file  = $request->file('invoice_footer');
                $image = time() . $file->getClientOriginalName();
                $file->move(public_path('img'), $image);
                $data->invoice_footer = $image;
            }
            // Don't set to null if no file is uploaded - preserve existing value

            // Handle background image
            if ($request->hasFile('invoice_bg')) {
                // Delete old file if exists
                if ($data->invoice_bg && file_exists(public_path('img/' . $data->invoice_bg))) {
                    unlink(public_path('img/' . $data->invoice_bg));
                }

                $file  = $request->file('invoice_bg');
                $image = time() . $file->getClientOriginalName();
                $file->move(public_path('img'), $image);
                $data->invoice_bg = $image;
            }
            // Don't set to null if no file is uploaded - preserve existing value

            // For new records, set default null values if no files were uploaded
            if (! $request->id) {
                if (! $request->hasFile('invoice_header')) {
                    $data->invoice_header = null;
                }
                if (! $request->hasFile('invoice_footer')) {
                    $data->invoice_footer = null;
                }
                if (! $request->hasFile('invoice_bg')) {
                    $data->invoice_bg = null;
                }
            }

            if (! $request->id) {
                $data->save();
                return redirect()->back()->with('success', 'Data created successfully');
            } else {
                $data->update();
                return redirect()->back()->with('success', 'Data updated successfully');
            }
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }
    public function AdmissionFee()
    {
        try {
            $data = AdmissionFee::first();
            return view('dashboard.settings.admission_fee', compact('data'));
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function AdmissionFeeStore(Request $request)
    {
        try {

            if (! $request->id) {
                $data = new AdmissionFee();
            } else {
                $data = AdmissionFee::findOrFail($request->id);
            }

            $data->amount = $request->amount;

            if (! $request->id) {
                $data->save();
                return redirect()->back()->with('success', 'Fee created successfully');
            } else {
                $data->update();
                return redirect()->back()->with('success', 'Fee updated successfully');
            }
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function StudentSession(Request $request)
    {
        try {
            if ($request->ajax()) {
                $data = DB::table('student_sessions')
                    ->whereNull('deleted_at')
                    ->orderBy('id', 'desc')
                    ->get();

                return Datatables::of($data)
                    ->addColumn('action', function ($data) {
                        $edit = '<a id="edit" href="' . route('student.session.edit', $data->id) . '" class="btn btn-sm btn-primary edit" title="Edit" data-toggle="modal" data-target="#editClass"><i class="fa fa-edit"></i></a>';

                        $delete = '';

                        if ($this->DeleteData()) {
                            $delete = '<button id="messageShow" class="btn btn-sm btn-danger btn-delete" data-remote="' . route('student.session.destroy', $data->id) . '" title="Delete"><i class="fa fa-trash-alt"></i></button>';
                        }

                        return $edit . ' ' . $delete;
                    })
                    ->addIndexColumn()
                    ->rawColumns(['action'])
                    ->toJson();
            }

            return view('dashboard.settings.student_session');
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function StudentSessionStore(Request $request)
    {
        if ($request->ajax()) {

            $data = Validator::make($request->all(), [
                'name' => 'required|string|unique:student_sessions,name,NULL,id,deleted_at,NULL',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }

            try {
                $data             = new StudentSession();
                $data->name       = $request->name;
                $data->created_by = Auth::user()->id;
                $data->save();

                return response()->json([
                    'success' => true,
                    'message' => 'Session created successfully',
                ]);
            } catch (\Exception $exception) {
                return response()->json([
                    'success' => true,
                    'message' => $exception->getMessage(),
                ]);
            }
        }
    }

    public function StudentSessionEdit($id)
    {
        $data = StudentSession::findOrFail($id);
        return response()->json($data);
    }

    public function StudentSessionUpdate(Request $request, $id)
    {
        $data = Validator::make($request->all(), [
            'name' => 'required|string|unique:student_sessions,name,' . $id . ',id,deleted_at,NULL',
        ]);

        if ($data->fails()) {
            return response()->json([
                'success' => false,
                'message' => $data->errors()->all(),
            ]);
        }

        try {
            $data             = StudentSession::findOrFail($id);
            $data->name       = $request->name;
            $data->updated_by = Auth::user()->id;
            $data->update();

            return response()->json([
                'success' => true,
                'message' => 'Session updated successfully',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => $exception->getMessage(),
            ]);
        }
    }

    public function StudentSessionDestroy($id)
    {
        try {
            $data = StudentSession::findOrFail($id);

            $tables = DB::select("
                SELECT TABLE_NAME
                FROM INFORMATION_SCHEMA.COLUMNS
                WHERE COLUMN_NAME = 'session_id'
                AND TABLE_SCHEMA = DATABASE()
            ");

            foreach ($tables as $table) {
                if ($table->TABLE_NAME !== 'student_sessions') {
                    DB::table($table->TABLE_NAME)->where('session_id', $data->id)->delete();
                }
            }

            $data->delete();

            return response()->json([
                'success' => true,
                'message' => 'Session and all related data deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Session delete failed.',
                'error'   => $exception->getMessage(),
            ]);
        }
    }

    public function StudentSection(Request $request)
    {
        try {
            if ($request->ajax()) {
                $data = DB::table('student_sections')
                    ->whereNull('deleted_at')
                    ->orderBy('id', 'desc')->get();

                return Datatables::of($data)

                    ->addColumn('action', function ($data) {

                        $edit = '<a id="edit" href="' . route('student.section.edit', $data->id) . ' " class="btn btn-sm btn-primary edit" title="Edit" data-toggle="modal" data-target="#editClass"><i class="fa fa-edit"></i></a> ';

                        $delete = '<button id="messageShow" class="btn btn-sm btn-danger btn-delete" data-remote=" ' . route('student.section.destroy', $data->id) . ' " title="Delete"><i class="fa fa-trash-alt"></i></button>';

                        return $edit . $delete;
                    })

                    ->addIndexColumn()
                    ->rawColumns(['action'])
                    ->toJson();
            }
            return view('dashboard.settings.student_section');
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function StudentSectionStore(Request $request)
    {
        if ($request->ajax()) {

            $data = Validator::make($request->all(), [
                'name' => 'required|string|unique:student_sections,name,NULL,id,deleted_at,NULL',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }

            try {
                $data             = new StudentSection();
                $data->name       = $request->name;
                $data->created_by = Auth::user()->id;
                $data->save();

                return response()->json([
                    'success' => true,
                    'message' => 'Section created successfully',
                ]);
            } catch (\Exception $exception) {
                return response()->json([
                    'success' => true,
                    'message' => $exception->getMessage(),
                ]);
            }
        }
    }

    public function StudentSectionEdit($id)
    {
        $data = StudentSection::findOrFail($id);
        return response()->json($data);
    }

    public function StudentSectionUpdate(Request $request, $id)
    {
        $data = Validator::make($request->all(), [
            'name' => 'required|string|unique:student_sections,name,' . $id . ',id,deleted_at,NULL',
        ]);

        if ($data->fails()) {
            return response()->json([
                'success' => false,
                'message' => $data->errors()->all(),
            ]);
        }

        try {
            $data             = StudentSection::findOrFail($id);
            $data->name       = $request->name;
            $data->updated_by = Auth::user()->id;
            $data->update();

            return response()->json([
                'success' => true,
                'message' => 'Section updated successfully',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => $exception->getMessage(),
            ]);
        }
    }
    public function StudentSectionDestroy($id)
    {
        try {
            $data = StudentSection::findOrFail($id);
            Student::where('section_id', $data->id)->delete();
            $data->delete();
            return response()->json([
                'success' => true,
                'message' => 'Section deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Section delete failed',
            ]);
        }
    }
    public function FundType(Request $request)
    {
        try {
            if ($request->ajax()) {
                $data = DB::table('fund_types')
                    ->whereNull('deleted_at')
                    ->orderBy('id', 'desc')->get();

                return Datatables::of($data)

                    ->addColumn('action', function ($data) {

                        $edit = '<a id="edit" href="' . route('fund.type.edit', $data->id) . ' " class="btn btn-sm btn-primary edit" title="Edit" data-toggle="modal" data-target="#editClass"><i class="fa fa-edit"></i></a> ';

                        $delete = '<button id="messageShow" class="btn btn-sm btn-danger btn-delete" data-remote=" ' . route('fund.type.destroy', $data->id) . ' " title="Delete"><i class="fa fa-trash-alt"></i></button>';

                        return $edit . $delete;
                    })

                    ->addIndexColumn()
                    ->rawColumns(['action'])
                    ->toJson();
            }
            return view('dashboard.settings.fund_type');
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function FundTypeStore(Request $request)
    {
        if ($request->ajax()) {

            $data = Validator::make($request->all(), [
                'name' => 'required|string|unique:fund_types,name,NULL,id,deleted_at,NULL',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }

            try {
                $data             = new FundType();
                $data->name       = $request->name;
                $data->created_by = Auth::user()->id;
                $data->save();

                return response()->json([
                    'success' => true,
                    'message' => 'Fund type created successfully',
                ]);
            } catch (\Exception $exception) {
                return response()->json([
                    'success' => false,
                    'message' => $exception->getMessage(),
                ]);
            }
        }
    }

    public function FundTypeEdit($id)
    {
        $data = FundType::findOrFail($id);
        return response()->json($data);
    }

    public function FundTypeUpdate(Request $request, $id)
    {
        $data = Validator::make($request->all(), [
            'name' => 'required|string|unique:fund_types,name,' . $id . ',id,deleted_at,NULL',
        ]);

        if ($data->fails()) {
            return response()->json([
                'success' => false,
                'message' => $data->errors()->all(),
            ]);
        }

        try {
            $data             = FundType::findOrFail($id);
            $data->name       = $request->name;
            $data->updated_by = Auth::user()->id;
            $data->update();

            return response()->json([
                'success' => true,
                'message' => 'Fund type updated successfully',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => $exception->getMessage(),
            ]);
        }
    }
    public function FundTypeDestroy($id)
    {
        try {
            $data = FundType::findOrFail($id);
            $data->delete();
            return response()->json([
                'success' => true,
                'message' => 'Fund type deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Fund type delete failed',
            ]);
        }
    }

    public function StudentClass(Request $request)
    {
        try {
            if ($request->ajax()) {
                $data = DB::table('student_classes')
                    ->whereNull('deleted_at')
                    ->orderBy('id', 'desc')->get();

                return Datatables::of($data)

                    ->addColumn('new_admission_amount', function ($data) {
                        return $data->new_admission_amount ?? '';
                    })
                    ->addColumn('old_admission_amount', function ($data) {
                        return $data->old_admission_amount ?? '';
                    })

                    ->addColumn('action', function ($data) {

                        $edit   = '<a id="edit" href="' . route('student.class.edit', $data->id) . ' " class="btn btn-sm btn-primary edit" title="Edit" data-toggle="modal" data-target="#editClass"><i class="fa fa-edit"></i></a> ';
                        $delete = '';
                        if ($this->DeleteData()) {
                            $delete = '<button id="messageShow" class="btn btn-sm btn-danger btn-delete" data-remote=" ' . route('student.class.destroy', $data->id) . ' " title="Delete"><i class="fa fa-trash-alt"></i></button>';
                        }

                        return $edit . $delete;
                    })

                    ->addIndexColumn()
                    ->rawColumns(['action', 'new_admission_amount', 'old_admission_amount'])
                    ->toJson();
            }
            return view('dashboard.settings.student_class');
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function StudentClassStore(Request $request)
    {
        if ($request->ajax()) {

            $data = Validator::make($request->all(), [
                'name' => 'required|string|unique:student_classes,name,NULL,id,deleted_at,NULL',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }

            try {
                $data                       = new StudentClass();
                $data->name                 = $request->name;
                $data->new_admission_amount = $request->new_admission_amount;
                $data->old_admission_amount = $request->old_admission_amount;
                $data->created_by           = Auth::user()->id;
                $data->save();

                return response()->json([
                    'success' => true,
                    'message' => 'Class created successfully',
                ]);
            } catch (\Exception $exception) {
                return response()->json([
                    'success' => true,
                    'message' => $exception->getMessage(),
                ]);
            }
        }
    }

    public function StudentClassEdit($id)
    {
        $data = StudentClass::findOrFail($id);
        return response()->json($data);
    }

    public function StudentClassUpdate(Request $request, $id)
    {
        $data = Validator::make($request->all(), [
            'name' => 'required|string|unique:student_classes,name,' . $id . ',id,deleted_at,NULL',
        ]);

        if ($data->fails()) {
            return response()->json([
                'success' => false,
                'message' => $data->errors()->all(),
            ]);
        }

        try {
            $data                       = StudentClass::findOrFail($id);
            $data->name                 = $request->name;
            $data->new_admission_amount = $request->new_admission_amount;
            $data->old_admission_amount = $request->old_admission_amount;
            $data->updated_by           = Auth::user()->id;
            $data->update();

            return response()->json([
                'success' => true,
                'message' => 'Class updated successfully',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => $exception->getMessage(),
            ]);
        }
    }
    public function StudentClassDestroy($id)
    {
        try {
            $class = StudentClass::findOrFail($id);
            Student::where('class_id', $class->id)->delete();

            $tables = DB::select("
            SELECT TABLE_NAME
            FROM INFORMATION_SCHEMA.COLUMNS
            WHERE COLUMN_NAME = 'class_id'
            AND TABLE_SCHEMA = DATABASE()
            ");

            foreach ($tables as $table) {
                if ($table->TABLE_NAME !== 'student_classes') {
                    DB::table($table->TABLE_NAME)->where('class_id', $class->id)->delete();
                }
            }

            $class->delete();

            return response()->json([
                'success' => true,
                'message' => 'Class deleted successfully.',
            ]);
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return response()->json([
                'success' => false,
                'message' => 'Class not found.',
            ], 404);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Failed to delete class.',
                'error'   => $e->getMessage(),
            ], 500);
        }
    }

    public function exam(Request $request)
    {
        try {
            if ($request->ajax()) {
                $data = DB::table('student_exams')
                    ->whereNull('deleted_at')
                    ->orderBy('id', 'desc')->get();

                return Datatables::of($data)

                    ->addColumn('action', function ($data) {

                        $edit = '<a id="edit" href="' . route('exam.edit', $data->id) . ' " class="btn btn-sm btn-primary edit" title="Edit" data-toggle="modal" data-target="#editClass"><i class="fa fa-edit"></i></a> ';

                        $delete = '';
                        if ($this->DeleteData()) {
                            $delete = '<button id="messageShow" class="btn btn-sm btn-danger btn-delete" data-remote=" ' . route('exam.destroy', $data->id) . ' " title="Delete"><i class="fa fa-trash-alt"></i></button>';
                        }

                        return $edit . $delete;
                    })

                    ->addIndexColumn()
                    ->rawColumns(['action'])
                    ->toJson();
            }
            return view('dashboard.settings.exam');
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function ExamStore(Request $request)
    {
        if ($request->ajax()) {

            $data = Validator::make($request->all(), [
                'name' => 'required|string|unique:student_exams,name,NULL,id,deleted_at,NULL',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }

            try {
                $data             = new StudentExam();
                $data->name       = $request->name;
                $data->created_by = Auth::user()->id;
                $data->save();

                return response()->json([
                    'success' => true,
                    'message' => 'Exam created successfully',
                ]);
            } catch (\Exception $exception) {
                return response()->json([
                    'success' => false,
                    'message' => $exception->getMessage(),
                ]);
            }
        }
    }

    public function ExamEdit($id)
    {
        $data = StudentExam::findOrFail($id);
        return response()->json($data);
    }

    public function ExamUpdate(Request $request, $id)
    {
        $data = Validator::make($request->all(), [
            'name' => 'required|string|unique:student_exams,name,' . $id . ',id,deleted_at,NULL',
        ]);

        if ($data->fails()) {
            return response()->json([
                'success' => false,
                'message' => $data->errors()->all(),
            ]);
        }

        try {
            $data             = StudentExam::findOrFail($id);
            $data->name       = $request->name;
            $data->updated_by = Auth::user()->id;
            $data->update();

            return response()->json([
                'success' => true,
                'message' => 'Exam updated successfully',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => $exception->getMessage(),
            ]);
        }
    }
    public function ExamDestroy($id)
    {
        try {
            $data = StudentExam::findOrFail($id);

            // Delete related ExamSeats
            ExamSeat::where('exam_id', $data->id)->delete();

            // Delete related AdmitCards
            AdmitCard::where('exam_id', $data->id)->delete();

            // Delete related ExamRoutings and their details
            $exam_routings = ExamRouting::where('exam_id', $data->id)->get();

            foreach ($exam_routings as $routing) {
                // Delete related details
                $routing->details()->delete();
                // Delete routing
                $routing->delete();
            }

            // Delete related StudentComments
            StudentComment::where('exam_id', $data->id)->delete();

            // Finally, delete the exam
            $data->delete();

            return response()->json([
                'success' => true,
                'message' => 'Exam deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Exam delete failed: ' . $exception->getMessage(),
            ]);
        }
    }

    public function subject(Request $request)
    {
        try {
            if ($request->ajax()) {
                $data = DB::table('subjects')
                    ->whereNull('deleted_at')
                    ->orderBy('id', 'desc')->get();

                return Datatables::of($data)

                    ->addColumn('name', function ($data) {
                        $name = $data->name ?? '';
                        $part = $data->part ?? '';
                        return ! empty($part) ? $name . '<br>' . $part : $name;
                    })

                    ->addColumn('action', function ($data) {

                        $edit = '<a id="edit" href="' . route('subject.edit', $data->id) . ' " class="btn btn-sm btn-primary edit" title="Edit" data-toggle="modal" data-target="#editClass"><i class="fa fa-edit"></i></a> ';

                        $delete = '';
                        if ($this->DeleteData()) {
                            $delete = '<button id="messageShow" class="btn btn-sm btn-danger btn-delete" data-remote=" ' . route('subject.destroy', $data->id) . ' " title="Delete"><i class="fa fa-trash-alt"></i></button>';
                        }

                        return $edit . $delete;
                    })

                    ->addIndexColumn()
                    ->rawColumns(['name', 'action'])
                    ->toJson();
            }
            return view('dashboard.settings.student_subject');
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function SubjectStore(Request $request)
    {
        if ($request->ajax()) {
            $data = Validator::make($request->all(), [
                'name' => 'required|string|unique:subjects,name,NULL,id,deleted_at,NULL',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }

            try {
                $data             = new Subject();
                $data->name       = $request->name;
                $data->code       = $request->code;
                $data->writer     = $request->writer;
                $data->part       = $request->part ?? '';
                $data->created_by = Auth::user()->id;
                $data->save();

                return response()->json([
                    'success' => true,
                    'message' => 'Subject created successfully',
                ]);
            } catch (\Exception $exception) {
                return response()->json([
                    'success' => false,
                    'message' => $exception->getMessage(),
                ]);
            }
        }
    }

    public function SubjectEdit($id)
    {
        $data = Subject::findOrFail($id);
        return response()->json($data);
    }

    public function SubjectUpdate(Request $request, $id)
    {
        $data = Validator::make($request->all(), [
            'name' => 'required|string|unique:subjects,name,' . $id . ',id,deleted_at,NULL',
        ]);

        if ($data->fails()) {
            return response()->json([
                'success' => false,
                'message' => $data->errors()->all(),
            ]);
        }

        try {
            $subject             = Subject::findOrFail($id);
            $subject->name       = $request->name;
            $subject->code       = $request->code;
            $subject->writer     = $request->writer;
            $subject->part       = $request->part ?? '';
            $subject->updated_by = Auth::user()->id;
            $subject->save();

            return response()->json([
                'success' => true,
                'message' => 'Subject updated successfully',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => $exception->getMessage(),
            ]);
        }
    }

    public function SubjectDestroy($id)
    {
        try {
            $data = Subject::findOrFail($id);

            $tables = DB::select("
            SELECT TABLE_NAME
            FROM INFORMATION_SCHEMA.COLUMNS
            WHERE COLUMN_NAME = 'subject_id'
            AND TABLE_SCHEMA = DATABASE()
            ");

            foreach ($tables as $table) {
                if ($table->TABLE_NAME !== 'subjects') {
                    DB::table($table->TABLE_NAME)->where('subject_id', $data->id)->delete();
                }
            }

            $data->delete();
            return response()->json([
                'success' => true,
                'message' => 'Subject deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Subject delete failed',
            ]);
        }
    }
    public function SubjectGrade(Request $request)
    {
        try {
            if ($request->ajax()) {
                $data = DB::table('subject_grades')
                    ->whereNull('deleted_at')
                    ->orderBy('id', 'desc')->get();

                return Datatables::of($data)

                    ->addColumn('name', function ($data) {
                        $name = $data->name ?? '';
                        return $name;
                    })

                    ->addColumn('mark', function ($data) {
                        $mark = $data->mark ?? '';
                        return $mark;
                    })
                    ->addColumn('gpa', function ($data) {
                        $gpa = $data->gpa ?? '';
                        return $gpa;
                    })

                    ->addColumn('action', function ($data) {

                        $edit = '<a id="edit" href="' . route('subject.grade.edit', $data->id) . ' " class="btn btn-sm btn-primary edit" title="Edit" data-toggle="modal" data-target="#editClass"><i class="fa fa-edit"></i></a> ';

                        $delete = '<button id="messageShow" class="btn btn-sm btn-danger btn-delete" data-remote=" ' . route('subject.grade.destroy', $data->id) . ' " title="Delete"><i class="fa fa-trash-alt"></i></button>';

                        return $edit . $delete;
                    })

                    ->addIndexColumn()
                    ->rawColumns(['name', 'action', 'mark', 'gpa'])
                    ->toJson();
            }
            return view('dashboard.settings.grade');
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }
    //grade mark update by ashiq 21.05.25
    public function SubjectWiseGrade(Request $request)
    {
        try {
            if ($request->ajax()) {
                $data = DB::table('subject_wise_grades')
                    ->whereNull('deleted_at')
                    ->orderBy('id', 'desc')
                    ->groupBy('exam_id')
                    ->get();
                // dd($data);

                return Datatables::of($data)

                    ->addColumn('exam', function ($data) {
                        $exam = StudentExam::find($data->exam_id);
                        return $exam->name ?? 'N/A';
                    })

                    ->addColumn('action', function ($data) {
                        return '<a href="' . route('subject.wise.grade.exam', $data->exam_id) . '" class="btn btn-sm btn-info view-exam" data-id="' . $data->exam_id . '">View</a>';
                    })
                    ->addIndexColumn()
                    ->rawColumns(['action'])
                    ->toJson();
            }

            $data['classes'] = StudentClass::whereNull('deleted_at')->get();
            $data['exams']   = StudentExam::whereNull('deleted_at')->get();

            $data['sessions'] = StudentSession::whereNull('deleted_at')->get();
            $data['subjects'] = Subject::whereNull('deleted_at')->get();
            return view('dashboard.settings.examwise_grade_group', $data);
            // return view('dashboard.settings.subject_wise_grade', $data);
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function subjectWiseGradeByExam(Request $request, $examId)
    {
        try {
            if ($request->ajax()) {
                $data = DB::table('subject_wise_grades')
                    ->whereNull('deleted_at')
                    ->where('exam_id', $examId)
                    ->orderBy('id', 'desc')

                    ->get();
                // dd($data);

                return Datatables::of($data)
                    ->addColumn('subject', function ($data) {
                        $subject = Subject::find($data->subject_id);
                        return $subject->name ?? 'N/A';
                    })
                    ->addColumn('exam', function ($data) {
                        $exam = StudentExam::find($data->exam_id);
                        return $exam->name ?? 'N/A';
                    })
                    ->addColumn('class', function ($data) {
                        $class = StudentClass::find($data->class_id);
                        return $class->name ?? 'N/A';
                    })
                    ->addColumn('session', function ($data) {
                        $session = StudentSession::find($data->session_id);
                        return $session->name ?? 'N/A';
                    })
                    ->addColumn('exam_mark', function ($data) {
                        return $data->exam_mark ?? '';
                    })

                    ->addColumn('action', function ($data) {
                        $edit   = '<a id="edit" href="' . route('subject.wise.grade.edit', $data->id) . '" class="btn btn-sm btn-primary edit" title="Edit" data-toggle="modal" data-target="#editClass"><i class="fa fa-edit"></i></a>';
                        $delete = '<button  id="messageShow" class="btn btn-sm btn-danger btn-delete" data-remote="' . route('subject.wise.grade.destroy', $data->id) . '" title="Delete"><i class="fa fa-trash-alt"></i></button>';
                        return $edit . ' ' . $delete;
                    })
                    ->addIndexColumn()
                    ->rawColumns(['action'])
                    ->toJson();
            }

            $data['classes']  = StudentClass::whereNull('deleted_at')->get();
            $data['exams']    = StudentExam::whereNull('deleted_at')->get();
            $data['examId']   = $examId;
            $data['sessions'] = StudentSession::whereNull('deleted_at')->get();
            $data['subjects'] = Subject::whereNull('deleted_at')->get();

            // return view('dashboard.settings.examwise_grade_group', $data);
            return view('dashboard.settings.subject_wise_grade', $data);
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function getSubjectsByClass($class_id)
    {
        $subjects = DB::table('subject_assigns')
            ->join('subjects', 'subject_assigns.subject_id', '=', 'subjects.id')
            ->where('subject_assigns.class_id', $class_id)
            ->whereNull('subject_assigns.deleted_at') // ✅ correct syntax
            ->select('subjects.id', 'subjects.name')
            ->distinct()
            ->get();

        return response()->json($subjects);
    }

    public function SubjectWiseGradeStore(Request $request)
    {

        if ($request->ajax()) {
            $data = Validator::make($request->all(), [
                'class_id'   => 'required',
                'subject_id' => 'required',
                'start_mark' => 'required',
                'end_mark'   => 'required',
                'exam_mark'  => 'required',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }

            $start_marks = [];
            $end_marks   = [];
            $grades      = [];
            $gpas        = [];
            foreach ($request->start_mark as $key => $mark) {
                $start_marks[] = $mark;
                $end_marks[]   = $request->end_mark[$key];
                $grades[]      = $request->grade[$key];
                $gpas[]        = $request->gpa[$key];
            }

            // dd($request->all(), $start_marks, $end_marks, $grades, $gpa);

            $existing = SubjectWiseGrades::where('class_id', $request->class_id)
                ->where('subject_id', $request->subject_id)
                ->where('exam_id', $request->exam_id)
                ->where('session_id', $request->session_id)
                ->whereNull('deleted_at')
                ->first();

            if ($existing) {
                return response()->json([
                    'success' => false,
                    'message' => 'This subject wise grade already exists for this class, session, and exam.',
                ]);
            }

            try {
                $data             = new SubjectWiseGrades();
                $data->gpa        = json_encode($gpas);
                $data->class_id   = $request->class_id;
                $data->subject_id = $request->subject_id;
                $data->exam_id    = $request->exam_id;
                $data->session_id = $request->session_id;
                $data->exam_mark  = $request->exam_mark;

                $data->start_mark = json_encode($start_marks);
                $data->end_mark   = json_encode($end_marks);
                $data->created_by = Auth::user()->id;
                $data->grade      = json_encode($grades);

                $data->save();

                return response()->json([
                    'success' => true,
                    'message' => 'Subject Wise Grade Created successfully',
                ]);
            } catch (\Exception $exception) {
                return response()->json([
                    'success' => false,
                    'message' => $exception->getMessage(),
                ]);
            }
        }
    }

    public function ExamWiseGrade(Request $request)
    {
        try {
            if ($request->ajax()) {
                $data = DB::table('exam_wise_grades')
                    ->whereNull('deleted_at')
                    ->orderBy('id', 'desc')
                    ->groupBy('exam_id')
                    ->get();
                // dd($data);

                return Datatables::of($data)

                    ->addColumn('exam', function ($data) {
                        $exam = StudentExam::find($data->exam_id);
                        return $exam->name ?? 'N/A';
                    })

                    ->addColumn('action', function ($data) {
                        return '<a href="' . route('exam.wise.grade.exam', $data->exam_id) . '" class="btn btn-sm btn-info view-exam" data-id="' . $data->exam_id . '">View</a>';
                    })
                    ->addIndexColumn()
                    ->rawColumns(['action'])
                    ->toJson();
            }

            $data['classes'] = StudentClass::whereNull('deleted_at')->get();
            $data['exams']   = StudentExam::whereNull('deleted_at')->get();

            $data['sessions'] = StudentSession::whereNull('deleted_at')->get();
            $data['subjects'] = Subject::whereNull('deleted_at')->get();
            return view('dashboard.settings.examwise_grade_group_for_exam', $data);
            // return view('dashboard.settings.subject_wise_grade', $data);
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function ExamWiseGradeStore(Request $request)
    {

        if ($request->ajax()) {
            $data = Validator::make($request->all(), [

                'start_mark' => 'required',
                'end_mark'   => 'required',
                'exam_mark'  => 'required',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }

            $existing = ExamWiseGrades::where('exam_id', $request->exam_id)
                ->where('session_id', $request->session_id)
                ->whereNull('deleted_at')
                ->first();

            if ($existing) {
                return response()->json([
                    'success' => false,
                    'message' => 'This exam wise grade already exists for this session and exam.',
                ]);
            }

            $start_marks = [];
            $end_marks   = [];
            $grades      = [];
            $gpas        = [];
            foreach ($request->start_mark as $key => $mark) {
                $start_marks[] = $mark;
                $end_marks[]   = $request->end_mark[$key];
                $grades[]      = $request->grade[$key];
                $gpas[]        = $request->gpa[$key];
            }

            // dd($request->all(), $start_marks, $end_marks, $grades, $gpa);

            try {
                $data      = new ExamWiseGrades();
                $data->gpa = json_encode($gpas);

                $data->exam_id    = $request->exam_id;
                $data->session_id = $request->session_id;
                $data->exam_mark  = $request->exam_mark;

                $data->start_mark = json_encode($start_marks);
                $data->end_mark   = json_encode($end_marks);
                $data->created_by = Auth::user()->id;
                $data->grade      = json_encode($grades);

                $data->save();

                return response()->json([
                    'success' => true,
                    'message' => 'Exam Wise Grade Created successfully',
                ]);
            } catch (\Exception $exception) {
                return response()->json([
                    'success' => false,
                    'message' => $exception->getMessage(),
                ]);
            }
        }
    }

    public function ExamWiseGradeEdit($id)
    {

        $data             = ExamWiseGrades::findOrFail($id);
        $data->start_mark = json_decode($data->start_mark);
        $data->end_mark   = json_decode($data->end_mark);
        $data->grade      = json_decode($data->grade);
        $data->gpa        = json_decode($data->gpa);
        return response()->json($data);
    }

    public function ExamWiseGradeUpdate(Request $request, $id)
    {
        if ($request->ajax()) {
            $validator = Validator::make($request->all(), [

                'exam_id'    => 'required',
                'session_id' => 'required',
                'exam_mark'  => 'required',
                'start_mark' => 'required|array',
                'end_mark'   => 'required|array',
                'grade'      => 'required|array',
                'gpa'        => 'required|array',
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->errors()->all(),
                ]);
            }

            try {
                $subject = ExamWiseGrades::findOrFail($id);

                $subject->exam_id    = $request->exam_id;
                $subject->session_id = $request->session_id;
                $subject->exam_mark  = $request->exam_mark;

                // Encode arrays as JSON
                $subject->start_mark = json_encode($request->start_mark);
                $subject->end_mark   = json_encode($request->end_mark);
                $subject->grade      = json_encode($request->grade);
                $subject->gpa        = json_encode($request->gpa);

                $subject->updated_by = Auth::user()->id;
                $subject->save();

                return response()->json([
                    'success' => true,
                    'message' => 'Exam Wise Grade updated successfully',
                ]);
            } catch (\Exception $exception) {
                return response()->json([
                    'success' => false,
                    'message' => $exception->getMessage(),
                ]);
            }
        }
    }

    public function ExamWiseGradeDestroy($id)
    {
        try {

            $data = ExamWiseGrades::findOrFail($id);

            $data->delete();
            return response()->json([
                'success' => true,
                'message' => 'Exam Wise deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Grade delete failed',
            ]);
        }
    }

    public function ExamWiseGradeByExam(Request $request, $examId)
    {
        try {
            if ($request->ajax()) {
                $data = DB::table('exam_wise_grades')
                    ->whereNull('deleted_at')
                    ->where('exam_id', $examId)
                    ->orderBy('id', 'desc')

                    ->get();
                // dd($data);

                return Datatables::of($data)

                    ->addColumn('exam', function ($data) {
                        $exam = StudentExam::find($data->exam_id);
                        return $exam->name ?? 'N/A';
                    })

                    ->addColumn('session', function ($data) {
                        $session = StudentSession::find($data->session_id);
                        return $session->name ?? 'N/A';
                    })
                    ->addColumn('exam_mark', function ($data) {
                        return $data->exam_mark ?? '';
                    })

                    ->addColumn('action', function ($data) {
                        $edit   = '<a id="edit" href="' . route('exam.wise.grade.edit', $data->id) . '" class="btn btn-sm btn-primary edit" title="Edit" data-toggle="modal" data-target="#editClass"><i class="fa fa-edit"></i></a>';
                        $delete = '<button  id="messageShow" class="btn btn-sm btn-danger btn-delete" data-remote="' . route('exam.wise.grade.destroy', $data->id) . '" title="Delete"><i class="fa fa-trash-alt"></i></button>';
                        return $edit . ' ' . $delete;
                    })
                    ->addIndexColumn()
                    ->rawColumns(['action'])
                    ->toJson();
            }

            $data['exams']    = StudentExam::whereNull('deleted_at')->get();
            $data['examId']   = $examId;
            $data['sessions'] = StudentSession::whereNull('deleted_at')->get();

            // return view('dashboard.settings.examwise_grade_group', $data);
            return view('dashboard.settings.exam_wise_grade', $data);
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    //grade mark update by ashiq end 21.05.25

    public function SubjectGradeStore(Request $request)
    {
        if ($request->ajax()) {
            $data = Validator::make($request->all(), [
                'name' => 'required|string|unique:subject_grades,name,NULL,id,deleted_at,NULL',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }

            try {
                $data             = new SubjectGrade();
                $data->gpa        = $request->gpa;
                $data->name       = $request->name;
                $data->mark       = $request->mark;
                $data->created_by = Auth::user()->id;
                $data->save();

                return response()->json([
                    'success' => true,
                    'message' => 'Grade created successfully',
                ]);
            } catch (\Exception $exception) {
                return response()->json([
                    'success' => false,
                    'message' => $exception->getMessage(),
                ]);
            }
        }
    }

    public function SubjectGradeEdit($id)
    {
        $data = SubjectGrade::findOrFail($id);
        return response()->json($data);
    }

    //grade mark update by ashiq 21.05.25
    public function SubjectWiseGradeEdit($id)
    {

        $data             = SubjectWiseGrades::findOrFail($id);
        $data->start_mark = json_decode($data->start_mark);
        $data->end_mark   = json_decode($data->end_mark);
        $data->grade      = json_decode($data->grade);
        $data->gpa        = json_decode($data->gpa);
        return response()->json($data);
    }
    //grade mark update by ashiq end 21.05.25
    public function SubjectGradeUpdate(Request $request, $id)
    {
        $data = Validator::make($request->all(), [
            'name' => 'required|string|unique:subject_grades,name,' . $id . ',id,deleted_at,NULL',
        ]);

        if ($data->fails()) {
            return response()->json([
                'success' => false,
                'message' => $data->errors()->all(),
            ]);
        }

        try {
            $subject             = SubjectGrade::findOrFail($id);
            $subject->name       = $request->name;
            $subject->mark       = $request->mark;
            $subject->gpa        = $request->gpa;
            $subject->updated_by = Auth::user()->id;
            $subject->save();

            return response()->json([
                'success' => true,
                'message' => 'Grade updated successfully',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => $exception->getMessage(),
            ]);
        }
    }
    //grade mark update by ashiq 21.05.25
    public function SubjectWiseGradeUpdate(Request $request, $id)
    {
        if ($request->ajax()) {
            $validator = Validator::make($request->all(), [
                'class_id'   => 'required',
                'subject_id' => 'required',
                'exam_id'    => 'required',
                'session_id' => 'required',
                'exam_mark'  => 'required',
                'start_mark' => 'required|array',
                'end_mark'   => 'required|array',
                'grade'      => 'required|array',
                'gpa'        => 'required|array',
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->errors()->all(),
                ]);
            }

            try {
                $subject = SubjectWiseGrades::findOrFail($id);

                $subject->class_id   = $request->class_id;
                $subject->subject_id = $request->subject_id;
                $subject->exam_id    = $request->exam_id;
                $subject->session_id = $request->session_id;
                $subject->exam_mark  = $request->exam_mark;

                // Encode arrays as JSON
                $subject->start_mark = json_encode($request->start_mark);
                $subject->end_mark   = json_encode($request->end_mark);
                $subject->grade      = json_encode($request->grade);
                $subject->gpa        = json_encode($request->gpa);

                $subject->updated_by = Auth::user()->id;
                $subject->save();

                return response()->json([
                    'success' => true,
                    'message' => 'Subject Wise Grade updated successfully',
                ]);
            } catch (\Exception $exception) {
                return response()->json([
                    'success' => false,
                    'message' => $exception->getMessage(),
                ]);
            }
        }
    }

    //grade mark update by ashiq end 21.05.25

    public function SubjectGradeDestroy($id)
    {
        try {

            $data = SubjectGrade::findOrFail($id);

            $data->delete();
            return response()->json([
                'success' => true,
                'message' => 'Grade deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Grade delete failed',
            ]);
        }
    }
    //grade mark update by ashiq 21.05.25
    public function SubjectWiseGradeDestroy($id)
    {
        try {

            $data = SubjectWiseGrades::findOrFail($id);

            $data->delete();
            return response()->json([
                'success' => true,
                'message' => 'Grade Wise deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Grade delete failed',
            ]);
        }
    }
    //grade mark update by ashiq end 21.05.25
    public function SubjectAssign(Request $request)
    {
        try {
            if ($request->ajax()) {

                $data = SubjectAssign::with('subjects', 'stuclass')->groupBy('class_id')->get();
                // dd($data);
                return Datatables::of($data)

                    ->addColumn('class', function ($data) {
                        return $data->stuclass->name ?? '';
                    })

                    ->addColumn('subject', function ($data) {
                        $subjects = SubjectAssign::where('class_id', $data->class_id)->get();
                        $result   = '';
                        foreach ($subjects as $subject) {
                            $name = $subject->subjects->name ?? '';
                            $code = $subject->subjects->code ?? '';
                            $result .= $name . '-' . $code . ', ';
                        }
                        return rtrim($result, ', ');
                    })

                    ->addColumn('action', function ($data) {

                        $edit = '<a id="edit" href="' . route('subject.assign.edit', $data->id) . ' " class="btn btn-sm btn-primary edit" title="Edit" data-toggle="modal" data-target="#editClass"><i class="fa fa-edit"></i></a> ';

                        $view = '<a type="button" id="print" class="btn btn-sm btn-info print mr-1" href="' . route('subject.assign.show', $data->id) . ' " title="Print"><i class="fa fa-eye"></i></a>';

                        $delete = '<button id="messageShow" class="btn btn-sm btn-danger btn-delete" data-remote=" ' . route('subject.assign.destroy', $data->class_id) . ' " title="Delete"><i class="fa fa-trash-alt"></i></button>';

                        return $edit . $view . $delete;
                    })

                    ->addIndexColumn()
                    ->rawColumns(['class', 'action', 'subject'])
                    ->toJson();
            }
            $class    = StudentClass::all();
            $subjects = Subject::all();
            return view('dashboard.settings.subject_assign', compact('class', 'subjects'));
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function SubjectAssignView($id)
    {
        $design   = InvoiceDesign::first();
        $data     = SubjectAssign::with('subjects', 'stuclass')->findOrFail($id);
        $subjects = SubjectAssign::with('subjects')->where('class_id', $data->class_id)->get();
        return view('dashboard.settings.subject_assign_print', compact('data', 'design', 'subjects'));
    }

    public function SubjectAssignStore(Request $request)
    {
        if ($request->ajax()) {
            $data = Validator::make($request->all(), [
                'class_id'   => 'required',
                'subject_id' => 'required|array',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }

            try {
                $alreadyAssignedSubjects = [];
                $class_id                = $request->class_id;

                foreach ($request->subject_id as $subject) {
                    $exists = SubjectAssign::where('class_id', $class_id)
                        ->where('subject_id', $subject)
                        ->exists();

                    if ($exists) {
                        $subjectName               = Subject::find($subject)->name;
                        $alreadyAssignedSubjects[] = $subjectName;
                    } else {
                        $subjectAssign             = new SubjectAssign();
                        $subjectAssign->class_id   = $class_id;
                        $subjectAssign->subject_id = $subject;
                        $subjectAssign->created_by = Auth::user()->id;
                        $subjectAssign->save();
                    }
                }

                if (count($alreadyAssignedSubjects) > 0) {
                    return response()->json([
                        'success'                   => false,
                        'already_assigned_subjects' => $alreadyAssignedSubjects,
                        'message'                   => implode(', ', $alreadyAssignedSubjects) . ' subjects were already assigned to the class.',
                    ]);
                }

                return response()->json([
                    'success' => true,
                    'message' => 'Subjects assigned successfully.',
                ]);
            } catch (\Exception $exception) {
                return response()->json([
                    'success' => false,
                    'message' => $exception->getMessage(),
                ]);
            }
        }
    }

    public function SubjectAssignEdit($id)
    {
        $data       = SubjectAssign::findOrFail($id);
        $subjectIds = SubjectAssign::where('class_id', $data->class_id)->pluck('subject_id')->toArray();

        return response()->json([
            'id'         => $data->id,
            'class_id'   => $data->class_id,
            'subject_id' => $subjectIds,
        ]);
    }

    public function SubjectAssignUpdate(Request $request, $id)
    {
        $data = Validator::make($request->all(), [
            'class_id' => 'required',
        ]);

        if ($data->fails()) {
            return response()->json([
                'success' => false,
                'message' => $data->errors()->all(),
            ]);
        }

        try {

            $sub = SubjectAssign::findOrFail($id);
            SubjectAssign::where('class_id', $sub->class_id)->delete();

            $exam_routing = ExamRouting::where('class_id', $request->class_id)->first();

            if ($exam_routing) {
                $exam_routing_details = ExamRoutingDetails::where('exam_routing_id', $exam_routing->id)->get();

                // Step 2: Check if subject in routing but not in request, then delete
                foreach ($exam_routing_details as $detail) {
                    if (! in_array($detail->subject_id, $request->subject_id)) {
                        $detail->delete();
                    }
                }
            }

            foreach ($request->subject_id as $key => $subject) {
                $subjectAssign             = new SubjectAssign();
                $subjectAssign->class_id   = $request->class_id;
                $subjectAssign->subject_id = $subject;
                $subjectAssign->created_by = Auth::user()->id;
                $subjectAssign->updated_by = Auth::user()->id;
                $subjectAssign->save();
            }

            return response()->json([
                'success' => true,
                'message' => 'Subject assigned updated successfully',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => $exception->getMessage(),
            ]);
        }
    }

    public function SubjectAssignDestroy($id)
    {
        try {
            SubjectAssign::where('class_id', $id)->delete();

            return response()->json([
                'success' => true,
                'message' => 'Data deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Data delete failed',
            ]);
        }
    }

    public function responsibilities(Request $request)
    {
        try {
            if ($request->ajax()) {
                $data = TeacherResponsibility::select('id', 'name')->get();

                return Datatables::of($data)

                    ->addColumn('action', function ($data) {

                        $edit = '<a id="edit" href="' . route('responsibilities.edit', $data->id) . ' " class="btn btn-sm btn-primary edit" title="Edit" data-toggle="modal" data-target="#editClass"><i class="fa fa-edit"></i></a> ';

                        $delete = '';
                        if ($this->DeleteData()) {
                            $delete = '<button id="messageShow" class="btn btn-sm btn-danger btn-delete" data-remote=" ' . route('responsibilities.destroy', $data->id) . ' " title="Delete"><i class="fa fa-trash-alt"></i></button>';
                        }

                        return $edit . $delete;
                    })

                    ->addIndexColumn()
                    ->rawColumns(['action'])
                    ->toJson();
            }
            return view('dashboard.settings.responsibilities');
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function ResponsibilitiesStore(Request $request)
    {
        if ($request->ajax()) {

            $data = Validator::make($request->all(), [
                'name' => 'required|string|unique:teacher_responsibilities,name,NULL,id,deleted_at,NULL',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }

            try {
                $data       = new TeacherResponsibility();
                $data->name = $request->name;
                $data->save();

                return response()->json([
                    'success' => true,
                    'message' => 'Data created successfully',
                ]);
            } catch (\Exception $exception) {
                return response()->json([
                    'success' => false,
                    'message' => $exception->getMessage(),
                ]);
            }
        }
    }

    public function ResponsibilitiesEdit($id)
    {
        $data = TeacherResponsibility::findOrFail($id);
        return response()->json($data);
    }

    public function ResponsibilitiesUpdate(Request $request, $id)
    {
        $data = Validator::make($request->all(), [
            'name' => 'required|string|unique:teacher_responsibilities,name,' . $id . ',id,deleted_at,NULL',
        ]);

        if ($data->fails()) {
            return response()->json([
                'success' => false,
                'message' => $data->errors()->all(),
            ]);
        }

        try {
            $data       = TeacherResponsibility::findOrFail($id);
            $data->name = $request->name;
            $data->update();

            return response()->json([
                'success' => true,
                'message' => 'Data updated successfully',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => $exception->getMessage(),
            ]);
        }
    }
    public function ResponsibilitiesDestroy($id)
    {
        try {
            $data = TeacherResponsibility::findOrFail($id);

            $tables = DB::select("
            SELECT TABLE_NAME
            FROM INFORMATION_SCHEMA.COLUMNS
            WHERE COLUMN_NAME = 'responsibility_id'
            AND TABLE_SCHEMA = DATABASE()
            ");

            foreach ($tables as $table) {
                if ($table->TABLE_NAME !== 'teacher_responsibilities') {
                    DB::table($table->TABLE_NAME)->where('responsibility_id', $data->id)->delete();
                }
            }

            $data->delete();
            return response()->json([
                'success' => true,
                'message' => 'Data deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Data delete failed',
            ]);
        }
    }

    public function Shop(Request $request)
    {
        try {
            if ($request->ajax()) {
                $data = Shop::all();

                return Datatables::of($data)

                    ->addColumn('name', function ($data) {
                        $name = $data->name ?? '';
                        return $name;
                    })

                    ->addColumn('action', function ($data) {

                        $edit = '<a id="edit" href="' . route('shop.edit', $data->id) . ' " class="btn btn-sm btn-primary edit" title="Edit" data-toggle="modal" data-target="#editClass"><i class="fa fa-edit"></i></a> ';

                        $delete = '';
                        if ($this->DeleteData()) {
                            $delete = '<button id="messageShow" class="btn btn-sm btn-danger btn-delete" data-remote=" ' . route('shop.destroy', $data->id) . ' " title="Delete"><i class="fa fa-trash-alt"></i></button>';
                        }
                        return $edit . $delete;
                    })

                    ->addIndexColumn()
                    ->rawColumns(['name', 'action'])
                    ->toJson();
            }
            return view('dashboard.settings.shop');
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function ShopStore(Request $request)
    {
        if ($request->ajax()) {
            $data = Validator::make($request->all(), [
                'name' => 'required|string|unique:shops,name,NULL,id,deleted_at,NULL',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }

            try {
                $data             = new Shop();
                $data->name       = $request->name;
                $data->created_by = Auth::user()->id;
                $data->save();

                return response()->json([
                    'success' => true,
                    'message' => 'Data created successfully',
                ]);
            } catch (\Exception $exception) {
                return response()->json([
                    'success' => false,
                    'message' => $exception->getMessage(),
                ]);
            }
        }
    }

    public function ShopEdit($id)
    {
        $data = Shop::findOrFail($id);
        return response()->json($data);
    }

    public function ShopUpdate(Request $request, $id)
    {
        $data = Validator::make($request->all(), [
            'name' => 'required|string|unique:shops,name,' . $id . ',id,deleted_at,NULL',
        ]);

        if ($data->fails()) {
            return response()->json([
                'success' => false,
                'message' => $data->errors()->all(),
            ]);
        }

        try {
            $subject             = Shop::findOrFail($id);
            $subject->name       = $request->name;
            $subject->updated_by = Auth::user()->id;
            $subject->save();

            return response()->json([
                'success' => true,
                'message' => 'Shop updated successfully',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => $exception->getMessage(),
            ]);
        }
    }

    public function ShopDestroy($id)
    {
        try {
            $data   = Shop::findOrFail($id);
            $tables = DB::select("
            SELECT TABLE_NAME
            FROM INFORMATION_SCHEMA.COLUMNS
            WHERE COLUMN_NAME = 'shop_id'
            AND TABLE_SCHEMA = DATABASE()
            ");

            foreach ($tables as $table) {
                if ($table->TABLE_NAME !== 'shops') {
                    DB::table($table->TABLE_NAME)->where('shop_id', $data->id)->delete();
                }
            }

            $data->delete();
            return response()->json([
                'success' => true,
                'message' => 'Shop deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Shop delete failed',
            ]);
        }
    }

    public function HelpLine()
    {
        try {
            $data = HelpLine::first();
            return view('dashboard.settings.help_line', compact('data'));
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function HelpLineStore(Request $request)
    {
        try {
            if (! $request->id) {
                $request->validate([
                    'facebook' => 'required',
                    'whatsapp' => 'required',
                    'email'    => 'required',
                    'phone'    => 'required',
                    'address'  => 'required',
                ]);

                $data = new HelpLine();
            } else {
                $data = HelpLine::findOrFail($request->id);
            }

            $data->facebook = $request->facebook;
            $data->whatsapp = $request->whatsapp;
            $data->email    = $request->email;
            $data->phone    = $request->phone;
            $data->address  = $request->address;

            if (! $request->id) {
                $data->save();
                return redirect()->back()->with('success', ' Help line created successfull');
            } else {
                $data->update();
                return redirect()->back()->with('success', 'Help line updated successfull');
            }
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function SmsSetting()
    {
        try {
            $data = SmsSetting::first();
            return view('dashboard.settings.sms_setting', compact('data'));
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function SmsStore(Request $request)
    {

        try {
            if (! $request->id) {
                $request->validate([
                    'api_key'   => 'required',
                    'sender_id' => 'required',
                    'api_url'   => 'required',
                    'status'    => 'required',
                ]);

                $data = new SmsSetting();
            } else {
                $data = SmsSetting::findOrFail($request->id);
            }

            $data->sender_id = $request->sender_id;
            $data->api_url   = $request->api_url;
            $data->api_key   = $request->api_key;
            $data->status    = $request->status;

            if (! $request->id) {
                $data->save();
                return redirect()->back()->with('success', ' Sms setting created successfull');
            } else {
                $data->update();
                return redirect()->back()->with('success', 'Sms setting updated successfull');
            }
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function AttendanceSetting(Request $request)
    {
        try {
            if ($request->ajax()) {
                $data = AttendanceSetting::all();

                return Datatables::of($data)

                    ->addColumn('name', function ($data) {
                        $name = $data->shift_name ?? '';
                        return $name;
                    })

                    ->addColumn('entry_start', function ($data) {
                        $record = Carbon::parse($data->entry_start_time)->format('h:i A') ?? '';
                        return $record;
                    })
                    ->addColumn('entry_end', function ($data) {
                        $record = Carbon::parse($data->entry_end_time)->format('h:i A') ?? '';
                        return $record;
                    })
                    ->addColumn('exit_start', function ($data) {
                        $record = Carbon::parse($data->exit_start_time)->format('h:i A') ?? '';
                        return $record;
                    })
                    ->addColumn('exit_end', function ($data) {
                        $record = Carbon::parse($data->exit_end_time)->format('h:i A') ?? '';
                        return $record;
                    })

                    ->addColumn('action', function ($data) {

                        $edit = '<a id="edit" href="' . route('attendance.setting.edit', $data->id) . ' " class="btn btn-sm btn-primary edit" title="Edit" data-toggle="modal" data-target="#editClass"><i class="fa fa-edit"></i></a> ';

                        $delete = '';
                        if ($this->DeleteData()) {
                            $delete = '<button id="messageShow" class="btn btn-sm btn-danger btn-delete" data-remote=" ' . route('attendance.setting.destroy', $data->id) . ' " title="Delete"><i class="fa fa-trash-alt"></i></button>';
                        }

                        return $edit . $delete;
                    })

                    ->addIndexColumn()
                    ->rawColumns(['name', 'action', 'entry_start', 'entry_end', 'exit_start', 'exit_end'])
                    ->toJson();
            }
            return view('dashboard.settings.attendance_setting');
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function AttendanceSettingStore(Request $request)
    {
        if ($request->ajax()) {
            $data = Validator::make($request->all(), [
                'entry_start_time' => 'required',
                'entry_end_time'   => 'required',
                'exit_end_time'    => 'required',
                'exit_start_time'  => 'required',
                'shift_name'       => 'required|string|unique:attendance_settings,shift_name,NULL,id,deleted_at,NULL',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }

            $existingShift = AttendanceSetting::where(function ($query) use ($request) {
                $query->where('entry_start_time', '<=', $request->entry_end_time)
                    ->where('entry_end_time', '>=', $request->entry_start_time)
                    ->where('exit_start_time', '<=', $request->exit_end_time)
                    ->where('exit_end_time', '>=', $request->exit_start_time);
            })->exists();

            if ($existingShift) {
                return response()->json([
                    'success' => false,
                    'message' => 'Time range overlaps with an existing shift',
                ]);
            }

            try {
                $data                   = new AttendanceSetting();
                $data->shift_name       = $request->shift_name;
                $data->entry_start_time = Carbon::parse($request->entry_start_time)->format('H:i:s');
                $data->entry_end_time   = Carbon::parse($request->entry_end_time)->format('H:i:s');
                $data->exit_start_time  = Carbon::parse($request->exit_start_time)->format('H:i:s');
                $data->exit_end_time    = Carbon::parse($request->exit_end_time)->format('H:i:s');
                $data->save();

                return response()->json([
                    'success' => true,
                    'message' => 'Setting created successfully',
                ]);
            } catch (\Exception $exception) {
                return response()->json([
                    'success' => false,
                    'message' => $exception->getMessage(),
                ]);
            }
        }
    }

    public function AttendanceSettingEdit($id)
    {
        $data = AttendanceSetting::findOrFail($id);
        return response()->json($data);
    }

    public function AttendanceSettingUpdate(Request $request, $id)
    {
        if ($request->ajax()) {
            $data = Validator::make($request->all(), [
                'entry_start_time' => 'required',
                'entry_end_time'   => 'required',
                'exit_end_time'    => 'required',
                'exit_start_time'  => 'required',
                'shift_name'       => 'required|string|unique:attendance_settings,shift_name,' . $id . ',id,deleted_at,NULL',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }

            $existingShift = AttendanceSetting::where(function ($query) use ($request, $id) {
                $query->where('id', '!=', $id)
                    ->where('entry_start_time', '<=', $request->entry_end_time)
                    ->where('entry_end_time', '>=', $request->entry_start_time)
                    ->where('exit_start_time', '<=', $request->exit_end_time)
                    ->where('exit_end_time', '>=', $request->exit_start_time);
            })->exists();

            if ($existingShift) {
                return response()->json([
                    'success' => false,
                    'message' => 'Time range overlaps with an existing shift',
                ]);
            }

            try {
                $data                   = AttendanceSetting::findOrFail($id);
                $data->shift_name       = $request->shift_name;
                $data->entry_start_time = Carbon::parse($request->entry_start_time)->format('H:i:s');
                $data->entry_end_time   = Carbon::parse($request->entry_end_time)->format('H:i:s');
                $data->exit_start_time  = Carbon::parse($request->exit_start_time)->format('H:i:s');
                $data->exit_end_time    = Carbon::parse($request->exit_end_time)->format('H:i:s');
                $data->save();

                return response()->json([
                    'success' => true,
                    'message' => 'Setting updated successfully',
                ]);
            } catch (\Exception $exception) {
                return response()->json([
                    'success' => false,
                    'message' => $exception->getMessage(),
                ]);
            }
        }
    }

    public function AttendanceSettingDestroy($id)
    {
        try {
            $data = AttendanceSetting::findOrFail($id);

            $tables = DB::select("
            SELECT TABLE_NAME
            FROM INFORMATION_SCHEMA.COLUMNS
            WHERE COLUMN_NAME = 'shift_id'
            AND TABLE_SCHEMA = DATABASE()
            ");

            foreach ($tables as $table) {
                if ($table->TABLE_NAME !== 'attendance_settings') {
                    DB::table($table->TABLE_NAME)->where('shift_id', $data->id)->delete();
                }
            }

            $data->delete();
            return response()->json([
                'success' => true,
                'message' => 'Data deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Data delete failed',
            ]);
        }
    }
    public function Licence()
    {
        try {
            $data = Licence::first();
            return view('dashboard.settings.licence', compact('data'));
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function LicenceStore(Request $request)
    {
        try {
            if (! $request->id) {
                $request->validate([
                    'username'    => 'required',
                    'licence_key' => 'required',
                ]);

                $data = new Licence();
            } else {
                $data = Licence::findOrFail($request->id);
            }

            $data->username    = $request->username;
            $data->licence_key = $request->licence_key;

            if (! $request->id) {
                $data->save();
                return redirect()->back()->with('success', 'Licence saved successfull');
            } else {
                $data->update();
                return redirect()->back()->with('success', 'Licence updated successfull');
            }
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }
    public function SmsStatus()
    {
        try {
            $data = optional(SmsStatus::first());
            return view('dashboard.settings.sms_status', compact('data'));
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function SmsStatusStore(Request $request)
    {
        try {
            if (! $request->id) {
                $data = new SmsStatus();
            } else {
                $data = SmsStatus::findOrFail($request->id);
            }

            $data->student_admission  = $request->has('student_admission') ? $request->student_admission : 0;
            $data->student_payment    = $request->has('student_payment') ? $request->student_payment : 0;
            $data->student_attendance = $request->has('student_attendance') ? $request->student_attendance : 0;
            $data->student_leave      = $request->has('student_leave') ? $request->student_leave : 0;
            $data->student_deactivate = $request->has('student_deactivate') ? $request->student_deactivate : 0;
            $data->student_comment    = $request->has('student_comment') ? $request->student_comment : 0;
            $data->student_sonad      = $request->has('student_sonad') ? $request->student_sonad : 0;
            $data->student_admitcard  = $request->has('student_admitcard') ? $request->student_admitcard : 0;
            $data->student_result     = $request->has('student_result') ? $request->student_result : 0;
            $data->student_sponsor    = $request->has('student_sponsor') ? $request->student_sponsor : 0;
            $data->teacher_admission  = $request->has('teacher_admission') ? $request->teacher_admission : 0;
            $data->teacher_attendance = $request->has('teacher_attendance') ? $request->teacher_attendance : 0;
            $data->teacher_leave      = $request->has('teacher_leave') ? $request->teacher_leave : 0;
            $data->teacher_salary     = $request->has('teacher_salary') ? $request->teacher_salary : 0;
            $data->donar_admission    = $request->has('donar_admission') ? $request->donar_admission : 0;
            $data->donation           = $request->has('donation') ? $request->donation : 0;
            $data->donar_payment      = $request->has('donar_payment') ? $request->donar_payment : 0;
            $data->save();

            return redirect()->back()->with('success', 'Status saved successfully');
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function DeviceSetting(Request $request)
    {
        try {
            if ($request->ajax()) {
                $data = DeviceSetting::all();

                return Datatables::of($data)

                    ->addColumn('name', function ($data) {
                        $name = $data->name ?? '';
                        return $name;
                    })

                    ->addColumn('device_ip', function ($data) {
                        return $data->device_ip;
                    })

                    ->addColumn('device_port', function ($data) {
                        return $data->device_port;
                    })

                    ->addColumn('action', function ($data) {
                        $user    = auth()->user();
                        $actions = '';

                        if ($user && ($user->role_id == 1 || $user->type == 1 || $user->canPerm('device_settings.update.update'))) {
                            $actions .= '<a id="edit" href="' . route('device.setting.edit', $data->id) . '"
            class="btn btn-sm btn-primary edit" title="Edit" data-toggle="modal" data-target="#editClass">
            <i class="fa fa-edit"></i></a> ';
                        }

                        if ($user && ($user->role_id == 1 || $user->type == 1 || $user->canPerm('device_settings.delete'))) {
                            $actions .= '<button id="messageShow" class="btn btn-sm btn-danger btn-delete"
            data-remote="' . route('device.setting.destroy', $data->id) . '" title="Delete">
            <i class="fa fa-trash-alt"></i></button>';
                        }

                        return $actions ?: '<span class="text-muted">No action</span>';
                    })
                    ->rawColumns(['action'])

                    ->addIndexColumn()
                    ->rawColumns(['name', 'action', 'device_ip', 'device_port'])
                    ->toJson();
            }
            return view('dashboard.settings.device_setting');
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function DeviceSettingStore(Request $request)
    {
        if ($request->ajax()) {
            $data = Validator::make($request->all(), [
                'name'        => 'required',
                'device_port' => 'required',
                'device_ip'   => 'required|string|unique:device_settings,device_ip,NULL,id,deleted_at,NULL',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }

            $existing = DeviceSetting::where('device_ip', $request->device_ip)->exists();
            if ($existing) {
                return response()->json([
                    'success' => false,
                    'message' => 'Device ip already exists',
                ]);
            }

            try {
                $data              = new DeviceSetting();
                $data->name        = $request->name;
                $data->device_ip   = $request->device_ip;
                $data->device_port = $request->device_port;
                $data->save();

                return response()->json([
                    'success' => true,
                    'message' => 'Setting created successfully',
                ]);
            } catch (\Exception $exception) {
                return response()->json([
                    'success' => false,
                    'message' => $exception->getMessage(),
                ]);
            }
        }
    }

    public function DeviceSettingEdit($id)
    {
        $data = DeviceSetting::findOrFail($id);
        return response()->json($data);
    }

    public function DeviceSettingUpdate(Request $request, $id)
    {
        if ($request->ajax()) {
            $data = Validator::make($request->all(), [
                'name'        => 'required',
                'device_port' => 'required',
                'device_ip'   => 'required|string|unique:device_settings,device_ip,' . $id . ',id,deleted_at,NULL',
            ]);

            if ($data->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $data->errors()->all(),
                ]);
            }

            $existing = DeviceSetting::where('device_ip', $request->device_ip)
                ->where('id', '!=', $id)
                ->exists();

            if ($existing) {
                return response()->json([
                    'success' => false,
                    'message' => 'The device ip already exists',
                ]);
            }

            try {
                $data              = DeviceSetting::findOrFail($id);
                $data->name        = $request->name;
                $data->device_ip   = $request->device_ip;
                $data->device_port = $request->device_port;
                $data->save();

                return response()->json([
                    'success' => true,
                    'message' => 'Setting updated successfully',
                ]);
            } catch (\Exception $exception) {
                return response()->json([
                    'success' => false,
                    'message' => $exception->getMessage(),
                ]);
            }
        }
    }

    public function DeviceSettingDestroy($id)
    {
        try {
            $data = DeviceSetting::findOrFail($id);
            $data->delete();
            return response()->json([
                'success' => true,
                'message' => 'Data deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Data delete failed',
            ]);
        }
    }
    public function Notices(Request $request)
    {
        try {
            if ($request->ajax()) {
                $data = Notice::all();

                return Datatables::of($data)

                    ->addColumn('title', function ($data) {
                        $name = $data->title ?? '';
                        return $name;
                    })

                    ->addColumn('notice', function ($data) {
                        return Str::limit($data->notice, 100);
                    })

                    ->addColumn('action', function ($data) {

                        $view = '<a href="' . route('notice.show', $data->id) . ' " class="btn btn-sm btn-info" title="show"><i class="fa fa-eye"></i></a> ';

                        $edit = '<a id="edit" href="' . route('notice.edit', $data->id) . ' " class="btn btn-sm btn-primary edit" title="Edit"><i class="fa fa-edit"></i></a> ';

                        $delete = '<button id="messageShow" class="btn btn-sm btn-danger btn-delete" data-remote=" ' . route('notice.destroy', $data->id) . ' " title="Delete"><i class="fa fa-trash-alt"></i></button>';

                        return $view . $edit . $delete;
                    })

                    ->addIndexColumn()
                    ->rawColumns(['notice', 'action', 'title'])
                    ->toJson();
            }
            return view('dashboard.settings.notice_list');
        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function NoticeCreate()
    {
        return view('dashboard.settings.notice_create');
    }

    public function NoticeStore(Request $request)
    {
        $data = Validator::make($request->all(), [
            'title'  => 'required',
            'notice' => 'required',
        ]);

        if ($data->fails()) {
            return redirect()->back()
                ->withErrors($data)
                ->withInput();
        }

        try {
            $data         = new Notice();
            $data->title  = $request->title;
            $data->notice = $request->notice;
            $data->save();

            return redirect()->route('notices')->with('success', 'Notice saved successfully');
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => $exception->getMessage(),
            ]);
        }
    }

    public function NoticeShow($id)
    {
        $data    = Notice::findOrFail($id);
        $invoice = InvoiceDesign::first();
        return view('dashboard.settings.notice_show', compact('data', 'invoice'));
    }

    public function NoticeEdit($id)
    {
        $data = Notice::findOrFail($id);
        return view('dashboard.settings.notice_edit', compact('data'));
    }

    public function NoticeUpdate(Request $request, $id)
    {
        $data = Validator::make($request->all(), [
            'title'  => 'required',
            'notice' => 'required',
        ]);

        if ($data->fails()) {
            return redirect()->back()
                ->withErrors($data)
                ->withInput();
        }

        try {
            $data         = Notice::findOrFail($id);
            $data->title  = $request->title;
            $data->notice = $request->notice;
            $data->save();

            return redirect()->route('notices')->with('success', 'Notice updated successfully');
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => $exception->getMessage(),
            ]);
        }
    }

    public function NoticeDestroy($id)
    {
        try {
            $data = Notice::findOrFail($id);
            $data->delete();
            return response()->json([
                'success' => true,
                'message' => 'Notice deleted successfully.',
            ]);
        } catch (\Exception $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Notice delete failed',
            ]);
        }
    }

    public function examRouting(Request $request)
    {
        try {
            if ($request->ajax()) {

                $data = ExamRouting::select('session_id', 'exam_id', \DB::raw('MAX(id) as id'))
                    ->groupBy('session_id', 'exam_id')
                    ->orderByDesc('id')
                    ->with(['session', 'exam']);

                return datatables()->of($data)
                    ->addIndexColumn()

                    ->addColumn('session', function ($row) {
                        return $row->session->name ?? '';
                    })
                    ->addColumn('exam', function ($row) {
                        return $row->exam->name ?? '';
                    })
                    ->addColumn('action', function ($row) {
                        $show  = '<a href="' . route('exam.routing.showBySession', ['exam_id' => $row->exam_id, 'session_id' => $row->session_id]) . '" class="btn btn-sm btn-info" title="Show"><i class="fa fa-eye"></i> View</a> ';
                        $print = '<a target="_blank" href="' . route('exam.routing.printBySession', ['exam_id' => $row->exam_id, 'session_id' => $row->session_id]) . '" class="btn btn-sm btn-success" title="Print"><i class="fa fa-print"></i> Print</a>';

                        return $show . $print;
                    })
                    ->rawColumns(['action'])
                    ->make(true);
            }

            $classes  = StudentClass::all();
            $sessions = StudentSession::all();
            $exams    = StudentExam::all();
            return view('dashboard.settings.exam_routing', compact('classes', 'sessions', 'exams'));

        } catch (\Exception $exception) {
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function showExamRoutingBySession(Request $request, $exam_id = null, $session_id = null)
    {
        if ($request->ajax()) {
            // dd($exam_id, $session_id);
            $examRoutings = ExamRouting::with(['class', 'session', 'exam', 'details.subject'])
                ->where('exam_id', $exam_id)
                ->where('session_id', $session_id)
                ->orderByDesc('id');

            return datatables()->of($examRoutings)
                ->addIndexColumn()
                ->addColumn('class', function ($row) {
                    return $row->class->name ?? '';
                })
                ->addColumn('session', function ($row) {
                    return $row->session->name ?? '';
                })
                ->addColumn('exam', function ($row) {
                    return $row->exam->name ?? '';
                })
                ->addColumn('action', function ($row) {
                    $show   = '<a href="' . route('exam.routing.show', $row->id) . '" class="btn btn-sm btn-info" title="Show"><i class="fa fa-eye"></i></a> ';
                    $edit   = '<a href="' . route('exam.routing.edit', $row->id) . '" class="btn btn-sm btn-primary" title="Edit"><i class="fa fa-edit"></i></a> ';
                    $delete = '<button class="btn btn-sm btn-danger btn-delete" data-remote="' . route('exam.routing.destroy', $row->id) . '" title="Delete"><i class="fa fa-trash-alt"></i></button>';
                    return $show . $edit . $delete;
                })
                ->rawColumns(['action'])
                ->make(true);
        }

        // dd($exam_id, $session_id);

        return view('dashboard.settings.exam_routing_show_by_session', [
            'exam_id'    => $exam_id,
            'session_id' => $session_id,
        ]);
    }

    public function examRoutingCreate()
    {
        $classes  = StudentClass::all();
        $sessions = StudentSession::all();
        $exams    = StudentExam::all();
        return view('dashboard.settings.exam_routing_create', compact('classes', 'sessions', 'exams'));
    }

    public function examRoutingStore(Request $request)
    {
        DB::beginTransaction();

        try {
            // Validation
            $request->validate([
                'class_id'     => 'required',
                'session_id'   => 'required',
                'exam_id'      => 'required',
                'subject_id'   => 'required|array',
                'subject_id.*' => 'required|integer',
                'date'         => 'required|array',
                'day'          => 'required|array',
                'room'         => 'required|array',
                'time'         => 'required|array',
                'marks'        => 'required|array',
                'summary'      => 'nullable|array',
            ]);

            // Check for existing record
            $existing = ExamRouting::where('class_id', $request->class_id)
                ->where('session_id', $request->session_id)
                ->where('exam_id', $request->exam_id)
                ->whereNull('deleted_at') // if using soft delete
                ->first();

            if ($existing) {
                return redirect()->back()->with('error', 'This exam routing already exists for this class, session, and exam.');
            }

            // Parent ExamRouting Create
            $examRouting             = new ExamRouting();
            $examRouting->class_id   = $request->class_id;
            $examRouting->session_id = $request->session_id;
            $examRouting->exam_id    = $request->exam_id;
            $examRouting->save();

            // Child ExamRoutingDetail Create (loop through each row)
            foreach ($request->subject_id as $index => $subjectId) {
                $detail                  = new ExamRoutingDetails();
                $detail->exam_routing_id = $examRouting->id;
                $detail->subject_id      = $subjectId;
                $detail->date            = $request->date[$index];
                $detail->day             = $request->day[$index];
                $detail->room            = $request->room[$index];
                $detail->time            = $request->time[$index];
                $detail->mark            = $request->marks[$index];
                $detail->summary         = $request->summary[$index] ?? null;
                $detail->save();
            }

            DB::commit();

            return redirect()->back()->with('success', 'Exam Routing Created Successfully');

        } catch (\Exception $exception) {
            DB::rollBack();
            // dd($exception);
            return redirect()->back()->with('error', $exception->getMessage());
        }
    }

    public function examRoutingEdit($id)
    {
        $examRouting = ExamRouting::with(['details.subject', 'class', 'session', 'exam'])->findOrFail($id);

        $classes  = StudentClass::all();
        $sessions = StudentSession::all();
        $exams    = StudentExam::all();

        $existingSubjectIds = $examRouting->details->pluck('subject_id')->toArray();
        $availableSubjects  = $examRouting->class->subjects->whereNotIn('subject_id', $existingSubjectIds);
        $newSubjects        = Subject::whereIn('id', $availableSubjects->pluck('subject_id'))->get();

        // dd("new subject id",$newSubjects, "existing subject id",$existingSubjectIds);

        return view('dashboard.settings.exam_routing_edit', compact('examRouting', 'classes', 'sessions', 'exams', 'newSubjects'));
    }

    public function examRoutingShow($id)
    {
        try {
            $examRouting = ExamRouting::with(['class', 'session', 'exam', 'details.subject'])->findOrFail($id);
            $invoice     = InvoiceDesign::first();
            return view('dashboard.settings.exam_routing_show', compact('examRouting', 'invoice'));
        } catch (\Exception $e) {
            return redirect()->route('exam.routing')->with('error', $e->getMessage());
        }
    }

 public function examRoutingPrint($exam_id, $session_id)
{
    try {
        // Fetch invoice design details
        $invoice = InvoiceDesign::first();

        $invoice = (object)[
            'invoice_bg'     => $invoice->invoice_bg ?? null,
            'invoice_header' => $invoice->invoice_header ?? null,
            'invoice_footer' => $invoice->invoice_footer ?? null,
        ];

        // Fetch routing details including subjects, classes, and exam data
        $routings = \App\Models\ExamRouting::with([
                'class:id,name',
                'session:id,name',
                'exam:id,name',
                'details' => function($q) {
                    // Order details by date
                    $q->orderBy('date', 'asc');
                },
                'details.subject:id,name'
            ])
            ->where('session_id', $session_id)
            ->where('exam_id', $exam_id)
            ->orderBy('class_id')
            ->get();

        // Fetch exam details with more comprehensive data like room, time, etc.
        $routingDetails = DB::table('exam_routings_details as erd')
            ->join('subjects as s', 's.id', '=', 'erd.subject_id')
            ->join('exam_routings as er', 'er.id', '=', 'erd.exam_routing_id')
            ->join('student_classes as c', 'c.id', '=', 'er.class_id')
            ->join('student_sessions as ses', 'ses.id', '=', 'er.session_id')
            ->join('student_exams as e', 'e.id', '=', 'er.exam_id')
            ->where('er.session_id', $session_id)
            ->where('er.exam_id', $exam_id)
            ->select('erd.*', 's.name as subject_name', 'c.name as class_name', 'ses.name as session_name', 'e.name as exam_name')
            ->get();

        // Group the routing details by class_name for rendering in the view
        $groupedByClass = $routingDetails->groupBy('class_name');
        
        // Group the routing details by date
        $groupedByDate = $routingDetails->groupBy('date');

        // Fetch session and exam details from the first routing data
        $sample = $routings->first();
        $session = $sample?->session;
        $exam = $sample?->exam;

        // Return the view with the necessary data
        return view('dashboard.settings.exam_routing_print', compact('groupedByClass', 'groupedByDate', 'session', 'exam', 'invoice','routingDetails'));

    } catch (\Throwable $e) {
        // Handle any errors that occur during the fetching of data
        return back()->with('error', $e->getMessage());
    }
}



    public function examRoutingUpdate(Request $request, $id)
    {
        DB::beginTransaction();
        try {
            $examRouting             = ExamRouting::findOrFail($id);
            $examRouting->class_id   = $request->class_id;
            $examRouting->session_id = $request->session_id;
            $examRouting->exam_id    = $request->exam_id;
            $examRouting->save();

            ExamRoutingDetails::where('exam_routing_id', $examRouting->id)->delete();

            foreach ($request->subject_id as $index => $subjectId) {
                ExamRoutingDetails::create([
                    'exam_routing_id' => $examRouting->id,
                    'subject_id'      => $subjectId,
                    'date'            => $request->date[$index],
                    'day'             => $request->day[$index],
                    'room'            => $request->room[$index],
                    'time'            => $request->time[$index],
                    'mark'            => $request->marks[$index],
                    'summary'         => $request->summary[$index],
                ]);
            }

            DB::commit();
            return redirect()->back()->with('success', 'Exam Routing Updated Successfully');
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function examRoutingDestroy($id)
    {
        DB::beginTransaction();
        try {
            $examRouting = ExamRouting::findOrFail($id);

            // Delete related details
            ExamRoutingDetails::where('exam_routing_id', $examRouting->id)->delete();

            // Delete main routing
            $examRouting->delete();

            DB::commit();
            return response()->json(['success' => true, 'message' => 'Exam Routing deleted successfully']);
        } catch (\Exception $e) {
            DB::rollBack();
            dd($e);
            return response()->json(['success' => false, 'message' => $e->getMessage()]);
        }
    }

    public function examRoutingGetExam(Request $request)
    {
        if ($request->ajax()) {
            $class_id   = $request->class_id;
            $session_id = $request->session_id;
            $examIds    = ExamRouting::where('class_id', $class_id)
                ->where('session_id', $session_id)
                ->pluck('exam_id');

            $exams = StudentExam::whereIn('id', $examIds)->get();
            if ($exams->isEmpty()) {
                return response()->json(['success' => false, 'message' => 'No exams found']);
            }
            return response()->json(['success' => true, 'data' => $exams]);
        }
        return response()->json(['success' => false, 'message' => 'Invalid request']);
    }

    public function monthSearch(Request $request)
    {
        $query   = strtolower($request->get('q', ''));
        $results = [];

        $monthsList = [
            '01' => 'January',
            '02' => 'February',
            '03' => 'March',
            '04' => 'April',
            '05' => 'May',
            '06' => 'June',
            '07' => 'July',
            '08' => 'August',
            '09' => 'September',
            '10' => 'October',
            '11' => 'November',
            '12' => 'December',
        ];

        $startYear = 2025;
        $endYear   = 3000;

        for ($year = $startYear; $year <= $endYear; $year++) {
            foreach ($monthsList as $num => $month) {
                $text = "$month $year";
                $id   = "$year-$num";

                if (
                    empty($query) ||
                    str_contains(strtolower($month), $query) ||
                    str_contains((string) $year, $query) ||
                    str_contains(strtolower($text), $query)
                ) {
                    $results[] = [
                        'id'   => $id,
                        'text' => $text,
                    ];
                }
            }
        }

        // প্রথম 50টি রেজাল্ট ফেরত দাও যাতে অতিরিক্ত ডাটা না যায়
        return response()->json(array_slice($results, 0, 50));
    }

    public function getStudentsByClass(Request $request)
    {
        $students = Student::where('class_id', $request->class_id)
            ->where('etim', 2)
            ->whereNull('deleted_at')
            ->where(function ($q) {
                $q->where('status', 1)
                    ->orWhereNull('status');
            })
            ->select('id', 'name', 'register_no', 'session_id', 'monthly_dis')
            ->orderBy('name')
            ->get();

        return response()->json($students);
    }

    public function GetAdmissionFee(Request $request)
    {
        $class_id           = $request->class_id;
        $admission_type_new = $request->admission_type == 1;
        $admission_type_old = $request->admission_type == 2;
        $admissionFee       = AdmissionFee::first();
        // dd($class_id, $admission_type_new, $admission_type_old);
        $fee = StudentClass::find($class_id);
        // dd($fee);
        if ($admission_type_new) {
            $fee = $fee->new_admission_amount ?? $admissionFee->amount ?? 0;
            return response()->json($fee);
        } elseif ($admission_type_old) {
            $fee = $fee->old_admission_amount ?? $admissionFee->amount ?? 0;
            return response()->json($fee);
        }

    }
}
