<?php

namespace App\Models;

use App\Models\FeeSetup;
use App\Models\SessionSetup;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Department extends Model
{
    use HasFactory, SoftDeletes;

    public function section(): BelongsTo
    {
        return $this->belongsTo(SessionSetup::class, 'section_id', 'id')->withTrashed();
    }

    public function fees(): BelongsTo
    {
        return $this->belongsTo(FeeSetup::class, 'fee_id', 'id')->withTrashed();
    }
}
