<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ExamRouting extends Model
{
    protected $table = 'exam_routings';
    protected $guarded = ['id'];

    public function session()
    {
        return $this->belongsTo('App\Models\StudentSession', 'session_id', 'id');
    }

 

    public function class()
    {
        return $this->belongsTo('App\Models\StudentClass', 'class_id', 'id');
    }
    public function exam()
    {
        return $this->belongsTo('App\Models\StudentExam', 'exam_id', 'id');
    }
    public function details()
    {
        return $this->hasMany('App\Models\ExamRoutingDetails', 'exam_routing_id', 'id');
    }
}


