<?php

namespace App\Models;

use App\Models\User;
use App\Models\Donar;
use App\Models\Student;
use App\Models\Teacher;
use App\Models\ExpenseType;
use App\Models\StudentExam;
use App\Models\DonationType;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class FundDetail extends Model
{
    use HasFactory, SoftDeletes;

    // protected $table = 'fund_details';
    protected $guarded = [];

    public function funds(): BelongsTo
    {
        return $this->belongsTo(Fund::class, 'fund_id', 'id')->withTrashed();
    }
    public function users(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by', 'id')->withTrashed();
    }
    public function extypes(): BelongsTo
    {
        return $this->belongsTo(ExpenseType::class, 'expense_type_id', 'id')->withTrashed();
    }
    public function students(): BelongsTo
    {
        return $this->belongsTo(Student::class, 'student_id', 'id')->withTrashed();
    }
    public function donationType(): BelongsTo
    {
        return $this->belongsTo(DonationType::class, 'donation_type_id', 'id')->withTrashed();
    }
    public function teacher(): BelongsTo
    {
        return $this->belongsTo(Teacher::class, 'teacher_id', 'id')->withTrashed();
    }
    public function donar(): BelongsTo
    {
        return $this->belongsTo(Donar::class, 'donar_id', 'id')->withTrashed();
    }
    public function exam(): BelongsTo
    {
        return $this->belongsTo(StudentExam::class, 'exam_id', 'id')->withTrashed();
    }

    public function staff(): BelongsTo
    {
        return $this->belongsTo(Staff::class, 'staff_id', 'id')->withTrashed();
    }
}
