<?php

namespace App\Models;

use App\Models\User;
use App\Models\TeacherResponsibility;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ResponsibilityAssign extends Model
{
    use HasFactory, SoftDeletes;

    public function teacher(): BelongsTo
    {
        return $this->belongsTo(Teacher::class, 'teacher_id', 'id')->withTrashed();
    }
    public function responsibilities(): BelongsTo
    {
        return $this->belongsTo(TeacherResponsibility::class, 'responsibility_id', 'id')->withTrashed();
    }
    public function createdBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by', 'id')->withTrashed();
    }
}
