<?php

namespace App\Models;

use App\Models\Student;
use App\Models\StudentExam;
use App\Models\StudentClass;
use App\Models\StudentSession;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class StudentComment extends Model
{
    use HasFactory, SoftDeletes;

    public function stuclass(): BelongsTo
    {
        return $this->belongsTo(StudentClass::class, 'class_id', 'id')->withTrashed();
    }
    public function exam(): BelongsTo
    {
        return $this->belongsTo(StudentExam::class, 'exam_id', 'id')->withTrashed();
    }
    public function student(): BelongsTo
    {
        return $this->belongsTo(Student::class, 'student_id', 'id')->withTrashed();
    }
    public function stusession(): BelongsTo
    {
        return $this->belongsTo(StudentSession::class, 'session_id', 'id')->withTrashed();
    }
}
