<?php

namespace App\Models;

use App\Models\StudentFee;
use App\Models\FeeAssignDetail;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class StudentFeeDetail extends Model
{
    use HasFactory, SoftDeletes;

    public function fees(): BelongsTo
    {
        return $this->belongsTo(StudentFee::class, 'fee_id', 'id')->withTrashed();
    }

    public function feeAssign(): BelongsTo
    {
        return $this->belongsTo(FeeAssignDetail::class, 'fee_assign_id', 'id')->withTrashed();
    }
}
