<?php

namespace App\Models;

use App\Models\Donar;
use App\Models\Student;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class StudentSponsor extends Model
{
    use HasFactory, SoftDeletes;

    public function student(): BelongsTo
    {
        return $this->belongsTo(Student::class, 'student_id', 'id')->withTrashed();
    }
    public function donar(): BelongsTo
    {
        return $this->belongsTo(Donar::class, 'donar_id', 'id')->withTrashed();
    }
}
