<?php
namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password'          => 'hashed',
        ];
    }

    public function role()
    {return $this->belongsTo(Role::class, 'role_id');}

    // check by full key: "students.view" / "payment.create"
    public function canPerm(string $permKey): bool
    {
        if (! $this->role) {
            return false;
        }

        // eager-load করলে N+1 কমবে
        $perms = $this->role->relationLoaded('permissions')
            ? $this->role->permissions
            : $this->role->permissions()->get();

        return $perms->contains('key', $permKey);
    }

    // shorthand: module + action → "module.action"
    public function canMA(string $module, string $action): bool
    {
        return $this->canPerm("$module.$action");
    }
}
