@extends('dashboard.master')
@section('title', 'Admit Card Create ')
@section('content')
@push('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
@endpush

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span>
                        <b>Admit Card Create </b>
                    </span>
                </div>

                <div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <div class="card-body">
                    <div class="col-md-4">
                        <div class="form-group">
                            <span for="">Name :  <b>{{ $exam->exam->name ?? '' }} </b></span>
                        </div>
                    </div>

                    <hr>
                    <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                        <thead>
                            <tr>
                                <th>SN</th>
                                <th>Student</th>
                                <th>Class </th>
                                <th>Roll</th>
                                <th>Seat No</th>
                                <th>Admit Card</th>
                            </tr>
                        </thead>
                        <tbody>

                            @foreach($students as $item)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $item->students->name ??'' }}</td>
                                <td>{{ $item->stuclass->name ??'' }}</td>
                                <td>{{ $item->students->roll_no ??'' }}</td>
                                <td>{{ $item->seat_no ?? '' }}</td>
                                <td>
                                    @if($item->status == 1)
                                        <span class="badge badge-primary">Given</span>
                                    @else
                                    <form class="forms-sample add-class" enctype="multipart/form-data" action="{{ route('admitcard.store') }}" method="POST" id="admitCardForm">
                                        @csrf
                                        <input type="hidden" name="exam_id" value="{{ $exam->exam_id ?? '' }}">
                                        <input type="hidden" name="student_id" value="{{ $item->student_id ?? '' }}">
                                        <input type="hidden" name="class_id" value="{{ $item->class_id ?? '' }}">
                                        <input type="hidden" name="session_id" value="{{ $item->session_id ?? '' }}">
                                        <button type="submit" class="btn btn-danger">  <i class="fas fa-file mr-1"></i> Print </button>
                                    </form>
                                    @endif
                                </td>
                            </tr>
                            @endforeach

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>
</div>
@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    if (localStorage.getItem('admitCardSubmitted')) {
        document.querySelectorAll('.add-class button[type="submit"]').forEach(button => {
            button.disabled = true;
        });
    }

    window.onbeforeunload = function() {
        localStorage.removeItem('admitCardSubmitted');
    };

    document.querySelector('#admitCardForm').addEventListener('submit', function() {
        localStorage.setItem('admitCardSubmitted', 'true');
    });
});
@if(Session::has('success'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
        "timeOut" : 1000
    };
    toastr.success("{{ session('success') }}");
@endif

 @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
 @endif
</script>
@endpush

@endsection
