@extends('dashboard.master')
@section('title', 'Admitcard Edit')
@push('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
<style>
.select2-container--default .select2-selection--single {
    height: calc(2.25rem + 2px);
    line-height: calc(2.25rem + 2px);
}

.select2-container--default .select2-selection__rendered {
    padding-top: 0.375rem;
    padding-bottom: 0.375rem;
}
</style>
@endpush
@section('content')

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span>
                        <b>Admitcard Edit</b>
                    </span>
                </div>

                <div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <form class="forms-sample add-class" enctype="multipart/form-data" action="{{ route('admitcard.store') }}" method="POST">
                    @csrf
                    <div class="card-body">

                        <div class="row">

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Receipt No<span class="text-red">*</span></label>
                                    <input type="text" name="receipt_no" id="receipt_no"  value="{{ $receipt_no ?? '' }}" class="form-control" readonly>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Exam<span class="text-red">*</span></label>
                                    <select name="exam_id" id="exam_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach ($exams as $exam)
                                        <option value="{{ $exam->id }}">{{ $exam->name }}</option>
                                        @endforeach
                                    </select>

                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Student<span class="text-red">*</span></label>
                                    <select name="student_id" id="student_id" class="form-control select2" style="width: 100%; height:55px !important">
                                        <option value="">Select One</option>
                                        @foreach ($students as $student)
                                        <option value="{{ $student->id }}" data-class="{{ $student->class_id ?? '' }}" data-session="{{ $student->session_id ?? '' }}">{{ $student->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Session<span class="text-red">*</span></label>
                                    <input type="text" name="session_id" id="session_id" class="form-control" readonly>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Class<span class="text-red">*</span></label>
                                    <input type="text" name="class_id" id="class_id" class="form-control" readonly>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Status<span class="text-red">*</span></label>
                                    <select name="status" id="status" class="form-control" required>
                                        <option value="">Select One</option>
                                        <option value="1">Approved</option>
                                        <option value="2">Pending</option>
                                        <option value="0">Reject</option>
                                    </select>
                                </div>
                            </div>

                        </div>

						<div class="row mt-20 hideClass">
							<div class="col-sm-12">
								<button title="Save" type="submit" class="btn btn-primary mr-2">Save</button>
							</div>
						</div>

                    </div>
                </form>
            </div>
        </div>
    </section>
</div>

@push('js')
<script src="{{ asset('backend/plugins/select2/js/select2.full.min.js') }}"></script>

<script>
$('.select2').select2();
$(document).ready(function() {
    $('#student_id').on('change', function(event) {
        event.preventDefault();
        var student_id = $(this).val();
        var selectedOption = $(this).find('option:selected');
        var class_id = selectedOption.data('class');
        var session_id = selectedOption.data('session');
        $('#class_id').val(class_id);
        $('#session_id').val(session_id);
    });
});
</script>
@endpush
@endsection
