<!DOCTYPE html>
<html lang="bn">

<head>
    <meta charset="UTF-8">
    <title>প্রবেশ পত্র</title>

    <?php

$invoiceBgPath = 'back_height.jpg';

if (isset($invoice->invoice_bg) && !empty($invoice->invoice_bg)) {
    $potentialBgFile = 'img/' . $invoice->invoice_bg;
    if (file_exists(public_path($potentialBgFile))) {
        $invoiceBgPath = $potentialBgFile;
    }
}
?>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Noto+Serif+Bengali&display=swap');

        body {
            font-family: 'Noto Serif Bengali', serif;
            background-color: #fdf6e3;
            margin: 0;
            padding: 0;
        }

        .admit-card {
            width: 210mm;
            height: 148.5mm;
            margin: auto;
            background: #fff8e1;
            padding: 2mm;
            border: 1px solid #c49b0c;
            border-radius: 6px;
           background-image: url('{{ asset($invoiceBgPath) }}') !important;
                background-size: cover !important;
                background-position: center !important;
                background-repeat: no-repeat ;
            box-sizing: border-box;
        }

        .header {
            text-align: center;
            color: #c49b0c;
        }

        .header img {
            height: 32px;
            margin-bottom: 4px;
        }

        .header h2 {
            margin: 2px 0;
            font-size: 14px;
            color: #c49b0c;
        }

        .header h4 {
            margin: 0;
            font-size: 10px;
            color: #444;
        }

        .title-box {
            margin: 8px auto;
            background-color: #c49b0c;
            color: white;
            padding: 4px 0;
            font-size: 11px;
            font-weight: bold;
            border-radius: 4px;
            width: 130px;
            text-align: center;
        }

        .info-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
            margin-top: 5px;
            
        }

        .info-table td {
            padding: 2px 6px;
            border: 0.5px solid #e0d6b4;
        }

        .info-label {
            /* background-color: #f9f3dc; */
            background-color: transparent;
            font-weight: bold;
            color: #3b3b3b;
            width: 20%;
        }

        .instructions {
            /* margin-top: 7px; */
            padding: 5px;
            /* border: 0.5px solid #c49b0c; */
            background: transparent;
            /* background: #fffef9; */

            border-radius: 4px;
            max-height: unset;
            overflow: hidden;
        }

        .instructions h3 {
            text-align: center;
            background-color: #c49b0c;
            color: white;
            padding: 3px 0;
            margin: 0 0 5px;
            border-radius: 3px;
            font-size: 10px;
        }

        .routine-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
            /* margin-bottom: 12px; */
            font-weight: bold
        }

        .routine-table th,
        .routine-table td {
            border: 0.5px solid #e0d6b4;
            padding: 5px 5px 2px 5px;
            line-height: 1.4;
        }

        .routine-table th {
            /* background-color: #f9f3dc; */
            background-color: transparent;
            font-weight: bold;
        }

        .signature-row {
            display: flex;
            justify-content: space-between;
            margin-top: 14px;
            font-weight: bold;
            font-size: 10px;
            color: #3b3b3b;
        }

        .signature-column-left {
            text-align: left;
        }

        .signature-column-right {
            text-align: right;
        }

        @media print {
            @page {
                size: A5 landscape;
                margin: 3mm;
            }

            body {
                background: white;
                margin: 0;
                padding: 0;
            }

            .admit-card {
                box-shadow: none;
                border: none;
                page-break-after: always;
                width: auto;
                height: auto;
            }
        }
    </style>
</head>

<body>
    <div class="admit-card">
        <div class="header" style="
    display: flex;
    justify-content: center;
    align-items: center;">
            <img src="{{ asset('img/' . $setting->logo) }}" style="margin-right: 10px" alt="Logo">
            <div style="text-align:start">
                <h2>{{ $setting->long_name ?? '' }}</h2>
                <h4>{{ $setting->address ?? '' }}</h4>
            </div>
        </div>

        <div class="title-box">প্রবেশ পত্র</div>

        <table class="info-table">
            <tr>
                <td class="info-label" style="width: 10%">পরীক্ষা</td>
                <td class="info-label">{{ $data->exams->name ?? '' }}</td>
                <td class="info-label" style="width: 10%">শিক্ষার্থীর নাম</td>
                <td class="info-label">{{ $data->students->name ?? '' }}</td>
                <td class="info-label" style="width: 10%">পিতার নাম</td>
                <td class="info-label">{{ $data->students->father_name ?? '' }}</td>
                <td rowspan="3" style="text-align: center;">
                    @if (isset($data->students->image))
                        <img src="{{ asset('backend/img/student/' . $data->students->image) }}" alt="Student Photo"
                            style="width: 80px; height: 80px; object-fit: cover;">
                    @else
                        <span style="font-size: 12px;">ছবি নেই</span>
                    @endif
                </td>
            </tr>
            <tr>
                <td class="info-label" style="width: 10%">সিট নং</td>
                <td class="info-label">{{ $data->seat_no ?? '' }}</td>
                <td class="info-label" style="width: 10%">শ্রেণি</td>
                <td class="info-label">{{ $data->students->stuclass->name ?? '' }}</td>
                <td class="info-label" style="width: 10%">রোল নং</td>
                <td class="info-label">{{ $data->students->roll_no ?? '' }}</td>


            </tr>
            <tr>
                <td class="info-label" style="width: 10%">রেজিঃ নং</td>
                <td class="info-label">{{ $data->students->register_no ?? '' }}</td>
                <td class="info-label" style="width: 10%">শিক্ষা বর্ষ</td>
                <td class="info-label">{{ $data->students->stusession->name ?? '' }}</td>
                <td class="info-label" style="width: 10%">তারিখ</td>
                <td class="info-label">{{ \Carbon\Carbon::parse($setting->date)->format('d/m/Y') ?? '' }}</td>
            </tr>
        </table>

        <div class="instructions">
            @if (isset($examRouting))
                <table class="routine-table">
                    <thead>
                        <tr>
                            <th style="width: 28%; text-align:start">বিষয়</th>
                            <th style="text-align:start">তারিখ</th>
                            <th style="text-align:start">দিন</th>
                            <th style="text-align:start">রুম</th>
                            <th style="text-align:start">সময়</th>
                            <th style="text-align:start">মার্কস</th>
                            <th style="text-align:start">বিবরণ</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($examRouting->details->sortBy(function ($detail) {
        return \Carbon\Carbon::parse($detail->date . ' ' . $detail->time);
    }) as $detail)
                            <tr>
                                <td>{{ $detail->subject->name ?? '' }}</td>
                                <td>{{ \Carbon\Carbon::parse($detail->date)->format('d/m/Y') }}</td>
                                <td>{{ $detail->day ?? '' }}</td>
                                <td>{{ $detail->room ?? '' }}</td>
                                <td>{{ \Carbon\Carbon::parse($detail->time)->format('h:i A') ?? '' }}</td>
                                <td>{{ $detail->mark ?? '' }}</td>
                                <td>{{ $detail->summary ?? '' }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @endif
        </div>

        <div class="signature-row">
            <div class="signature-column-left">পরীক্ষা নিয়ন্ত্রকের স্বাক্ষর</div>
            <div class="signature-column-right">অধ্যক্ষ মহোদয়ের স্বাক্ষর</div>
        </div>
    </div>

    <script type="text/javascript">
        localStorage.clear();

        function auto_print() {
            window.print();
        }
        setTimeout(auto_print, 1000);
    </script>
</body>

</html>
