<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <title>প্রবেশ পত্র</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Noto+Serif+Bengali&display=swap');

        body {
            font-family: 'Noto Serif Bengali', serif;
            background-color: #fdf6e3;
            margin: 0;
            padding: 10px;
        }

        .admit-card {
            width: 100%;
            max-width: 559px; /* A5 width */
            margin: auto;
            background: #fff8e1;
            padding: 20px;
            border: 2px solid #c49b0c;
            border-radius: 12px;
            box-shadow: 0 6px 12px rgba(0,0,0,0.1);
            background-image: url('{{ asset('back_height.jpg') }}');
            background-size: cover;
            background-position: center;
        }

        .header {
            text-align: center;
            color: #c49b0c;
        }

        .header img {
            height: 60px;
            margin-bottom: 10px;
        }

        .header h2 {
            margin: 5px 0;
            font-size: 22px;
            color: #c49b0c;
        }

        .header h4 {
            margin: 0;
            font-size: 14px;
            color: #444;
        }

        .title-box {
            margin: 20px auto;
            background-color: #c49b0c;
            color: white;
            padding: 8px 0;
            font-size: 18px;
            font-weight: bold;
            border-radius: 6px;
            width: 220px;
            text-align: center;
        }

        .info-table {
            width: 100%;
            margin-top: 10px;
            border-collapse: collapse;
            background-color: #fffdfa;
            border-radius: 8px;
            overflow: hidden;
        }

        .info-table td {
            padding: 8px;
            border: 1px solid #e0d6b4;
            font-size: 14px;
        }

        .info-label {
            background-color: #f9f3dc;
            font-weight: bold;
            width: 30%;
            color: #3b3b3b;
        }

        .instructions {
            margin-top: 20px;
            padding: 15px;
            border: 2px solid #c49b0c;
            background: #fffef9;
            border-radius: 8px;
        }

        .instructions h3 {
            text-align: center;
            background-color: #c49b0c;
            color: white;
            padding: 6px 0;
            margin: 0 0 12px;
            border-radius: 6px;
            font-size: 16px;
        }

        .instructions ol {
            font-size: 13px;
            padding-left: 20px;
            color: #444;
            line-height: 1.6;
        }

        .highlight {
            color: red;
            font-weight: bold;
            text-align: center;
            margin-top: 10px;
            font-size: 13px;
        }

        .signature-row {
            display: flex;
            justify-content: space-between;
            margin-top: 30px;
            font-weight: bold;
            font-size: 14px;
            color: #3b3b3b;
        }

        .signature-column-left, .signature-column-right {
            width: 48%;
        }

        .signature-column-left {
            text-align: left;
        }

        .signature-column-right {
            text-align: right;
        }

        @media print {
            @page {
                size: A5 portrait;
                margin: 3mm;
            }
            body {
                background: white;
                margin: 0;
                padding: 0;
            }

            .admit-card {
                box-shadow: none;
                border: 1px solid #ccc;
                page-break-after: always;
            }
        }
    </style>
</head>
<body>
    <div class="admit-card">
        <div class="header">
            <img src="{{ asset('img/'. $setting->logo) }}" alt="Logo">
            <h2>{{ $setting->long_name ?? '' }}</h2>
            <h4>{{ $setting->address ?? '' }}</h4>
        </div>

        <div class="title-box">প্রবেশ পত্র</div>

        <table class="info-table">
            <tr>
                <td class="info-label">পরীক্ষার নাম</td>
                <td colspan="3"> {{ $data->exams->name ?? '' }}</td>
            </tr>
            <tr>
                <td class="info-label">শিক্ষার্থীর নাম</td>
                <td colspan="3"> {{ $data->students->name ?? '' }}</td>
            </tr>
            <tr>
                <td class="info-label">পিতার নাম</td>
                <td colspan="3"> {{ $data->students->father_name ?? '' }}</td> <!-- Added father name -->
            </tr>
            <tr>
                <td class="info-label">শ্রেণি/স্তর</td>
                <td> {{ $data->students->stuclass->name ?? '' }}</td>
                <td class="info-label">রোল নং</td>
                <td> {{ $data->students->roll_no ?? '' }}</td>
            </tr>
            <tr>
                <td class="info-label">শিক্ষা বর্ষ</td>
                <td> {{ $data->students->stusession->name ?? '' }}</td>
                <td class="info-label">তারিখ</td>
                <td> {{ \Carbon\carbon::parse($setting->date)->format('d/m/Y') ?? '' }}</td>
            </tr>
        </table>

        <div class="signature-row">
            <div class="signature-column-left">পরীক্ষা নিয়ন্ত্রকের স্বাক্ষর</div>
            <div class="signature-column-right">অধ্যক্ষ মহোদয়ের স্বাক্ষর</div>
        </div>

        <div class="instructions">
            <h3>পরীক্ষার্থীর জন্য পালনীয় বিধি-নিষেধ</h3>
            <ol>
                <li>সকল পরীক্ষার্থীকে পরীক্ষার শুরু হওয়ার কমপক্ষে ৩০ মিনিট পূর্বে কেন্দ্রে (প্রবেশ পত্র সহ) উপস্থিত হতে হবে।</li>
                <li>পরীক্ষার হলে মোবাইল ফোন, স্মার্ট ঘড়ি, ইলেকট্রনিক ডিভাইস সম্পূর্ণ নিষিদ্ধ।</li>
                <li>প্রবেশ পত্র ব্যতীত পরীক্ষার হলে প্রবেশ করা যাবে না।</li>
                <li>প্রতিটি পরীক্ষার শেষে প্রশ্নপত্র জমা দিতে হবে।</li>
                <li>পরীক্ষার হলে নিরবতা বজায় রাখতে হবে এবং অন্যদের বিঘ্ন ঘটানো যাবে না।</li>
                <li>যেকোনো ধরনের অসদুপায় অবলম্বন করলে তাৎক্ষণিকভাবে পরীক্ষার্থীকে বহিষ্কার করা হবে।</li>
            </ol>
            <div class="highlight">
                অনুপস্থিত কোন পরীক্ষা নেয়া হবে না, পরীক্ষার ফলাফল বাতিল হবে।
            </div>
        </div>
    </div>
    <script type="text/javascript">
        localStorage.clear();
       
    </script>
</body>
</html>
