@extends('dashboard.master')
@section('title', 'Student Attendance Create')

@push('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
<style>
    .status-green {
        color: green !important;
    }

    .status-red {
        color: red !important;
    }

    .status-yellow {
        color: yellow !important;
    }

    .status-gray {
        color: gray !important;
    }

    .status-orange {
        color: orange !important;
    }

    .attendance-status-section {
        display: none;
    }
    #message{
        color: red;
    }
</style>
@endpush
@section('content')

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span>
                        <b>Student Attendance Create</b>
                    </span>
                </div>

                <div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <form class="forms-sample add-class" enctype="multipart/form-data" action="{{ route('student.attendance.store') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        <div class="row">

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Class<span class="text-red">*</span></label>
                                    <select name="class_id" id="class_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach ($classes as $class)
                                        <option value="{{ $class->id }}">{{ $class->name }}</option>
                                        @endforeach
                                    </select>

                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Session<span class="text-red">*</span></label>
                                    <select name="session_id" id="session_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach ($sessions as $session)
                                        <option value="{{ $session->id }}">{{ $session->name }}</option>
                                        @endforeach
                                    </select>

                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Date<span class="text-red">*</span></label>
                                    <div class="d-flex">
                                        <input type="text" name="date" id="date" value="{{ now()->format('Y-m-d') }}" class="form-control" placeholder="date" required>
                                        <button title="Find" id="button" type="submit" class="btn btn-primary ml-2">Find</button>
                                    </div>

                                    @if (session('error'))
                                        <div class="alert alert-danger mt-2">
                                            {{ session('error') }}
                                        </div>
                                    @endif

                                </div>
                            </div>
                        </div>
                        <hr>
                        <span id="message"></span>
                        <div class="attendance-status-section">
                        <div class="box-body">

                                <div class="mailbox-controls">
                                    <div class="row">

                                        <div class="col-md-12 d-flex justify-content-between align-items-center">

                                            <div class="form-group d-flex align-items-center">
                                                <span for="attendance_type" class="mr-3">Set attendance for all students as:</span>

                                                <div class="radio radio-info radio-inline mx-3 mt-2">
                                                    <input type="radio" name="attendance_status" class="all_present" value="all_present" id="all_present" autocomplete="off">
                                                    <label for="all_present" style="font-weight: normal;">All Present</label>
                                                </div>

                                                <div class="radio radio-info radio-inline mx-3 mt-2">
                                                    <input type="radio" name="attendance_status" class="all_late" value="all_late" id="all_late" autocomplete="off">
                                                    <label for="all_late" style="font-weight: normal;">All Late</label>
                                                </div>

                                                <div class="radio radio-info radio-inline mx-3 mt-2">
                                                    <input type="radio" name="attendance_status" class="all_absent" value="all_absent" id="all_absent" autocomplete="off">
                                                    <label for="all_absent" style="font-weight: normal;">All Absent</label>
                                                </div>

                                                <div class="radio radio-info radio-inline mx-3 mt-2">
                                                    <input type="radio" name="attendance_status" class="all_holiday" value="all_holiday" id="all_holiday" autocomplete="off">
                                                    <label for="all_holiday" style="font-weight: normal;">All Holiday</label>
                                                </div>

                                                <div class="radio radio-info radio-inline mx-3 mt-2">
                                                    <input type="radio" name="attendance_status" class="all_halfday" value="all_halfday" id="all_halfday" autocomplete="off">
                                                    <label for="all_halfday" style="font-weight: normal;">All Half Day</label>
                                                </div>

                                            </div>

                                            <div class="form-group">
                                                <button type="submit" name="search" value="saveattendence" id="saveattendence" class="btn btn-primary btn-sm">
                                                    <i class="fa fa-save"></i> Save Attendance
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div><hr>

                                <div class="table-responsive ptt10">
                                    <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Name</th>
                                                <th>Reg No</th>
                                                <th>Attendance</th>
                                            </tr>
                                        </thead>
                                        <tbody id="student_data">

                                        </tbody>
                                    </table>
                                </div>
                            </div>

                        </div>

                    </div>
                </form>
            </div>
        </div>
    </section>
</div>

@push('js')
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script>
$(function () {
    $('#date').datepicker({ dateFormat: 'yy-mm-dd' });
});
$('#message').hide();
$(document).ready(function() {
    $('#button').on('click', function(event) {
        event.preventDefault();

        var url = "{{ route('student.find') }}";
        var date = $('#date').val();
        var class_id = $('#class_id').val();
        var session_id = $('#session_id').val();
        var _token = $('meta[name="csrf-token"]').attr('content');

        $.ajax({
            url: url,
            type: "POST",
            data: {
                date: date,
                class_id: class_id,
                session_id: session_id,
                _token: _token,
            },
            success: function(response) {
                if (response.success === false) {
                    toastr.error(response.message, { positionClass: 'toast-bottom-full-width' });
                    $('#student_data').html('');
                    $('#message').show().text(response.message);
                    $('.attendance-status-section').hide();
                } else {
                    $('#student_data').html(response.html);
                    $('#message').hide();
                    $('.attendance-status-section').show();
                }
            },
            error: function(xhr, status, error) {
                console.error(error);
                alert("An error occurred while processing the request.");
            }
        });
    });
});


$(document).ready(function() {


function updateAttendanceButtons() {
    var allPresentChecked = true;
    var allLateChecked = true;
    var allAbsentChecked = true;
    var allHolidayChecked = true;
    var allHalfdayChecked = true;

    $('.present').each(function() {
        var studentId = $(this).attr('id').split('_')[2];
        var status = $('#status_present_' + studentId).data('status');
        updateStatusColor(studentId, status);

        if (status != 1) {
            allPresentChecked = false;
        }

        if (status != 3) {
            allLateChecked = false;
        }

        if (status != 2) {
            allAbsentChecked = false;
        }

        if (status != 4) {
            allHolidayChecked = false;
        }

        if (status != 5) {
            allHalfdayChecked = false;
        }
    });

    $('#all_present').prop('checked', allPresentChecked);
    $('#all_late').prop('checked', allLateChecked);
    $('#all_absent').prop('checked', allAbsentChecked);
    $('#all_holiday').prop('checked', allHolidayChecked);
    $('#all_halfday').prop('checked', allHalfdayChecked);
}

function updateStatusColor(studentId, status) {
    var statusClass = '';
    var color = '';

    switch (status) {
        case 1:
            statusClass = 'status-green';
            color = 'green';
            break;
        case 2:
            statusClass = 'status-red';
            color = 'red';
            break;
        case 3:
            statusClass = 'status-orange';
            color = 'orange';
            break;
        case 4:
            statusClass = 'status-gray';
            color = 'gray';
            break;
        case 5:
            statusClass = 'status-yellow';
            color = 'yellow';
            break;
    }

    $('#status_present_' + studentId).parent().addClass(statusClass);
    $('#status_absent_' + studentId).parent().addClass(statusClass);
    $('#status_late_' + studentId).parent().addClass(statusClass);
    $('#status_holiday_' + studentId).parent().addClass(statusClass);
    $('#status_halfday_' + studentId).parent().addClass(statusClass);
}

updateAttendanceButtons();

$('.present, .absent, .late, .holiday, .halfday').on('change', function() {
    updateAttendanceButtons();
});

$('input[name="attendance_status"]').on('change', function() {
    var selectedValue = $(this).val();

    if (selectedValue === 'all_present') {
        $('.present').prop('checked', true);
        $('.absent').prop('checked', false);
        $('.late').prop('checked', false);
        $('.holiday').prop('checked', false);
        $('.halfday').prop('checked', false);
    } else if (selectedValue === 'all_late') {
        $('.present').prop('checked', false);
        $('.absent').prop('checked', false);
        $('.late').prop('checked', true);
        $('.holiday').prop('checked', false);
        $('.halfday').prop('checked', false);
    } else if (selectedValue === 'all_absent') {
        $('.present').prop('checked', false);
        $('.absent').prop('checked', true);
        $('.late').prop('checked', false);
        $('.holiday').prop('checked', false);
        $('.halfday').prop('checked', false);
    } else if (selectedValue === 'all_holiday') {
        $('.present').prop('checked', false);
        $('.absent').prop('checked', false);
        $('.late').prop('checked', false);
        $('.holiday').prop('checked', true);
        $('.halfday').prop('checked', false);
    } else if (selectedValue === 'all_halfday') {
        $('.present').prop('checked', false);
        $('.absent').prop('checked', false);
        $('.late').prop('checked', false);
        $('.holiday').prop('checked', false);
        $('.halfday').prop('checked', true);
    }
});

});

</script>
@endpush
@endsection
