@extends('dashboard.master')
@section('title', 'Teacher Attendance')

@push('css')
    <link rel="stylesheet" href="{{ asset('backend/DataTables/datatables.min.css') }}">
@endpush

@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span><b>Teacher Attendance</b></span>
                </div>
                <div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>Back
                    </a>
                    <a title="Create" href="{{ route('teacher.attendance.create') }}" type="button" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus mr-1"></i>Create
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <div class="card-body">
                    <!-- Month Dropdown -->
                    <form id="attendance_filter_form">
                        <div class="row">
                            <div class="col-sm-3">
                                <select id="month_dropdown" class="form-control">
                                    <option value="">Select Month</option>
                                    @foreach($distinctMonths as $month)
                                        <option value="{{ $month->month }}">{{ \Carbon\Carbon::parse($month->month . '-01')->format('F Y') }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-sm-3">
                                <button type="submit" class="btn btn-sm btn-primary">Filter</button>
                            </div>
                            <div class="col-sm-3">
                                <!-- Print Button -->
                                <button id="printButton" class="btn btn-sm btn-danger">Print Attendance</button>
                            </div>
                        </div>
                    </form>

                    <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                        <thead>
                            <tr>
                                <th>SN</th>
                                <th>Date</th>
                                <th>Teacher</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

@push('js')
<script src="{{ asset('backend/DataTables/datatables.min.js') }}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>

<script>
    $(document).ready(function () {
        var dTable = $('#data_table').DataTable({
            order: [],
            lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
            processing: true,
            responsive: false,
            serverSide: true,
            scrollX: true,
            autoWidth: false,
            scroller: {
                loadingIndicator: false
            },
            language: {
                processing: '<i class="ace-icon fa fa-spinner fa-spin orange bigger-500" style="font-size:60px;text-align:center;"></i>'
            },
            pagingType: "full_numbers",
            ajax: {
                url: "{{ route('teacher.all.attendance') }}",
                type: "get",
                data: function (d) {
                    d.month = $('#month_dropdown').val(); // Send selected month
                }
            },
            columns: [
                {data: 'DT_RowIndex', name: 'DT_RowIndex', searchable: false},
                {data: 'date', name: 'date'},
                {data: 'teacher', name: 'teacher'},
                {data: 'action', searchable: false, orderable: false}
            ],
        });

        // Filter form submit event
        $('#attendance_filter_form').on('submit', function (e) {
            e.preventDefault();
            dTable.ajax.reload(); // Reload the data table with the selected month
        });

        // Print Button Click Event
        $('#printButton').on('click', function (e) {
            e.preventDefault();
            var selectedMonth = $('#month_dropdown').val(); // Get the selected month
            if (selectedMonth) {
                window.open("{{ route('teacher.attendance.print', ':month') }}".replace(':month', selectedMonth), '_blank');
            } else {
                alert('Please select a month');
            }
        });
    });
</script>
@endpush
