@extends('dashboard.master')
@section('title', 'Teacher Attendance Create')

@push('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
@endpush

@section('content')

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span>
                        <b>Teacher Attendance Create</b>
                    </span>
                </div>

                <div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <div class="card-body">
                    <form class="forms-sample add-class" enctype="multipart/form-data" action="{{ route('teacher.attendance.take') }}" method="GET">
                        @csrf
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Date<span class="text-red">*</span></label>
                                    <div class="d-flex">
                                        <input type="text" name="date" id="date" value="{{ now()->format('d/m/Y') }}" class="form-control" placeholder="date" required>
                                        <button title="Submit" type="submit" class="btn btn-primary ml-2">Submit</button>
                                    </div>

                                    @if(session('error'))
                                        <div class="alert alert-danger mt-2">
                                            {{ session('error') }}
                                        </div>
                                    @endif

                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
</div>
@push('js')
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script>
$(function () {
    $('#date').datepicker({
        dateFormat: 'dd/m/yy'
    });
});
</script>
@endpush
@endsection

