@extends('dashboard.master')
@section('title', 'Teacher Attendance Details')
@section('content')
<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Teacher Attendance Details</b>
					</span>
				</div>

				<div class="page-title-actions">
                    <a title="Create" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>

					<a title="Create" href="{{ route('teacher.attendance.create') }}" type="button" class="btn btn-sm btn-success">
                        <i class="fas fa-plus mr-1"></i>
                        Create
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
					<table id="data_table" class="table table-bordered table-striped data-table table-hover" >
                        <thead>
                            <tr>
                                <th width="30%">Date</th>
                                <td width="70%">{{ \Carbon\Carbon::parse($data->date)->format('d-M-Y') ?? '' }}</td>
                            </tr>

                            <tr>
                                <th width="30%">Taken By</th>
                                <td width="70%">{{ $data->createdBy->name ?? '' }}</td>
                            </tr>

                        </thead>
                    </table>
                </div>

                <div class="card-body">

					<table id="data_table" class="table table-bordered table-striped data-table table-hover" >
                        <thead>
                            <tr>
                               <th>SN</th>
                               <th>Teacher</th>
                               <th>Reg No</th>
                               <th>Phone</th>
                               <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($teachers as $item)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $item->teacher->name ?? '' }}</td>
                                <td>{{ $item->teacher->reg_no ?? '' }}</td>
                                <td>{{ $item->teacher->phone ?? '' }}</td>
                                <td>
                                    @if($item->status == 1)
                                            <span class="badge badge-success">Present</span>
                                    @elseif($item->status == 2)
                                            <span class="badge badge-danger">Absent</span>
                                    @elseif($item->status == 3)
                                        <span class="badge badge-warning">Late</span>
                                    @elseif($item->status == 4)
                                        <span class="badge badge-info">Holiday</span>
                                    @elseif($item->status == 5)
                                        <span class="badge badge-info">Half Day</span>
                                    @endif
                                </td>
                            </tr>
                            @endforeach

                        </tbody>
                    </table>

				</div>
			</div>
		</div>
	</section>
</div>

@endsection




