@extends('dashboard.master')
@section('title', 'Boarding Bazar Create')
@push('css')
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
@endpush
@section('content')

    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span>
                            <b>Boarding Bazar Create</b>
                        </span>
                    </div>

                    <div class="page-title-actions">
                        <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i>
                            Back
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body">
                        <form class="forms-sample add-class" enctype="multipart/form-data"
                            action="{{ route('boarding.store') }}" method="POST">
                            @csrf
                            <div class="row">
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="">রসিদ নম্বর<span class="text-red">*</span></label>
                                        <input type="text" name="receipt_no" id="receipt_no" value="{{ $receipt_no }}"
                                            class="form-control" readonly>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="">তারিখ<span class="text-red">*</span></label>
                                        <input type="text" name="date" id="date"
                                            value="{{ now()->format('d/m/Y') }}" class="form-control" placeholder="date"
                                            required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="">ফান্ড<span class="text-red">*</span></label>
                                        <select name="fund_id" id="fund_id" class="form-control" required>
                                            <option value="">Select One</option>
                                            @foreach ($fund as $item)
                                                <option value="{{ $item->id }}">{{ $item->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>


                                <!--bazar items-->

                                <div class="col-md-12">
                                    <label for="">বাজারের জিনিসপত্র</label>
                                    <div id="bazarItemsContainer">
                                        <div class="row bazar-item">
                                            <div class="col-md-4">
                                                <input type="text" name="bazar_items[0][item]" class="form-control"
                                                    placeholder=" পণ্যের নাম" required />
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" name="bazar_items[0][weight]" class="form-control"
                                                    placeholder="ওজন (যেমন 2কেজি)"  />
                                            </div>
                                            <div class="col-md-3">
                                                <input type="number" name="bazar_items[0][price]" class="form-control"
                                                    placeholder="মূল্য" required />
                                            </div>
                                            <div class="col-md-1">
                                                <button type="button" class="btn btn-success btn-add-item">+</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>



                                <!--bazar items end-->

                                <div class="col-sm-4 mt-3">
                                    <div class="form-group">
                                        <label for="">মোট টাকার পরিমাণ<span class="text-red">*</span> <span id="showAmount"
                                                style="display:none;">(Available: <b
                                                    id="availableAmount"></b>)</span></label>
                                        <input type="number" name="amount" id="amount" value="{{ old('amount') }}"
                                            class="form-control @error('amount') is-invalid @enderror" placeholder="amount"
                                            required readonly>
                                    </div>
                                </div>


                                <div class="col-md-4 mt-3">
                                    <div class="form-group">
                                        <label for=""> যিনি বাজার করেছেন<span class="text-red">*</span></label>
                                        <input type="text" name="bazar_by" id="bazar_by" value="{{ old('bazar_by') }}"
                                            class="form-control" placeholder="যিনি বাজার করেছেন" required>
                                    </div>
                                </div>

                                {{-- <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="">Bazar List</label>
                                        <textarea name="bazar_list" id="bazar_list" cols="2" rows="2" class="form-control">{{ old('bazar_list') }}</textarea>
                                    </div>
                                </div> --}}
                                <div class="col-md-4 mt-3">
                                    <div class="form-group">
                                        <label for="">নোট</label>
                                        <textarea name="note" id="note" cols="2" rows="2" class="form-control">{{ old('note') }}</textarea>
                                    </div>
                                </div>



                                <div class="col-sm-12" style="margin-top: 20px">
                                    <button title="Save" type="submit" class="btn btn-primary mr-2">সংরক্ষণ করুন</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>


    @push('js')
        <script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
        <script>
            $(function() {
                $('#date').datepicker({
                    dateFormat: 'dd/m/yy'
                });
                let itemIndex = 1;
                let availableAmount = 0;

                function updateTotalAmount() {
                    let total = 0;
                    let availableAmount = parseFloat($('#availableAmount').text()) || 0;
                    $('input[name^="bazar_items"][name$="[price]"]').each(function() {
                        const price = parseFloat($(this).val()) || 0;
                        total += price;
                    });

                    if (total > availableAmount) {
                        toastr.error('Total price exceeds available balance (' + availableAmount + ')');

                        const lastInput = $('input[name^="bazar_items"][name$="[price]"]').last();
                        const lastVal = parseFloat(lastInput.val()) || 0;
                        const excess = total - availableAmount;

                        if (lastVal > excess) {
                            lastInput.val((lastVal - excess).toFixed());
                            total = availableAmount;
                        } else {
                            lastInput.val(0);
                            total -= lastVal;
                        }
                    }

                    $('#amount').val(total.toFixed(2));
                }
                $(document).on('input', 'input[name^="bazar_items"][name$="[price]"]', function() {
                    updateTotalAmount();
                });



                $(document).on('click', '.btn-add-item', function() {
                    const newRow = `
    <div class="row bazar-item mt-2">
        <div class="col-md-4">
            <input type="text" name="bazar_items[${itemIndex}][item]" class="form-control" placeholder="পণ্যের নাম" required />
        </div>
        <div class="col-md-4">
            <input type="text" name="bazar_items[${itemIndex}][weight]" class="form-control" placeholder="ওজন (যেমন 2কেজি)" />
        </div>
        <div class="col-md-3">
            <input type="number" name="bazar_items[${itemIndex}][price]" class="form-control" placeholder="মূল্য" required />
        </div>
        <div class="col-md-1">
            <button type="button" class="btn btn-danger btn-remove-item">-</button>
        </div>
    </div>`;

                    $('#bazarItemsContainer').append(newRow);
                    itemIndex++;
                    updateTotalAmount();
                });

                $(document).on('click', '.btn-remove-item', function() {
                    $(this).closest('.bazar-item').remove();
                    updateTotalAmount();
                });

            });
            $(document).ready(function() {
                // let availableAmount = 0;

                $('#fund_id').on('change', function() {
                    var fund_id = $(this).val();

                    if (fund_id) {
                        $.ajax({
                            url: "{{ route('fund.amount') }}",
                            type: 'POST',
                            data: {
                                fund_id: fund_id,
                                _token: '{{ csrf_token() }}'
                            },
                            success: function(data) {
                                availableAmount = parseFloat(data);
                                $('#availableAmount').text(availableAmount);
                                $('#showAmount').show();
                                updateTotalAmount();
                            },
                            error: function(xhr, status, error) {
                                console.log('Error:', error);
                            }
                        });
                    } else {
                        $('#showAmount').hide();
                    }
                });

                $('#amount').on('input', function() {
                    var inputAmount = parseFloat($(this).val());

                    if (inputAmount > availableAmount) {
                        toastr.error('The amount cannot exceed the available amount of ' + availableAmount);
                        $(this).val(availableAmount);
                    }
                });
            });
            @if (Session::has('success'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true,
                    "timeOut": 1000
                };

                toastr.success("{{ session('success') }}");
            @endif

            @if (Session::has('error'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true
                };
                toastr.error("{{ session('error') }}");
            @endif
        </script>
    @endpush
@endsection
