@extends('dashboard.master')
@section('title', 'Boarding Bazar Edit')
@push('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
@endpush
@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Boarding Bazar Edit</b>
					</span>
				</div>

				<div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
                    <form class="forms-sample add-class" enctype="multipart/form-data" action="{{ route('boarding.update', $data->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">রসিদ নম্বর<span class="text-red">*</span></label>
                                    <input type="text" name="receipt_no" id="receipt_no" value="{{ $receipt_no->receipt_no }}" class="form-control" readonly>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">তারিখ<span class="text-red">*</span></label>
                                    <input type="text" name="date" id="date" value="{{ $data->date }}" class="form-control" placeholder="তারিখ" >
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">ফান্ড<span class="text-red">*</span></label>
                                   <select name="fund_id" id="fund_id" class="form-control" required>
                                    <option value="">Select One</option>
                                    @foreach ($funds as $item)
                                        <option value="{{ $item->id }}" @if($item->id == $data->fund_id) selected @endif>{{ $item->name }}</option>
                                    @endforeach
                                   </select>
                                </div>
                            </div>

                                   <!--Bazar items--->
                                   <div class="col-md-12">
                                    <label>বাজারের জিনিসপত্র</label>
                                    <table class="table table-bordered" id="bazar_items_table">
                                        <thead>
                                            <tr>
                                                <th>পণ্যের নাম</th>
                                                <th>ওজন</th>
                                                <th>মূল্য</th>
                                                <th><button type="button" class="btn btn-sm btn-success" id="addItemRow">+</button></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @if(!empty($data->bazar_items))
                                                @foreach(json_decode($data->bazar_items) as $item)
                                                    <tr>
                                                        <td><input type="text" name="bazar_items[{{ $loop->index }}][item]" value="{{ $item->item }}" class="form-control" /></td>
                                                         <td>
                                            <input type="text" name="bazar_items[{{ $loop->index }}][weight]" value="{{ $item->weight ?? '' }}" class="form-control" placeholder="ওজন (যেমন 2কেজি)" />
                                        </td>
                                                        <td><input type="number" name="bazar_items[{{ $loop->index }}][price]" value="{{ $item->price }}" class="form-control" /></td>
                                                        <td><button type="button" class="btn btn-sm btn-danger removeItemRow">×</button></td>
                                                    </tr>
                                                @endforeach
                                            @else
                                                <tr>
                                                    <td><input type="text" name="bazar_items[0][item]" class="form-control" /></td>
                                                    <td><input type="number" name="bazar_items[0][price]" class="form-control" /></td>
                                                    <td><button type="button" class="btn btn-sm btn-danger removeItemRow">×</button></td>
                                                </tr>
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                                <input type="hidden" id="previousAmount" value="{{ $data->amount ?? 0 }}">

                                                            <!--Bazar items end--->

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="">মোট টাকার পরিমাণ<span class="text-red">*</span> (Available: <b id="availableAmount"></b>)</label>
                                    <input type="number" name="amount" id="amount" value="{{ $data->amount ?? '' }}" class="form-control @error('amount') is-invalid @enderror" placeholder="amount" required readonly>
                                </div>
                            </div>



                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">যিনি বাজার করেছেন<span class="text-red">*</span></label>
                                    <input type="text" name="bazar_by" id="bazar_by" value="{{ $data->bazar_by ?? '' }}" class="form-control" placeholder="যিনি বাজার করেছেন">
                                </div>
                            </div>

                            {{-- <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Bazar List</label>
                                    <textarea name="bazar_list" id="bazar_list" cols="2" rows="2" class="form-control">{{ $data->bazar_list ?? ''}}</textarea>
                                </div>
                            </div> --}}
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">নোট</label>
                                    <textarea name="note" id="note" cols="2" rows="2" class="form-control">{{ $data->note ?? '' }}</textarea>
                                </div>
                            </div>




                            <div class="col-sm-12">
                                <button title="Update" type="submit" class="btn btn-primary mr-2">আপডেট করুন</button>
                            </div>
                        </div>
                    </form>
				</div>
			</div>
		</div>
	</section>
</div>


@push('js')
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script>
$(document).ready(function () {
    $('#date').datepicker({
                    dateFormat: 'dd/m/yy'
                });

    let availableAmount = 0;
    let previousAmount = parseFloat($('#previousAmount').val()) || 0;
    let rowIndex = {{ isset($data->bazar_items) ? count(json_decode($data->bazar_items, true)) : 1 }};

    function updateTotalAmount() {
        let total = 0;
        $('input[name^="bazar_items"][name$="[price]"]').each(function () {
            const price = parseFloat($(this).val()) || 0;
            total += price;
        });

        let adjustedAvailable = availableAmount + previousAmount;

        if (total > adjustedAvailable && availableAmount > 0) {
            toastr.error('Total price exceeds available balance (' + adjustedAvailable + ')');

            const lastInput = $('input[name^="bazar_items"][name$="[price]"]').last();
            const lastVal = parseFloat(lastInput.val()) || 0;
            const excess = total - adjustedAvailable;

            if (lastVal > excess) {
                lastInput.val((lastVal - excess).toFixed());
                total = adjustedAvailable;
            } else {
                lastInput.val(0);
                total -= lastVal;
            }
        }

        $('#amount').val(total.toFixed(2));
    }

    updateTotalAmount();

    $(document).on('input', 'input[name^="bazar_items"][name$="[price]"]', function () {
        updateTotalAmount();
    });

    $('#addItemRow').click(function () {
        let row = `
            <tr>
                <td><input type="text" name="bazar_items[${rowIndex}][item]" class="form-control" /></td>
                <td><input type="text" name="bazar_items[${rowIndex}][weight]" class="form-control" placeholder="ওজন (যেমন 2কেজি)" /></td>
                <td><input type="number" name="bazar_items[${rowIndex}][price]" class="form-control" placeholder="মূল্য" /></td>
                <td><button type="button" class="btn btn-sm btn-danger removeItemRow">×</button></td>
            </tr>`;
        $('#bazar_items_table tbody').append(row);
        rowIndex++;
        updateTotalAmount();
    });

    $(document).on('click', '.removeItemRow', function () {
        $(this).closest('tr').remove();
        updateTotalAmount();
    });

    function updateAvailableBalance(fund_id) {
        if (fund_id) {
            $.ajax({
                url: "{{ route('fund.amount') }}",
                type: 'POST',
                data: {
                    fund_id: fund_id,
                    _token: '{{ csrf_token() }}'
                },
                success: function (data) {
                    availableAmount = parseFloat(data);
                    $('#availableAmount').text(availableAmount);
                    $('#showAmount').show();
                    updateTotalAmount();
                },
                error: function (xhr, status, error) {
                    console.log('Error:', error);
                }
            });
        } else {
            $('#showAmount').hide();
        }
    }

    // On fund change
    $('#fund_id').on('change', function () {
        var fund_id = $(this).val();
        updateAvailableBalance(fund_id);
    });

    // On page load
    var preSelectedFundId = $('#fund_id').val();
    if (preSelectedFundId) {
        updateAvailableBalance(preSelectedFundId);
    }

    @if(Session::has('success'))
        toastr.options = {
            "closeButton": true,
            "progressBar": true,
            "timeOut": 1000
        };
        toastr.success("{{ session('success') }}");
    @endif

    @if(Session::has('error'))
        toastr.options = {
            "closeButton": true,
            "progressBar": true
        };
        toastr.error("{{ session('error') }}");
    @endif
});
</script>
@endpush

@endsection

