@extends('dashboard.master')
@section('title', 'Bazar Details')

@push('css')
    <?php
    $invoiceBgPath = 'back_height.jpg';
    if (isset($invoice->invoice_bg) && !empty($invoice->invoice_bg)) {
        $potentialBgFile = 'img/' . $invoice->invoice_bg;
        if (file_exists(public_path($potentialBgFile))) {
            $invoiceBgPath = $potentialBgFile;
        }
    }
    ?>
    <style>
        .printArea {
            background-image: url('{{ asset($invoiceBgPath) }}');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
        }

        @media print {
            @page {
                size: A6 portrait;
                margin: 5mm;
            }

            body * {
                visibility: hidden;
            }

            .printArea,
            .printArea * {
                visibility: visible;
            }

          

            .printArea {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
                /* background: transparent !important; */
                background-image: url('{{ asset($invoiceBgPath) }}') !important;
                background-size: cover !important;
                background-position: center !important;
                background-repeat: no-repeat !important;
                padding: 0 ! important;
            }
            .container, .container-fluid, .content-wrapper>.content {
                padding: 0 !important;
            }

            img {
                max-width: 100%;
                height: auto;
            }

            table {
                font-size: 10px;
            }
            .print-table th, .print-table td {
                background: transparent !important;
            }
        }
    </style>
@endpush

@section('content')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span><b>Bazar Details</b></span>
                    </div>

                    <div class="page-title-actions">
                        <a title="Back" href="{{ url()->previous() }}" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i> Back
                        </a>
                        <a title="Create" href="{{ route('boarding.create') }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-plus mr-1"></i> Create
                        </a>
                        <a title="Print" id="printButton" class="btn btn-sm btn-danger">
                            <i class="fas fa-file mr-1"></i> Print
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body printArea">
                        <img src="{{ asset('img/' . $invoice->invoice_header) }}" alt="Header"
                            style="width:100%; height:auto; margin-bottom:10px;">

                        <table class="table table-bordered table-striped table-hover print-table">
                            <tbody>
                                <tr>
                                    <th width="30%">তারিখ</th>
                                    <td width="70%">{{ \Carbon\Carbon::parse($data->date)->format('d-M-Y') ?? '' }}</td>
                                </tr>
                                <tr>
                                    <th>ফান্ডের নাম</th>
                                    <td>{{ $data->funds->name ?? '' }}</td>
                                </tr>
                                <tr>
                                    <th>মোট টাকার পরিমাণ</th>
                                    <td>{{ $data->amount ?? '' }}</td>
                                </tr>
                                <tr>
                                    <th>যিনি বাজার করেছেন</th>
                                    <td>{{ $data->bazar_by ?? '' }}</td>
                                </tr>
                                <tr>
                                    <th>তৈরি করেছেন</th>
                                    <td>{{ $data->createdBy->name ?? '' }}</td>
                                </tr>
                                <tr>
                                    <th>নোট</th>
                                    <td>{{ $data->note ?? '' }}</td>
                                </tr>
                                <tr>
                                    <th>বাজারের জিনিসপত্র</th>
                                    <td>
                                        @php $items = json_decode($data->bazar_items, true); @endphp
                                        @if (!empty($items))
                                            <table class="table table-bordered mb-0">
                                                <thead>
                                                    <tr>
                                                        <th>পণ্যের নাম</th>
                                                        <th>ওজন</th>
                                                        <th>মূল্য</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach ($items as $item)
                                                        <tr>
                                                            <td>{{ $item['item'] ?? '' }}</td>
                                                            <td>{{ $item['weight'] ?? '' }}</td>
                                                            <td>{{ number_format($item['price'] ?? 0, 2) }}</td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        @else
                                            <p>No bazar items added.</p>
                                        @endif
                                    </td>
                                </tr>
                            </tbody>
                        </table>

                        <img src="{{ asset('img/' . $invoice->invoice_footer) }}" alt="Footer"
                            style="width:100%; height:auto; margin-top:10px;">
                    </div>
                </div>
            </div>
        </section>
    </div>

    @push('js')
        <script>
           
            document.getElementById('printButton').addEventListener('click', function () {
                window.print();
            });
        </script>
    @endpush
@endsection
