@extends('dashboard.master')
@section('title', 'Donar List')
@push('css')

<link rel="stylesheet" href="{{ asset('backend/DataTables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('backend/css/toggle.css') }}">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css" integrity="sha512-O03ntXoVqaGUTAeAmvQ2YSzkCvclZEcPQu1eqloPaHfJ5RuNGiS4l+3duaidD801P50J28EHyonCV06CUlTSag==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />

 @endpush

@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Donar List</b>
					</span>
				</div>

				<div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
					<a title="Create" href="#" type="button" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#addClass">
                        <i class="fas fa-plus mr-1"></i>
                        Create
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
					<table id="data_table" class="table table-bordered table-striped data-table table-hover">
                        <thead>
                            <tr>
                                <th>SN</th>
                                <th>Type</th>
                                <th>Name</th>
                                <th>Phone</th>
                                <th>Address</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
				</div>
			</div>
		</div>
	</section>
</div>

{{-- add modal --}}
<div class="modal fade" id="addClass" tabindex="-1" role="dialog" aria-labelledby="demoModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="demoModalLabel">{{ __('Create Donar')}}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <form class="forms-sample add-class" enctype="multipart/form-data" action="#" method="POST">
                    @csrf

                    <div class="form-group row">
                        <label for="name" class="col-sm-2 col-form-label">Type<span class="text-red">*</span></label>

                        <div class="col-sm-10">
                           <select name="donar_type_id" id="donar_type_id" class="form-control">
                                <option value="">Select Type</option>
                                @foreach($donarTypes as $donarType)
                                    <option value="{{$donarType->id }}">{{ $donarType->name }}</option>
                                @endforeach
                           </select>

                            @error('name')
                            <span class="text-danger" role="alert">
                                <p>{{ $message }}</p>
                            </span>
                            @enderror

                        </div>
                    </div>

                    <div class="form-group row">
                        <label for="name" class="col-sm-2 col-form-label">Name<span class="text-red">*</span></label>

                        <div class="col-sm-10">
                            <input type="text" name="name" id="name" value="{{ old('name') }}" class="form-control @error('name') is-invalid @enderror" placeholder="Enter name" required>

                            @error('name')
                            <span class="text-danger" role="alert">
                                <p>{{ $message }}</p>
                            </span>
                            @enderror

                        </div>
                    </div>

                    <div class="form-group row">
                        <label for="phone" class="col-sm-2 col-form-label">Phone<span class="text-red">*</span></label>
                        <div class="col-sm-10">
                            <input type="text" name="phone" id="phone" value="{{ old('phone') }}" class="form-control @error('phone') is-invalid @enderror" placeholder="Enter phone" required>

                            @error('phone')
                            <span class="text-danger" role="alert">
                                <p>{{ $message }}</p>
                            </span>
                            @enderror

                        </div>
                    </div>

                    <div class="form-group row">
                        <label for="name" class="col-sm-2 col-form-label">Address</label>

                        <div class="col-sm-10">
                            <textarea name="address" id="address" cols="2" rows="2" class="form-control" placeholder="Address"></textarea>
                        </div>
                    </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal">{{ __('Close')}}</button>
                <button type="button" id="save" class="btn btn-primary">{{ __('Create')}}</button>
            </div>
        </div>
    </div>
</div>

{{-- edit modal --}}
<div class="modal fade" id="editClass" tabindex="-1" role="dialog" aria-labelledby="demoModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="demoModalLabel">{{ __('Edit Donar')}}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <form id="edit-menu" action="#">
                    @csrf
                    @method('PUT')
                    <input type="hidden" id="editId">
                    <div class="form-group row">
                        <label for="name" class="col-sm-2 col-form-label">Type<span class="text-red">*</span></label>

                        <div class="col-sm-10">
                           <select name="donar_type_id" id="donar_type_idEdit" class="form-control">
                                <option value="">Select Type</option>
                                @foreach($donarTypes as $donarType)
                                    <option value="{{$donarType->id }}">{{ $donarType->name }}</option>
                                @endforeach
                           </select>

                            @error('name')
                            <span class="text-danger" role="alert">
                                <p>{{ $message }}</p>
                            </span>
                            @enderror

                        </div>
                    </div>

                    <div class="form-group row">
                        <label for="name" class="col-sm-2 col-form-label"> Name<span class="text-red">*</span></label>

                        <div class="col-sm-10">
                            <input type="text" name="name" id="nameEdit" value="{{ old('name') }}" class="form-control @error('name') is-invalid @enderror" placeholder="Enter name" required>

                            @error('name')
                            <span class="text-danger" role="alert">
                                <p>{{ $message }}</p>
                            </span>
                            @enderror

                        </div>
                    </div>

                    <div class="form-group row">
                        <label for="phone" class="col-sm-2 col-form-label">Phone<span class="text-red">*</span></label>
                        <div class="col-sm-10">
                            <input type="text" name="phone" id="phoneEdit" value="{{ old('phone') }}" class="form-control @error('phone') is-invalid @enderror" placeholder="Enter phone" required>

                            @error('phone')
                            <span class="text-danger" role="alert">
                                <p>{{ $message }}</p>
                            </span>
                            @enderror

                        </div>
                    </div>

                    <div class="form-group row">
                        <label for="name" class="col-sm-2 col-form-label">Address</label>

                        <div class="col-sm-10">
                            <textarea name="address" id="addressEdit" cols="2" rows="2" class="form-control" placeholder="Address"></textarea>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal">{{ __('Close')}}</button>
                <button type="button" id="update" class="btn btn-primary">{{ __('Update')}}</button>
            </div>
        </div>
    </div>
</div>
@push('js')
<script src="{{ asset('backend/DataTables/datatables.min.js') }}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js" integrity="sha512-Zq9o+E00xhhR/7vJ49mxFNJ0KQw1E1TMWkPTxrWcnpfEFDEXgUiwJHIKit93EW/XxE31HSI5GEOW06G6BF1AtA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script>
// add menu
$(document).ready(function($){
            $('#save').on('click',function (event) {
            event.preventDefault();

            var url = "{{ route('donar.store') }}";
            var name = $('#name').val();
            var phone = $('#phone').val();
            var address = $('#address').val();
            var donar_type_id = $('#donar_type_id').val();

            $.ajax({
                url: url,
                type: "get",
                data: {
                    name : name,
                    phone : phone,
                    address : address,
                    donar_type_id : donar_type_id,
                },
                success: function(data) {
                    if (data.success === true) {
                        location.reload();
                        toastr.success(data.message);
                        $('#add-class').trigger('clear');
                        $('#add-class')[0].reset();
                    }else{
                        toastr.error(data.message);
                        $('#add-class').trigger('clear');
                        $('#add-class')[0].reset();
                        $('#addClass').modal('show');
                    }
                },

            });
            $.noConflict();
            $('#addClass').modal('hide');
        });
    });

//edit menu
$('#data_table').on('click', '#edit[href]', function (e) {
    e.preventDefault();
    var url = $(this).attr('href');

    $.ajax({
        type: "GET",
        url: url,
        success: function(resp) {
            $('#nameEdit').val(resp.name);
            $('#phoneEdit').val(resp.phone);
            $('#addressEdit').val(resp.address);
            $('#donar_type_idEdit').val(resp.donar_type_id);
            $('#editId').val(resp.id);
        }
    });
});

$('#update').on('click',function (event) {
    event.preventDefault();
    var id = $('#editId').val();
    var name = $('#nameEdit').val();
    var phone = $('#phoneEdit').val();
    var address = $('#addressEdit').val();
    var donar_type_id = $('#donar_type_idEdit').val();

    var url = '{{ route("donar.update",":id") }}';

    $.ajax({
        url: url.replace(':id', id),
        'type':'GET',
        'data':{
            name : name,
            phone : phone,
            address : address,
            donar_type_id : donar_type_id,
        },
        success:function(data)
        {
            if (data.success === true) {
                toastr.success(data.message);
                $('#data_table').DataTable().ajax.reload();
                $('#editClass').modal('hide');
            }else{
                toastr.error(data.message);
                $('#editClass').modal('show');
            }
        }
    });

});

    $(document).ready( function () {
    var dTable = $('#data_table').DataTable({
        order: [],
        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        processing: true,
        responsive: false,
        serverSide: true,
        scrollX: true,
        autoWidth: false,
        scroller: {
            loadingIndicator: false
        },
        language: {
              processing: '<i class="ace-icon fa fa-spinner fa-spin orange bigger-500" style="font-size:60px;text-align:center;"></i>'
            },
        pagingType: "full_numbers",
        ajax: {
            url: "{{route('donar.list')}}",
            type: "get"
        },

        columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex', searchable: true, orderable: true},
            {data: 'type', name: 'type'},
            {data: 'name', name: 'name'},
            {data: 'phone', name: 'phone'},
            {data: 'address', name: 'address'},
            {data: 'action', searchable: false, orderable: false}
        ],
        dom: "<'row'<'col-sm-2'l><'col-sm-7 text-center'B><'col-sm-3'f>>tipr",
        buttons: [
            {
                extend: 'copy',
                className: 'btn-sm btn-info',
                title: 'Donar List',
                header: true,
                footer: true,
            },
              {
                extend: 'excel',
                className: 'btn-sm btn-success',
                title: 'Donor list',
                header: true,
                footer: true,
                exportOptions: {
                    columns: [0, 1,2,3,4],
                    stripHtml: true
                },
            },
            {
                extend: 'print',
                className: 'btn-sm btn-danger',
                title: 'Donar List',
                pageSize: 'A2',
                header: true,
                footer: true,
                orientation: 'landscape',
                exportOptions: {
                    columns: ':visible'
                }
            },
            {
                extend: 'colvis',
                className: 'btn-sm btn-warning',
                text: 'Column Visibility',
                title: 'Column Visibility',
                columns: ':not(:first-child)'
            }
        ],
        });
    });

    $('#data_table').on('click', '.btn-delete[data-remote]', function (e) {
            e.preventDefault();

            $.ajaxSetup({
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
                }
            });

            const url = $(this).data('remote');
            swal({
                    title: `Are you sure?`,
                    text: "Want to delete this record?",
                    buttons: true,
                    dangerMode: true,
                }).then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    url: url,
                    type: 'get',
                    dataType: 'json',
                    data: {submit: true, _method: 'delete', _token: "{{ csrf_token() }}"}
                }).always(function (data) {
                    $('#data_table').DataTable().ajax.reload();
                    if (data.success === true) {
                        toastr.success(data.message, { positionClass: 'toast-bottom-full-width', });
                    }else{
                        toastr.error(data.message, { positionClass: 'toast-bottom-full-width', });
                    }
                });
            }
            });
        });

    //  toastr.options.timeOut = 300;
    @if(Session::has('success'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
        "timeOut" : 1000
    };

    toastr.success("{{ session('success') }}");
  @endif

 @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
 @endif
</script>
@endpush
@endsection
