<!DOCTYPE html>
<html lang="bn">

<head>
    <meta charset="UTF-8">
    <title>অনুদান রশিদ</title>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Bengali&display=swap" rel="stylesheet">
    <?php
    
    $invoiceBgPath = 'back_height.jpg';
    
    if (isset($invoice->invoice_bg) && !empty($invoice->invoice_bg)) {
        $potentialBgFile = 'img/' . $invoice->invoice_bg;
        if (file_exists(public_path($potentialBgFile))) {
            $invoiceBgPath = $potentialBgFile;
        }
    }
    ?>
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: 'Noto Sans Bengali', sans-serif;
            background: #f9f7f1;
        }

        .receipt {
            width: 148mm;
            height: 105mm;
            margin: auto;
            padding: 8mm;
           background-image: url('{{ asset($invoiceBgPath) }}');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            border: 1px solid #d4af37;
            border-radius: 8px;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            page-break-after: always;
            font-size: 13px;
        }

        .org-header {
            text-align: center;
            margin-bottom: 4px;
        }

        .org-header h2 {
            margin: 0;
            font-size: 16px;
            color: #d4af37;
            /* গোল্ডেন রঙ */
        }

        .org-header p {
            margin: 0;
            font-size: 12px;
            color: #333;
        }

        .middle-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin: 12px 0 18px;
        }

        .middle-header .field {
            display: flex;
            align-items: center;
            font-size: 13px;
        }

        .middle-header .label {
            font-weight: bold;
            margin-right: 5px;
        }

        .middle-header .dashed {
            border-bottom: 1px dotted #333;
            display: inline-block;
            height: 14px;
            width: 50px;
        }

        .middle-header .logo {
            width: 70px;
            height: 70px;
            border-radius: 50%;
            overflow: hidden;
        }

        .middle-header .logo img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .middle-header .center-box {
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        .center-label {
            background: #d4af37;
            /* গোল্ডেন ব্যাকগ্রাউন্ড */
            color: #000;
            /* কালো লেখা */
            padding: 2px 10px;
            font-size: 12px;
            font-weight: bold;
            border-radius: 4px;
            text-align: center;
            margin-top: 5px;
        }

        .fields {
            font-size: 13px;
        }

        .field {
            display: flex;
            align-items: center;
            margin-bottom: 15px;
        }

        .label {
            display: inline-block;
            font-weight: bold;
            margin-right: 5px;
            min-width: 100px;
        }

        .mobile-label {
            margin-right: 3px !important;
        }

        .dashed {
            display: inline-block;
            border-bottom: 1px dotted #333;
            flex: 1;
            height: 16px;
        }

        .double-inline {
            display: flex;
            justify-content: space-between;
            gap: 20px;
        }

        .group-60,
        .group-40 {
            display: flex;
            align-items: center;
        }

        .group-60 {
            width: 60%;
        }

        .group-40 {
            width: 40%;
        }

        .footer-note {
            text-align: center;
            font-size: 12px;
            margin-top: 4px;
            color: #444;
        }

        .signatures {
            display: flex;
            justify-content: space-between;
            font-size: 12px;
            margin-top: 10px;
        }

        .signatures div {
            border-top: 1px solid #999;
            width: 45%;
            text-align: center;
            padding-top: 3px;
        }

        @media print {
            @page {
                size: A6 landsacpe;
                margin: 0;
            }

            .receipt {
                box-shadow: none;
                border: none;
            }
        }
    </style>
</head>

<body>

    <div class="receipt">
        <!-- Header -->
        <div class="org-header">
            <h2>{{ $setting->long_name ?? '' }}</h2>
            <p>{{ $setting->address ?? '' }}</p>
        </div>

        <!-- Mid row: ক্রমিক + লোগো + তারিখ -->
        <div class="middle-header">
            <div class="field">
                <span class="label">ক্রমিক নং:</span>
                <span class="dashed">{{ $data->receipt_no ?? '' }}</span>
            </div>

            <div class="center-box">
                <div class="logo">
                    <img src="{{ asset('img/' . $setting->logo) }}" alt="Logo">
                </div>
                <div class="center-label">অনুদান গ্রহণের রশিদ</div>
            </div>

            <div class="field">
                <span class="label">তারিখ:</span>
                <span class="dashed"
                    style="padding-right:15px !important;">{{ \Carbon\carbon::parse($setting->date)->format('d/m/Y') ?? '' }}</span>
            </div>
        </div>

        <!-- Fields -->
        <div class="fields">
            <div class="field">
                <span class="label">নাম:</span>
                <span class="dashed">{{ $data->name ?? '' }}</span>
            </div>

            <div class="field double-inline">
                <div class="group-60">
                    <span class="label">ঠিকানা:</span>
                    <span class="dashed">{{ $data->address ?? '' }}</span>
                </div>
                <div class="group-40">
                    <span class="label mobile-label">মোবাঃ</span>
                    <span class="dashed" style="width: 50px;">{{ $data->phone ?? '' }}</span>
                </div>
            </div>

            <div class="field">
                <span class="label">বাবদ:</span>
                <span class="dashed">{{ $data->purpose ?? '' }}</span>
            </div>

            <div class="field">
                <span class="label">টাকার পরিমাণ:</span>
                <span class="dashed">{{ $data->amount ?? '' }}</span>
            </div>

            <div class="field">
                <span class="label">কথায়:</span>
                <span class="dashed">{{ $amountInWords ?? '' }} টাকা মাত্র</span>
            </div>
        </div>

        <!-- Footer -->
        <div class="footer-note">
            ধন্যবাদের সহিত আপনার দানকে গ্রহণ করা হলো।<br>
            আল্লাহ পাক এ দানকে কবুল করুন (আমিন)
        </div>

        <div class="signatures">
            <div>প্রিন্সিপাল</div>
            <div>আনুদানদাতার স্বাক্ষর</div>
        </div>
    </div>
    <script type="text/javascript">
        localStorage.clear();

        function auto_print() {
            window.print();
        }
        setTimeout(auto_print, 1000);
    </script>
</body>

</html>
