@extends('dashboard.master')
@section('title', 'Exam Seat Create')
@push('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
@endpush
@section('content')

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span>
                        <b>Exam Seat Create</b>
                    </span>
                </div>

                <div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <form class="forms-sample add-class" enctype="multipart/form-data" action="{{ route('exam.seat.store') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Exam<span class="text-red">*</span></label>
                                    <select name="exam_id" id="exam_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach ($exams as $exam)
                                        <option value="{{ $exam->id }}">{{ $exam->name }}</option>
                                        @endforeach
                                    </select>

                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Session<span class="text-red">*</span></label>
                                    <select name="session_id" id="session_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach ($stusessions as $stdession)
                                        <option value="{{ $stdession->id }}">{{ $stdession->name }}</option>
                                        @endforeach
                                    </select>

                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Class<span class="text-red">*</span></label>
                                    <select name="class_id" id="class_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach ($classes as $class)
                                        <option value="{{ $class->id }}">{{ $class->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                        </div>
                         <button type="button" id="apply_all" class="btn btn-secondary">
      Apply to All
    </button>
                        <hr>
                        <div class="table-responsive hideClass">
                            <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Student</th>
                                        <th>Seat No</th>
                                    </tr>
                                </thead>
                                <tbody id="student_data">

                                </tbody>
                            </table>

                        </div>


						<div class="row mt-20 hideClass">
							<div class="col-sm-12">
								<button title="Save" type="submit" class="btn btn-primary mr-2">Save</button>
							</div>
						</div>

                    </div>
                </form>
            </div>
        </div>
    </section>
</div>

@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script>
    $(document).ready(function() {
        $('.hideClass').hide();

        function loadStudents() {
            var session_id = $('#session_id').val();
            var class_id = $('#class_id').val();
            var exam_id = $('#exam_id').val();
            var _token = $('meta[name="csrf-token"]').attr('content');

            if (class_id && session_id && exam_id) {
                $.ajax({
                    url: "{{ route('session.wise.student') }}",
                    type: "POST",
                    data: {
                        session_id: session_id,
                        class_id: class_id,
                        exam_id: exam_id,
                        _token: _token,
                    },
                    success: function(response) {
                        console.log("response from create", response);
                    $('#student_data').empty();
                    if (response.length > 0) {
                        $('.hideClass').show();
                    }

                    response.forEach(function(student, index) {
                    let seatNo = student.exam_seat?.seat_no ?? '';
                    let isReadonly = seatNo !== '' ? 'readonly' : '';

                    let row = $('<tr></tr>');
                    row.append('<td>' + (index + 1) + '</td>');
                    row.append('<td>' + student.name + ' || ' + student.roll_no + ' || ' + student.register_no + '</td>');
                    row.append(
                        '<td>' +
                            '<input class="form-control" type="text" name="seat_no['+ student.id +']" value="' + seatNo + '" ' + isReadonly + ' />' +
                            '<input type="hidden" name="student_id[]" value="' + student.id + '" />' +
                        '</td>'
                    );
                    $('#student_data').append(row);
                });

                },

                    error: function(xhr, status, error) {
                        console.error(error);
                        alert("An error occurred while loading students.");
                    }
                });
            }
        }

        $('#class_id, #session_id, #exam_id').on('change', function() {
            loadStudents();
        });
    });

    @if(Session::has('success'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
        "timeOut" : 1000
    };
    toastr.success("{{ session('success') }}");
@endif

 @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
 @endif


 // Auto fill seat numbers 1..N in current table order
$(document).on('click', '#apply_all', function () {
    const $rows = $('#student_data tr');
    if ($rows.length === 0) {
        toastr.warning('No students loaded to assign seats.');
        return;
    }

    let counter = 1;
    $rows.each(function () {
        const $input = $(this).find('input[name="seat_no[]"]');
        if ($input.length) {
            // If the seat input is NOT readonly, assign automatically
            if (!$input.prop('readonly')) {
                $input.val(counter);
            }
            // We still increment counter to keep the sequence aligned with row order
            counter++;
        }
    });

    toastr.success('Seat numbers applied.');
});

    </script>

@endpush
@endsection
