@extends('dashboard.master')
@section('title', 'Exam Seat Edit')
@section('content')

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span>
                        <b>Exam Seat Edit</b>
                    </span>
                </div>

                <div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <form class="forms-sample add-class" enctype="multipart/form-data" action="{{ route('exam.seat.update', [$data->exam_id, $data->session_id, $data->class_id]) }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Exam<span class="text-red">*</span></label>
                                    <select name="exam_id" id="exam_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach ($exams as $exam)
                                        <option value="{{ $exam->id }}" @if($data->exam_id == $exam->id) selected @endif>{{ $exam->name }}</option>
                                        @endforeach
                                    </select>

                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Session<span class="text-red">*</span></label>
                                    <select name="session_id" id="session_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach ($stusessions as $stdession)
                                        <option value="{{ $stdession->id }}" @if($data->session_id == $stdession->id) selected @endif>{{ $stdession->name }}</option>
                                        @endforeach
                                    </select>

                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Class<span class="text-red">*</span></label>
                                    <select name="class_id" id="class_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach ($classes as $class)
                                        <option value="{{ $class->id }}" @if($data->class_id == $class->id) selected @endif>{{ $class->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                        </div>
                        <hr>
                        <div class="table-responsive">
                            <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Student</th>
                                        <th>Seat No</th>
                                    </tr>
                                </thead>
                                <tbody id="student_data">
                                    @foreach($students as $item)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $item->students->name ??'' }} || {{ $item->students->roll_no ??'' }} || {{ $item->students->register_no ??'' }}</td>
                                        <td>
                                            <input type="hidden" name="student_id[]" value="{{ $item->students->id ?? '' }}">
                                            <input type="text" name="seat_no[]" class="form-control" value="{{ $item->seat_no ?? '' }}">
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>

                        </div>


						<div class="row mt-20">
							<div class="col-sm-12">
								<button title="Update" type="submit" class="btn btn-primary mr-2">Update</button>
							</div>
						</div>

                    </div>
                </form>
            </div>
        </div>
    </section>
</div>

@push('js')
<script>
$(document).ready(function() {
    $('#class_id, #session_id, #exam_id').on('change', function(event) {
        event.preventDefault();

        var session_id = $('#session_id').val();
        var class_id = $('#class_id').val();
        var exam_id = $('#exam_id').val();
        var _token = $('meta[name="csrf-token"]').attr('content');
        var url = "{{ route('session.wise.student') }}";

        if (class_id && session_id && exam_id) {
            $.ajax({
                url: url,
                type: "POST",
                data: {
                    session_id: session_id,
                    class_id: class_id,
                    exam_id: exam_id,
                    _token: _token,
                },
                success: function(response) {
                    $('#student_data').empty();
                    response.forEach(function(student, index) {
                        var seatNo = student.exam_seat ? student.exam_seat.seat_no : '';

                        var row = $('<tr></tr>');
                        row.append('<td>' + (index + 1) + '</td>');
                        row.append('<td>' + student.name + ' || ' + student.roll_no + ' || ' + student.register_no + '</td>');
                        row.append(
                            '<td>' +
                            '<input class="form-control" type="text" name="seat_no[]" value="' + seatNo + '" />' +
                            '<input type="hidden" name="student_id[]" value="' + student.id + '" />' +
                            '</td>'
                        );
                        $('#student_data').append(row);
                    });
                },
                error: function(xhr, status, error) {
                    alert("Error loading student seats.");
                }
            });
        }
    });
});


</script>
@endpush
@endsection
