@extends('dashboard.master')
@section('title', 'Exam Seat Details')
@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Exam Seat Details</b>
					</span>
				</div>

				<div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
					<a title="Create" href="{{ route('exam.seat.create') }}" type="button" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus mr-1"></i>
                        Create
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
					<table id="data_table" class="table table-bordered table-striped data-table table-hover" style="width: 40%">
                        <thead>
                            <tr>
                                <th width="30%">Date</th>
                                <td width="70%">{{ \Carbon\Carbon::parse($data->date)->format('d-M-Y') ?? '' }}</td>
                            </tr>
                            <tr>
                                <th width="30%">Exam</th>
                                <td width="70%">{{ $data->exam->name ?? '' }}</td>
                            </tr>
                            <tr>
                                <th width="30%">Session</th>
                                <td width="70%">{{ $data->stusession->name ?? '' }}</td>
                            </tr>
                            <tr>
                                <th width="30%">Class</th>
                                <td width="70%">{{ $data->stuclass->name ?? '' }}</td>
                            </tr>
                        </thead>
                    </table>

                    <hr>
					<table id="data_table" class="table table-bordered table-striped data-table table-hover">
                        <thead>
                            <tr>
                                <th>SN</th>
                                <th>Student</th>
                                <th>Roll</th>
                                <th>Reg</th>
                                <th>Seat No</th>
                            </tr>
                        </thead>
                        <tbody>

                            @foreach($students as $item)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $item->students->name ??'' }}</td>
                                <td>{{ $item->students->roll_no ??'' }}</td>
                                <td>{{ $item->students->register_no ??'' }}</td>
                                <td>{{ $item->seat_no ?? '' }}</td>
                            </tr>
                            @endforeach

                        </tbody>
                    </table>
				</div>
			</div>
		</div>
	</section>
</div>

@endsection
