@extends('dashboard.master')
@section('title', 'Edit Expense')
@push('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/css/dropify.min.css" integrity="sha512-EZSUkJWTjzDlspOoPSpUFR0o0Xy7jdzW//6qhUkoZ9c4StFkVsp9fbbd0O06p9ELS3H486m4wmrCELjza4JEog==" crossorigin="anonymous" referrerpolicy="no-referrer" />

<style>
    .dropify-wrapper .dropify-message p {
        font-size: initial;
    }
    .bangla{
            font-weight: 0;
            font-size:15px;
        }
</style>

@endpush

@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Edit Expense</b>
					</span>
				</div>

				<div class="page-title-actions">
					<a title="Back" href="{{ URL::previous() }}" type="button" class="btn btn-sm btn-dark">
						<i class="fas fa-arrow-left mr-1"></i>
						Back
					</a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
					<form enctype="multipart/form-data" action="{{ route('expense.update', $data->id) }}" method="POST">
						@csrf
                        @method('PUT')
						<div class="row">
							<div class="col-sm-4">
								<div class="form-group">
									<label for="date">Date<span class="text-red">*</span></label>
									<input type="text" name="date" id="date" value="{{ $data->date }}" class="form-control" placeholder="Enter date" required>

									@error('date')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

                            <div class="col-sm-4">
								<div class="form-group">
									<label for="name"><span class="bangla">ব্যয়কারির নাম </span>/Expebnse By<span class="text-red">*</span></label>
									<input type="text" name="expenseby" id="expenseby" value="{{ $data->expenseby }}" class="form-control @error('expenseby') is-invalid @enderror" placeholder="নাম লিখুন" required>

									@error('expenseby')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="amount"><span class="bangla">পরিমাণ</span>/Amount <span class="text-red">*</span></label>
									<input type="text" name="amount" id="amount" value="{{ $data->amount }}" class="form-control @error('amount') is-invalid @enderror" placeholder="পরিমাণ লিখুন" required>

									@error('amount')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

                            <div class="col-sm-6">
								<div class="form-group">
									<label for="purpose"><span class="bangla">ব্যয়ের কারণ </span>/Expense Reason<span class="text-red">*</span></label>
									<textarea rows="3" name="purpose" id="purpose" class="form-control" placeholder="বাবদ লিখুন" required>{!! $data->purpose !!}</textarea>

									@error('purpose')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="image"><span class="bangla">মেমোর ছবি</span>/Image</label>
                                    <input data-height="auto" type="file" class="dropify form-control @error('image') is-invalid @enderror" name="image" id="image" placeholder="Image" data-default-file="{{ asset('backend/img/expense/'.$data->image) }}">

                                <input type="hidden" name="current_image" value="{{ $data->image }}" />
                                </div>
                            </div>

							<div class="col-sm-12">
								<div class="form-group">
									<label for="note"><span class="bangla">বিঃদ্রঃ</span>/Note</label>
									<textarea rows="2" name="note" id="note" class="form-control" placeholder="বিঃদ্রঃ লিখুন">{!! $data->note !!}</textarea>

								</div>
							</div>

						</div>

						<div class="row mt-30">
							<div class="col-sm-12">
								<button title="Update" type="submit" class="btn btn-primary mr-2">Update</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</section>
</div>

@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/js/dropify.min.js"
        integrity="sha512-8QFTrG0oeOiyWo/VM9Y8kgxdlCryqhIxVeRpWSezdRRAvarxVtwLnGroJgnVW9/XBRduxO/z1GblzPrMQoeuew==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
    <script>
    $(document).ready(function() {
        $('.dropify').dropify();
    });

    $(function () {
           $('#date').datepicker({
               dateFormat: 'dd MM yy'
           });
       });
    </script>

@endpush
@endsection


