@extends('dashboard.master')
@section('title', 'Expense Details')
@section('content')
@push('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet"/>
@endpush

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Expense Details</b>
					</span>
				</div>

				<div class="page-title-actions">

                    <a title="Back" href="{{ URL::previous() }}" type="button" class="btn btn-sm btn-dark">
						<i class="fas fa-arrow-left mr-1"></i>
						Back
					</a>

					<a title="Create" target="_blank" href="{{ route('expense.create') }}" type="button" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus mr-1"></i>
                        Create
                    </a>

				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
                    <div class="row">
                        <div class="col-sm-12">
                        <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                            <tbody>

                                <tr>
                                    <td width="50%">তারিখ/Date</td>
                                    <td>{{ $date ?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td>ব্যয়কারির নাম/Expense By</td>
                                    <td>{{ $data->expenseby ?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td>পরিমাণ/Amount</td>
                                    <td>{{ $data->amount ?? '--' }} টাকা </td>
                                </tr>

                                <tr>
                                    <td>ব্যয়ের কারণ/Expense Reason</td>
                                    <td>{{ $data->purpose ?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td>মেমোর ছবি/Image</td>
                                    <td><img height="50px" width="100px" src="{{ asset('backend/img/expense/'.$data->image)}}" alt="Photo">
                                    </td>
                                </tr>

                                <tr>
                                    <td>বিঃদ্রঃ/Note</td>
                                    <td>{{ $data->note ?? '--' }}</td>
                                </tr>

                            </tbody>
                        </table>
                        </div>

                    </div>
				</div>
			</div>
		</div>
	</section>
</div>

@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script>
    //  toastr.options.timeOut = 300;
    @if(Session::has('success'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
        "timeOut" : 2000
    };

    toastr.success("{{ session('success') }}");
  @endif

 @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
 @endif
</script>
@endpush
@endsection
