@extends('dashboard.master')
@section('title', 'Fees Assign Details')
@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Fees Assign Details</b>
					</span>
				</div>

				<div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
					<a title="Create" href="{{ route('academic.fees.assign.create') }}" type="button" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus mr-1"></i>
                        Create
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
        <div class="container-fluid">

            <div class="card">
                <div class="card-body">
                    <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                        <thead>
                            <tr>
                                <th width="30%">Class Name</th>
                                <td width="70%">
                                    {{ $data->first()->class->name ?? '--' }}
                                </td>
                            </tr>
                            <tr>
                                <th width="30%">Session</th>
                                <td width="70%">
                                    {{ $data->first()->studentsession->name ?? '--' }}
                                </td>
                            </tr>
                        </thead>
                    </table>

                </div>
            </div>

            <div class="card">
                <div class="card-body">
                    <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                        <thead>
                            <tr>
                                <th>SN</th>
                                <th>Month</th>
                                <th class="text-center">Name</th>
                                <th class="text-center">Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php $sn = 1; @endphp
                            @foreach($details as $month => $items)
                                <tr>
                                    <td>{{ $sn++ }}</td>
                                    <td>{{ \Carbon\Carbon::parse($month)->format('F, Y') }}</td>
                                    <td colspan="2">
                                        <table class="table">
                                            <tbody>
                                                @foreach($items as $fee)
                                                    <tr>
                                                        <td class="text-left" style="width: 24.40%;">{{ $fee->fees->name ?? '' }}</td>
                                                        <td class="text-center" style="width: 30%;">{{ $fee->amount }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </section>

</div>
@endsection




