@extends('dashboard.master')
@section('title', 'Create Hostel Fee Assign')

@push('css')
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />

    <style>
        .ui-datepicker-calendar {
            display: none;
        }

        #student_id {
            text-align: center;
        }
    </style>
@endpush

@section('content')

    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span><b>Create Hostel Fee Assign</b></span>
                    </div>

                    <div class="page-title-actions">
                        <a title="Back Button" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i> Back
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body">
                        <form enctype="multipart/form-data" action="{{ route('hostel.fees.assign.store') }}" method="POST">
                            @csrf
                            <div class="row">
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="session_id">Session <span class="text-red">*</span></label>
                                        <select name="session_id" id="session_id"
                                            class="form-control @error('session_id') is-invalid @enderror" required>
                                            <option value="">Select One</option>
                                            @foreach ($sessions as $session)
                                                <option value="{{ $session->id }}">{{ $session->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('session_id')
                                            <span class="text-danger">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="class_id">Class <span class="text-red">*</span></label>
                                        <select name="class_id" id="class_id"
                                            class="form-control @error('class_id') is-invalid @enderror" required>
                                            <option value="">Select One</option>
                                            @foreach ($class as $item)
                                                <option value="{{ $item->id }}">{{ $item->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('class_id')
                                            <span class="text-danger">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror
                                    </div>
                                </div>



                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="months">Select Months <span class="text-red">*</span></label>
                                        <select name="months[]" id="months" class="form-control select2" multiple
                                            required></select>

                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="fee_type">Select Fee Type<span class="text-red">*</span></label>
                                        <select name="fee_type" id="fee_type" class="form-control">
                                            <option value="">Select Fees Type</option>
                                            <option value="1">একাডেমিক ফি - (নির্ধারিত ক্লাসের সকল শিক্ষার্থীদের জন্য)</option>
                                            <option value="2">আবাসিক ফি - (নির্ধারিত ক্লাসের সকল আবাসিক শিক্ষার্থীদের জন্য)</option>
                                            <option value="3">পরীক্ষা ফি - (নির্ধারিত ক্লাসের সকল শিক্ষার্থীদের জন্য)</option>
                                            <option value="4">অনাবাসিক ফি - (নির্ধারিত ক্লাসের সকল অনাবাসিক শিক্ষার্থীদের জন্য)</option>
                                        </select>
                                    </div>
                                </div>

                               

                            </div>

                            <div class="row">
                                <div class="col-md-12">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th>Title</th>
                                       
                                            <th>Amount</th>
                                            <th>Action</th>
                                        </tr>
                                        <tbody id="fees-tbody">
                                            <!-- Fees will be injected here -->
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <div class="row mt-30">
                                <div class="col-sm-12">
                                    <button type="submit" class="btn btn-success mr-2">Save</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>

    @push('js')
        <script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>

        <script>
            $(document).ready(function() {
                // Month Picker (User can select any month)
                $('#month').datepicker({
                    changeMonth: true,
                    changeYear: true,
                    showButtonPanel: true,
                    dateFormat: 'MM-yy',
                    beforeShow: function(input, inst) {
                        $(input).datepicker('setDate', new Date(inst.selectedYear, inst
                            .selectedMonth, 1));
                    },
                    onClose: function(dateText, inst) {
                        var month = $.datepicker.formatDate('MM', new Date(inst.selectedYear,
                            inst.selectedMonth, 1));
                        var year = inst.selectedYear;
                        $(this).val($.datepicker.formatDate('MM-yy', new Date(year, inst
                            .selectedMonth, 1)));
                    }
                });

                $('#months').select2({
                    placeholder: 'Search and select months',
                    ajax: {
                        url: '{{ route('months.search') }}',
                        dataType: 'json',
                        delay: 250,
                        data: function(params) {
                            return {
                                q: params.term // user input
                            };
                        },
                        processResults: function(data) {
                            return {
                                results: data
                            };
                        },
                        cache: true
                    },
                    width: '100%'
                });
                $(function() {
                    $('#from_month').datepicker({
                        changeMonth: true,
                        changeYear: true,
                        showButtonPanel: true,
                        dateFormat: 'MM-yy',
                        beforeShow: function(input, inst) {
                            $(input).datepicker('setDate', new Date(inst.selectedYear, inst
                                .selectedMonth, 1));
                        },
                        onClose: function(dateText, inst) {
                            var month = $.datepicker.formatDate('MM', new Date(inst.selectedYear,
                                inst.selectedMonth, 1));
                            var year = inst.selectedYear;
                            $(this).val($.datepicker.formatDate('MM-yy', new Date(year, inst
                                .selectedMonth, 1)));
                        }
                    });
                });
                // Checkbox selection logic
                document.querySelectorAll('.fee-checkbox').forEach(checkbox => {
                    checkbox.addEventListener('change', function() {
                        const feeName = this.dataset.feeName;
                        const selectedItemCell = this.closest('tr').querySelector('.selected-item');
                        const unselectButton = this.closest('tr').querySelector('.unselect-button');

                        if (this.checked) {
                            selectedItemCell.textContent = feeName;
                            unselectButton.style.display = 'inline';
                        } else {
                            selectedItemCell.textContent = '';
                            unselectButton.style.display = 'none';
                        }
                    });
                });

                // Unselect button logic
                document.querySelectorAll('.unselect-button').forEach(button => {
                    button.addEventListener('click', function() {
                        const checkbox = this.closest('tr').querySelector('.fee-checkbox');
                        checkbox.checked = false;
                        checkbox.dispatchEvent(new Event('change'));
                    });
                });
            });

            @if (Session::has('success'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true,
                    "timeOut": 2000
                };

                toastr.success("{{ session('success') }}");
            @endif

            @if (Session::has('error'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true
                };
                toastr.error("{{ session('error') }}");
            @endif

            //change of select items 
            $(document).on("change", '#fee_type, #class_id, #session_id, #months', function() {

                var fee_type = $('#fee_type').val();

                console.log('changed', fee_type);

                loadFees();
            })

            function loadFees() {
                var fee_type = $('#fee_type').val();
                var class_id = $('#class_id').val();
                var session_id = $('#session_id').val();
                var month = $('#months').val();
                console.log(fee_type, class_id, session_id, month);

                if (!fee_type) {
                    // alert("Please select a fee type");
                    return;
                }

                var url = "{{ route('load.fees.by.feetype') }}";
                url = url.replace(':fee_type', fee_type);

                console.log(fee_type, url);

                $.ajax({
                    type: "POST",
                    url: url,
                    data: {
                        _token: '{{ csrf_token() }}',
                        fee_type: fee_type,
                        class_id: class_id,
                        session_id: session_id,
                        month: month
                    },
                    success: function(resp) {
                        let tbody = '';

                        resp.forEach(function(fee) {
                            tbody += `
                                    <tr>
                                        <td>
                                            <input name="fee_id[]" value="${fee.id}"
                                                class="fee-checkbox" data-fee-name="${fee.name}"
                                                title="select" type="checkbox"
                                                style="margin-right: 10px; height: 20px; width: 20px;">
                                            ${fee.name}
                                        </td>
                                        <td>
                                            <input type="text" name="amount[${fee.id}]" class="form-control"
                                                placeholder="Amount" value="${fee.amount || ''}">
                                        </td>
                                  
                                        <td>
                                            <button type="button" class="unselect-button"
                                                style="display: none; border: none; background: none; cursor: pointer;">
                                                <i title="remove" class="fas fa-times" style="color: red;"></i>
                                            </button>
                                        </td>
                                    </tr>
                                `;
                        });

                        $('#fees-tbody').html(tbody);
                        console.log(resp);
                    },
                    error: function(xhr, status, error) {
                        console.error("Error loading fees:", error);
                    }
                });
            }


             function checkFeeAvailable(month, feeId) {
            const fee_type = $('#fee_type').val();
            const class_id = $('#class_id').val();
            const session_id = $('#session_id').val();
            // const month = month;
            const url = "{{ route('hostel.fees.assign.check.fees.availability') }}";
            $.ajax({
                type: "POST",
                url: url,
                data: {
                    _token: '{{ csrf_token() }}',
                    fee_type: fee_type,
                    class_id: class_id,
                    session_id: session_id,
                    month: month,
                    fee_id: feeId
                },
                success: function(resp) {
                    console.log(resp);
                    if (resp.status == "error") {
                        alert(resp.message);
                         checkbox.prop('checked', false);
                    } else {
                        console.log(resp.status);
                    }
                }
            });
        }


        $(document).on('change', '.fee-checkbox', function() {
            const checkbox = $(this);

            // const feeName = $(this).data('fee-name');
            const feeId = $(this).val();
            const month = $(this).data('fee-month');
            if (checkbox.is(':checked')) {
                console.log('Checkbox is checked', month, feeId);
                checkFeeAvailable(month, feeId, checkbox);
            } else {
                console.log('Checkbox is unchecked', month, feeId);
            }



        })
        </script>
    @endpush
@endsection
