@extends('dashboard.master')

@section('title', 'Edit Hostel Fee Assign')

@push('css')
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
@endpush

@section('content')
 
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-edit"></i>
                        </div>
                        <span><b>Edit Hostel Fee Assign</b></span>
                    </div>

                    <div class="page-title-actions">
                        <a title="Back Button" href="{{ url()->previous() }}" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i> Back
                        </a>
                    </div>
                </div>
            </div>
        </div>
      
        <section class="content">
            <div class="container-fluid">
                <div class="card">
               @if (session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
    </div>
@endif

@if (session('error'))
    <div class="alert alert-danger">
        {{ session('error') }}
    </div>
@endif
                    <div class="card-body">
                        <form
                            action="{{ route('hostel.fees.assign.update', ['class_id' => $data->class_id, 'session_id' => $data->session_id, $data->type, $data->id]) }}"
                            method="POST">
                            {{-- @method('PUT') --}}
                            @csrf
                            <div class="row">
                                <!-- Static info (class, session) -->
                                <input type="hidden" name="fee_assign_id" value="{{ $data->id }}">
                                <div class="col-md-4">
                                    <label>Session</label>
                                    <input type="text" name="session"
                                        value="{{ $data->first()?->studentsession?->name }}" class="form-control" readonly>
                                    <input type="hidden" name="session_id" id="session_id" value="{{ $data->session_id }}">
                                </div>
                                <div class="col-md-4">
                                    <label>Class</label>
                                    <input type="text" name="class" value="{{ $data->class?->name }}"
                                        class="form-control" readonly>
                                    <input type="hidden" name="class_id" id="class_id" value="{{ $data->class_id }}">
                                </div>

                                @php

                                @endphp
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="months">Select Months <span class="text-red">*</span></label>
                                        <select name="months[]" id="months" class="form-control select2" multiple
                                            required>
                                            @foreach ($details as $month => $items)
                                                <option value="{{ $month }}" selected>
                                                    {{ \Carbon\Carbon::parse($month . '-01')->format('F Y') }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <input type="hidden" name="added_months" id="added_months">
                                <input type="hidden" name="removed_months" id="removed_months">



                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="fee_type">Select Fee Type<span class="text-red">*</span></label>
                                        <select name="fee_type" id="fee_type" class="form-control" disabled>
                                            <option value="">Select Fees Type</option>
                                            <option value="1" {{ $type == 1 ? 'selected' : '' }}>Academic Fee</option>
                                            <option value="2" {{ $type == 2 ? 'selected' : '' }}>Hostel Fee</option>
                                            <option value="3" {{ $type == 3 ? 'selected' : '' }}>Others</option>
                                            <option value="4" {{ $type == 4 ? 'selected' : '' }}>Onabashik Fee
                                            </option>
                                        </select>
                                        <input type="hidden" name="fee_type" value="{{ $type }}">
                                    </div>
                                </div>
                            </div>


                            <div class="row">
                                <div class="col-md-12">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th>Title</th>

                                            <th>Amount</th>

                                        </tr>
                                        <tbody id="fees-tbody">
                                            {{-- @dd($selectedFees) --}}
                                            @php
                                                $groupedFees = $selectedFees->groupBy('month');
                                            @endphp
                                            @foreach ($groupedFees as $month => $fees)
                                                {{-- Month header --}}
                                                <input type="hidden" name="month[]" value="{{ $month }}">
                                                <tr class="fee-row" data-month="{{ $month }}">
                                                    <td colspan="3">
                                                        <strong>{{ \Carbon\Carbon::parse($month . '-01')->format('F Y') }}</strong>
                                                    </td>
                                                </tr>

                                                {{-- Fees for this month --}}
                                                @foreach ($fees as $fee)
                                                    <tr class="fee-row" data-month="{{ $month }}">
                                                        <td>{{ $fee->name }}</td>
                                                        <input type="hidden" name="fee_id[]" value="{{ $fee->id }}">
                                                        <td>
                                                            <input type="number" name="amount[{{ $fee->detail_id }}]"
                                                                class="form-control" value="{{ $fee->amount }}">
                                                        </td>
                                                        <input type="hidden" name="details_id[]"
                                                            value="{{ $fee->detail_id }}">
                                                    </tr>
                                                @endforeach
                                            @endforeach


                                        </tbody>
                                    </table>
                                </div>
                            </div>



                            <div class="row mt-4">
                                <div class="col-sm-12">
                                    <button type="submit" class="btn btn-success">Update</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </section>
    </div>
@endsection

@push('js')
    <script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
    <script>
        @if (Session::has('success'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true,
                "timeOut": 2000
            };
            toastr.success("{{ session('success') }}");
        @endif

        @if (Session::has('error'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            };
            toastr.error("{{ session('error') }}");
        @endif
    </script>
    <script>
        $(document).ready(function() {
            $('#month').datepicker({
                changeMonth: true,
                changeYear: true,
                showButtonPanel: true,
                dateFormat: 'MM-yy',
                beforeShow: function(input, inst) {
                    $(input).datepicker('setDate', new Date(inst.selectedYear, inst
                        .selectedMonth, 1));
                },
                onClose: function(dateText, inst) {
                    var month = $.datepicker.formatDate('MM', new Date(inst.selectedYear,
                        inst.selectedMonth, 1));
                    var year = inst.selectedYear;
                    $(this).val($.datepicker.formatDate('MM-yy', new Date(year, inst
                        .selectedMonth, 1)));
                }
            });

            $('#months').select2({
                placeholder: 'Search and select months',
                ajax: {
                    url: '{{ route('months.search') }}',
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            q: params.term // user input
                        };
                    },
                    processResults: function(data) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                },
                width: '100%'
            });




            $(function() {
                $('#from_month').datepicker({
                    changeMonth: true,
                    changeYear: true,
                    showButtonPanel: true,
                    dateFormat: 'MM-yy',
                    beforeShow: function(input, inst) {
                        $(input).datepicker('setDate', new Date(inst.selectedYear, inst
                            .selectedMonth, 1));
                    },
                    onClose: function(dateText, inst) {
                        var month = $.datepicker.formatDate('MM', new Date(inst.selectedYear,
                            inst.selectedMonth, 1));
                        var year = inst.selectedYear;
                        $(this).val($.datepicker.formatDate('MM-yy', new Date(year, inst
                            .selectedMonth, 1)));
                    }
                });
            });

            let addedMonths = [];
            let removedMonths = [];


            $('#months').on('select2:select', function(e) {
                const selectedValue = e.params.data.id;
                loadFeesForMonth(selectedValue);
                removedMonths = removedMonths.filter(m => m !== selectedValue);

                // Avoid duplicates in addedMonths
                if (!addedMonths.includes(selectedValue)) {
                    addedMonths.push(selectedValue);
                }

                updateHiddenInputs();
            });

            // Track removed months
            $('#months').on('select2:unselect', function(e) {
                const removedValue = e.params.data.id;

                $(`.fee-row[data-month="${removedValue}"]`).remove();

                console.log('Removed month rows for:', removedValue);
                // Remove from addedMonths if it was there
                addedMonths = addedMonths.filter(m => m !== removedValue);

                // Avoid duplicates in removedMonths
                if (!removedMonths.includes(removedValue)) {
                    removedMonths.push(removedValue);
                }

                updateHiddenInputs();
            });

            // Update both hidden fields
            function updateHiddenInputs() {
                $('#added_months').val(JSON.stringify(addedMonths));
                $('#removed_months').val(JSON.stringify(removedMonths));

                // Optional: debug
                console.log('Added:', addedMonths);
                console.log('Removed:', removedMonths);
            }




            function loadFeesForMonth(month) {
                const fee_type = $('#fee_type').val();
                const class_id = $('#class_id').val();
                const session_id = $('#session_id').val();
                console.log('Loading fees for month:', month, 'fee_type:', fee_type, 'class_id:', class_id,
                    'session_id:', session_id);


                const url = "{{ route('load.fees.by.feetype') }}".replace(':fee_type', fee_type);

                $.ajax({
                    type: "POST",
                    url: url,
                    data: {
                        _token: '{{ csrf_token() }}',
                        fee_type: fee_type,
                        class_id: class_id,
                        session_id: session_id,
                        month: month
                    },
                    success: function(resp) {
                        let rows = '';
                        const groupedFees = {};

                        // 1. Group fees by month
                        resp.forEach(function(fee) {
                            if (!groupedFees[month]) {
                                groupedFees[month] = [];
                            }
                            groupedFees[month].push(fee);
                        });

                        // 2. Loop through each month group
                        Object.keys(groupedFees).forEach(function(monthKey) {
                            const fees = groupedFees[monthKey];

                            // Add single month header row
                            rows += `
            <tr class="fee-row" data-month="${monthKey}">
                <td colspan="3"><strong>${formatMonthYear(monthKey)}</strong></td>
                <input type="hidden" class="month" name="month_new[]" value="${monthKey}">
            </tr>
        `;

                            // Add each fee under that month
                            fees.forEach(function(fee) {
                                // Check if already present in DOM (to prevent duplicates)
                                if ($(
                                        `.fee-row[data-month="${monthKey}"][data-fee-id="${fee.id}"]`
                                    )
                                    .length === 0) {
                                    rows += `
                    <tr class="fee-row" data-month="${monthKey}" data-fee-id="${fee.id}">
                        <td>
                            <input name="fee_id_new[${monthKey}][]" value="${fee.id}"
                                class="fee-checkbox" data-fee-name="${fee.name}"
                                title="select" type="checkbox" data-fee-month="${monthKey}"
                                style="margin-right: 10px; height: 20px; width: 20px;">
                            ${fee.name}
                        </td>
                        <td>
                            <input type="text" name="amount_new[${monthKey}][${fee.id}]" class="form-control"
                                placeholder="Amount" value="${fee.amount || ''}">
                        </td>
                        <td>
                            <button type="button" class="unselect-button"
                                style="display: none; border: none; background: none; cursor: pointer;">
                                <i title="remove" class="fas fa-times" style="color: red;"></i>
                            </button>
                        </td>
                    </tr>
                `;
                                }
                            });
                        });

                        $('#fees-tbody').append(rows);
                    },
                    error: function(xhr, status, error) {
                        console.error("Error loading fees:", error);
                    }
                });
            }

            function formatMonthYear(monthStr) {
                // monthStr is like "2024-08"
                const date = new Date(`${monthStr}-01`);
                return date.toLocaleDateString('en-US', {
                    year: 'numeric',
                    month: 'long'
                });
            }







        })

        // function checkFeeAvailable(month, feeId) {
        //     const fee_type = $('#fee_type').val();
        //     const class_id = $('#class_id').val();
        //     const session_id = $('#session_id').val();
        //     // const month = month;
        //     const url = "{{ route('hostel.fees.assign.check.fees.availability') }}";
        //     $.ajax({
        //         type: "POST",
        //         url: url,
        //         data: {
        //             _token: '{{ csrf_token() }}',
        //             fee_type: fee_type,
        //             class_id: class_id,
        //             session_id: session_id,
        //             month: month,
        //             fee_id: feeId
        //         },
        //         success: function(resp) {
        //             console.log(resp);
        //             if (resp.status == "error") {
        //                 alert(resp.message);
        //                  checkbox.prop('checked', false);
        //             } else {
        //                 console.log(resp.status);
        //             }
        //         }
        //     });
        // }


        // $(document).on('change', '.fee-checkbox', function() {
        //     const checkbox = $(this);

        //     // const feeName = $(this).data('fee-name');
        //     const feeId = $(this).val();
        //     const month = $(this).data('fee-month');
        //     if (checkbox.is(':checked')) {
        //         console.log('Checkbox is checked', month, feeId);
        //         checkFeeAvailable(month, feeId, checkbox);
        //     } else {
        //         console.log('Checkbox is unchecked', month, feeId);
        //     }



        // })
    </script>
@endpush
