@extends('dashboard.master')
@section('title', 'Edit onabashik Fee Assign ')
@section('content')
<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Edit Onabashik Fee Assign</b>
					</span>
				</div>

				<div class="page-title-actions">
					<a title="Back Button" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
						<i class="fas fa-arrow-left mr-1"></i>
						Back
					</a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
					<form enctype="multipart/form-data" action="{{ route('onabashik.fees.assign.update', ['class_id' => $data->first()->class_id, 'session_id' => $data->first()->session_id]) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="session_id">Session<span class="text-red">*</span></label>
                                    <input type="text" class="form-control" value="{{ $data->first()->studentsession->name ?? '--' }}" readonly>
                                    <input type="hidden" name="session_id" class="form-control" value="{{ $data->first()->session_id ?? '--' }}">
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="class_id">Class<span class="text-red">*</span></label>
                                    <input type="text" class="form-control" value="{{ $data->first()->class->name ?? '--' }}" readonly>
                                    <input type="hidden" name="class_id" class="form-control" value="{{ $data->first()->class_id ?? '--' }}">
                                    <input type="hidden" name="type" class="form-control" value="2">
                                </div>
                            </div>

                            <div class="col-md-12">
                                <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                                    <thead>
                                        <tr>
                                            <th>SN</th>
                                            <th>Month</th>
                                            <th class="text-center">Name</th>
                                            <th class="text-center">Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($details as $month => $items)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td>
                                                {{ \Carbon\Carbon::parse($month)->format('F, Y')  }}
                                                <input type="hidden" name="month[]" value="{{ \Carbon\Carbon::parse($month)->format('Y-m')  }}">
                                            </td>
                                            <td colspan="2">
                                                <table class="table ">
                                                    <tbody>
                                                        @foreach($items as $fee)
                                                        <tr>
                                                            <td class="text-left" style="width: 24.40%;">{{ $fee->fees->name ?? '' }}</td>
                                                            <td class="text-center" style="width: 30%;">
                                                                <input type="text" class="form-control text-center" name="amount[]" value="{{ $fee->amount }}">
                                                                <input type="hidden" name="fee_id[]" value="{{ $fee->fee_id }}">
                                                                <input type="hidden" name="id[]" value="{{ $fee->id ?? '' }}">
                                                            </td>
                                                        </tr>
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="row mt-30">
                            <div class="col-sm-12">
                                <button type="submit" class="btn btn-success mr-2">Update</button>
                            </div>
                        </div>
                    </form>

				</div>
			</div>
		</div>
	</section>
</div>

@endsection
