@extends('dashboard.master')
@section('title', 'Edit Special Fee Assign')

@push('css')
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />

    <style>
        .ui-datepicker-calendar {
            display: none;
        }

        #student_id {
            text-align: center;
        }
    </style>
@endpush

@section('content')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span><b>Edit Special Fee Assign</b></span>
                    </div>

                    <div class="page-title-actions">
                        <a title="Back Button" href="{{ route('special.fees.assign') }}" type="button"
                            class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i> Back
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body">
                        <form enctype="multipart/form-data" id="specialFeeForm"
                            action="{{ route('special.fees.assign.update', $feeAssign->id) }}" method="POST">
                            @csrf
                            @method('PUT')
                            <div class="row">
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="session_id">Session <span class="text-red">*</span></label>
                                        <select name="session_id_fake" id="session_id"
                                            class="form-control @error('session_id') is-invalid @enderror" required
                                            disabled>
                                            <option value="">Select One</option>
                                            @foreach ($sessions as $session)
                                                <option value="{{ $session->id }}"
                                                    {{ $feeAssign->session_id == $session->id ? 'selected' : '' }}>
                                                    {{ $session->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        <input type="hidden" name="session_id" value="{{ $feeAssign->session_id }}">
                                        @error('session_id')
                                            <span class="text-danger">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="class_id">Class <span class="text-red">*</span></label>
                                        <select name="class_id_fake" id="class_id"
                                            class="form-control @error('class_id') is-invalid @enderror" required disabled>
                                            <option value="">Select One</option>
                                            @foreach ($class as $item)
                                                <option value="{{ $item->id }}"
                                                    {{ $feeAssign->class_id == $item->id ? 'selected' : '' }}>
                                                    {{ $item->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        <input type="hidden" name="class_id" value="{{ $feeAssign->class_id }}">
                                        @error('class_id')
                                            <span class="text-danger">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="special_fees_id">Special Fees <span class="text-red">*</span></label>
                                        <select name="special_fees_id_fake" id="special_fees_id"
                                            class="form-control @error('special_fees_id') is-invalid @enderror" required
                                            disabled>
                                            <option value="">Select One</option>
                                            @foreach ($specialFees as $item)
                                                <option value="{{ $item->id }}" data-amount="{{ $item->amount }}"
                                                    {{ $selectedFeeId == $item->id ? 'selected' : '' }}>
                                                    {{ $item->name }} - {{ $item->amount }} Taka
                                                </option>
                                            @endforeach
                                        </select>
                                        <input type="hidden" name="special_fees_id" value="{{ $selectedFeeId }}">
                                        @error('special_fees_id')
                                            <span class="text-danger">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror
                                    </div>
                                </div>


                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="months">Select Months <span class="text-red">*</span></label>
                                        <select name="months[]" id="months" class="form-control select2" multiple
                                            required>
                                            @if (!empty($selectedMonths))
                                                @foreach ($selectedMonths as $month)
                                                    @php
                                                        $date = \Carbon\Carbon::parse($month);
                                                        $text = $date->format('F Y');
                                                        $value = $date->format('Y-m');
                                                    @endphp
                                                    <option value="{{ $value }}" selected>{{ $text }}
                                                    </option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-4" style="margin-top: 32px">

                                    <button type="button" id="applyToAllBtn" class="btn btn-primary btn-sm">Apply amount to
                                        All</button>

                                </div>


                            </div>

                            <div class="row">
                                <div class="table-responsive hideClass">
                                    <table id="data_table"
                                        class="table table-bordered table-striped data-table table-hover">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Student</th>
                                                <th>Amount</th>
                                            </tr>
                                        </thead>
                                        <tbody id="student_data">

                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <div class="row mt-30">
                                <div class="col-sm-12">
                                    <button type="submit" class="btn btn-success mr-2">Update</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>

    @push('js')
        <script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>

        <script>
            $(document).ready(function() {
                // Month Picker (User can select any month)
                $(function() {
                    $('#month').datepicker({
                        changeMonth: true,
                        changeYear: true,
                        showButtonPanel: true,
                        dateFormat: 'MM-yy',
                        beforeShow: function(input, inst) {
                            $(input).datepicker('setDate', new Date(inst.selectedYear, inst
                                .selectedMonth, 1));
                        },
                        onClose: function(dateText, inst) {
                            var month = $.datepicker.formatDate('MM', new Date(inst.selectedYear,
                                inst.selectedMonth, 1));
                            var year = inst.selectedYear;
                            $(this).val($.datepicker.formatDate('MM-yy', new Date(year, inst
                                .selectedMonth, 1)));
                        }
                    });
                });

                // Load students when class or session changes
                $('#class_id, #session_id, #special_fees_id').on('change', function() {
                    loadStudents();
                });

                function loadStudents() {
                    var session_id = $('#session_id').val();
                    var class_id = $('#class_id').val();
                    var special_fees_id = $('#special_fees_id').val();
                    var feeAssignId = @json($feeAssign->id);
                    console.log("feeAssignId", feeAssignId);

                    if (class_id && session_id && special_fees_id) {
                        $.ajax({
                            url: "{{ route('special.get.student.by.session') }}",
                            type: "POST",
                            data: {
                                session_id: session_id,
                                class_id: class_id,
                                special_fees_id: special_fees_id,
                                feeAssignId: feeAssignId,
                                _token: '{{ csrf_token() }}',
                            },
                            success: function(response) {
                                console.log(response);
                                $('#student_data').empty();
                                if (response.length > 0) {
                                    $('.hideClass').show();
                                }

                                response.forEach(function(student, index) {
                                    let amount = student.amount ||
                                    0; // Default to 0 if amount is not set
                                    let studentType = student.student_type =="2" ? "আবাসিক" : 'অনাবাসিক' || '';
                                    let row = $('<tr></tr>');
                                    row.append('<td>' + (index + 1) + '</td>');
                                    row.append('<td>' + student.name + ' || ' + student.roll_no +
                                        ' || ' + studentType + ' || ' +
                                        student.register_no + '</td>');
                                    row.append(
                                        '<td>' +
                                        '<input class="form-control amount-field" type="text" name="amount[]" value="' +
                                        amount + '" />' +
                                        '<input type="hidden" name="student_id[]" value="' +
                                        student.id +
                                        '" />' +
                                        '</td>'
                                    );
                                    $('#student_data').append(row);
                                });
                            },
                            error: function(xhr, status, error) {
                                console.error(error);
                                alert("An error occurred while loading students.");
                            }
                        });
                    }
                }
                loadStudents();
            });

            @if (Session::has('success'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true,
                    "timeOut": 2000
                };
                toastr.success("{{ session('success') }}");
            @endif

            @if (Session::has('error'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true
                };
                toastr.error("{{ session('error') }}");
            @endif


            $(document).ready(function() {
                $('.select2').select2({
                    placeholder: "Select months",
                    allowClear: true,
                    closeOnSelect: false // Keep dropdown open for multiple selections
                });
            });

            $(document).ready(function() {
                $('#months').select2({
                    placeholder: 'Search and select months',
                    ajax: {
                        url: '{{ route('months.search') }}',
                        dataType: 'json',
                        delay: 250,
                        data: function(params) {
                            return {
                                q: params.term // user input
                            };
                        },
                        processResults: function(data) {
                            return {
                                results: data
                            };
                        },
                        cache: true
                    },
                    width: '100%'
                });

                $('#applyToAllBtn').on('click', function() {
                    const selectedOption = $('#special_fees_id option:selected');
                    const amount = selectedOption.data('amount');
                    console.log("selected amount", amount);

                    if (!amount || amount == 0) {
                        alert('Please select a fee with a valid amount before applying to all.');
                        return;
                    }

                    $('.amount-field').val(amount);
                });
            });

            $(document).on('input', '.amount-field', function() {
                const amount = parseFloat($(this).val()) || 0; // Convert to number, default to 0 if invalid
                const selectedOption = $('#special_fees_id option:selected');
                const feeAmount = parseFloat(selectedOption.data('amount')) || 0;

                // Check if amount is >= feeAmount and if a fee is selected
                if (selectedOption.length && !isNaN(feeAmount) && amount > feeAmount) {
                    alert('Amount must be less than the fee amount (' + feeAmount + ').');
                    $(this).val(feeAmount); // Clear the input (or set to feeAmount - 0.01 if needed)
                    return false;
                }
            });
        </script>
    @endpush
@endsection
