@extends('dashboard.master')
@section('title', 'Annual Report')

@push('css')
    <link rel="stylesheet" href="{{ asset('backend/DataTables/datatables.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/css/toggle.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css" integrity="sha512-O03ntXoVqaGUTAeAmvQ2YSzkCvclZEcPQu1eqloPaHfJ5RuNGiS4l+3duaidD801P50J28EHyonCV06CUlTSag==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
    <style>
        .dropify-wrapper .dropify-message p {
            font-size: initial;
        }
        .swal-title{
            font-size: 17px;
            color: red;
            padding: 0;
        }
        .swal-text{
            margin-top: 5px !important;
            color: black;
            background-color: white;
            box-shadow: none;
        }
        .swal-modal{
            max-width: 299px ;
            padding-top: 1px;
            margin-top: 1px;
            padding: 1px 1px;
            vertical-align: top;
        }
        .ui-datepicker-calendar {
            display: none;
        }

        .ui-datepicker-month,
        .ui-datepicker-day {
            display: none !important;
        }
    </style>
@endpush

@section('content')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span><b>Annual Report</b></span>
                    </div>
                    <div class="page-title-actions">
                        <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i>Back
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="fund_id"> Select Fund</label>
                                    <select name="fund_id" id="fund_id" class="form-control">
                                        <option value="">Select All</option>
                                        @foreach ($funds as $fund)
                                            <option value="{{ $fund->id }}">{{ $fund->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="year">Select Year<span class="text-red">*</span></label>
                                    <div class="d-flex">
                                        <input type="text" name="year" id="year" class="form-control datepicker-year" placeholder="YYYY">
                                        <button style="margin-left:2px; width:100px !important" title="Search Button" type="submit" id="search" class="btn btn-sm btn-primary float-left search">
                                            <i class="fa fa-search"></i> Search
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card hideClass">
                    <div class="card-body">
                        <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Fund</th>
                                    <th>Year</th>
                                    <th>Income</th>
                                    <th>Expense </th>
                                    <th>Balance</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td id="fund"></td>
                                    <td id="year"></td>
                                    <td id="income">0.00</td>
                                    <td id="expense">0.00</td>
                                    <td id="balance">0.00</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </section>
    </div>

@push('js')
<script src="{{ asset('backend/DataTables/datatables.min.js') }}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script>

$('.hideClass').hide();
$(function() {
    $('#year').datepicker({
        changeMonth: false,
        changeYear: true,
        showButtonPanel: true,
        dateFormat: 'yy',
        onClose: function(dateText, inst) {
            $(this).datepicker('setDate', new Date(inst.selectedYear, 0, 1));
        }
    });

    $('#search').on('click', function(event) {
        event.preventDefault();
        var year = $("#year").val();
        var fund_id = $("#fund_id").val();

        if (year !== '') {
            $.ajax({
                url: "{{ route('annual.accounting') }}",
                type: "GET",
                data: {
                    'year': year,
                    'fund_id': fund_id,
                },
                success: function(response) {
                    let tbody = $('#data_table tbody');
                    tbody.empty(); // Clear the table body

                    if (response.funds && response.funds.length > 0) {
                        // Multiple funds case
                        let sn = 1; // Start the serial number from 1
                        response.funds.forEach(function(fund) {
                            tbody.append(
                                `<tr>
                                    <td>${sn}</td>
                                    <td>${fund.name}</td>
                                    <td>${fund.year}</td>
                                    <td>${fund.income}</td>
                                    <td>${fund.expense}</td>
                                    <td>${fund.balance}</td>
                                </tr>`
                            );
                            sn++; // Increment the serial number
                        });
                    } else if (response.name) {
                        // Single fund case
                        tbody.append(
                            `<tr>
                                <td>1</td> <!-- Only one fund, so SN is always 1 -->
                                <td>${response.name}</td>
                                <td>${response.year}</td>
                                <td>${response.income}</td>
                                <td>${response.expense}</td>
                                <td>${response.balance}</td>
                            </tr>`
                        );
                    }

                    $('.hideClass').show();
                },
                error: function(xhr, status, error) {
                    alert("Something went wrong. Please try again.");
                }
            });
        } else {
            alert('Please select year');
        }
    });
});


</script>
@endpush
@endsection
