<!doctype html>
<html lang="bn">

<head>
    <meta charset="utf-8">
    <title>প্রাপ্তি ও প্রদান (All)</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        @page {
            size: A4 portrait;
            margin: 10mm;
        }

        body {
            font-family: "Noto Sans Bengali", sans-serif;
        }

        .sheet {
            width: 200mm;
            min-height: 200mm;
            margin: 10mm auto;
            background: #fff;
            padding: 12mm 12mm 14mm;
            border: 2px solid #000;
        }

        .page-break {
            page-break-after: always;
        }

        @media print {
            .no-print {
                display: none;
            }

            .sheet {
                margin: 20px;
            }
        }

        .summary-table {
            width: 100%;
            border-collapse: collapse;
        }

        .summary-table th,
        .summary-table td {
            border: 1px solid #000;
            padding: 6px;
            text-align: right;
        }

        .summary-table th:first-child,
        .summary-table td:first-child {
            text-align: left;
        }

        /* ===== Summary (last page) styles ===== */
        .title {
            font-weight: 800;
            font-size: 26px;
            margin: 0;
        }

        .subline {
            margin: 0 0 6px;
            font-size: 14px;
        }

        .grid-head {
            display: grid;
            grid-template-columns: 1fr 150px 1fr 150px;
            gap: 10px;
            margin: 10px 0;
        }

        .grid-head>div {
            border: 2px solid #000;
            text-align: center;
            font-weight: 700;
            padding: 6px 8px;
        }

        .twocol {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 10%;
        }

        /* Names + Amounts boxed column layout */
        .ledger {
            display: flex;
        }

        .ledger .names {
            flex: 1;
            padding: 8px 10px;
        }

        .ledger .amounts {
            flex: 0 0 150px;
            border: 2px solid #000;
            padding: 8px 10px;
        }

        .list-row {
            display: flex;
            justify-content: space-between;
            font-size: 14.5px;
        }

        .amt {
            text-align: right;
        }

        .bar-strong {
            padding-top: 8px;
            font-weight: 800;
            display: flex;
            justify-content: space-between;
            gap: 10%;
        }

        @media print {
            .ledger {
                break-inside: avoid;
                page-break-inside: avoid;
            }
        }
    </style>
</head>

<body>

    <div class="no-print text-end my-2">
        <a href="javascript:window.print()" class="btn btn-primary btn-sm">Print</a>
        <a href="{{ url()->previous() }}" class="btn btn-dark btn-sm">Back</a>
    </div>

    {{-- প্রতিটি ফান্ড টাইপ আলাদা সেকশন --}}
    @foreach ($pages as $i => $ctx)
        @include('dashboard.funds.partials.audit-single', $ctx)
        @if ($i < count($pages) - 1)
            <div class="page-break"></div>
        @endif
    @endforeach

    {{-- ===== Summary Page (LAST PAGE) ===== --}}
    <div class="page-break"></div>

    @php
        // ===== Helpers সেফলি ডিফাইন =====
        if (!function_exists('engToBanglaDate')) {
            function engToBanglaDate($date)
            {
                $months = [
                    'January' => 'জানুয়ারি',
                    'February' => 'ফেব্রুয়ারি',
                    'March' => 'মার্চ',
                    'April' => 'এপ্রিল',
                    'May' => 'মে',
                    'June' => 'জুন',
                    'July' => 'জুলাই',
                    'August' => 'আগস্ট',
                    'September' => 'সেপ্টেম্বর',
                    'October' => 'অক্টোবর',
                    'November' => 'নভেম্বর',
                    'December' => 'ডিসেম্বর',
                ];
                $eng = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
                $bng = ['০', '১', '২', '৩', '৪', '৫', '৬', '৭', '৮', '৯'];
                $c = \Carbon\Carbon::parse($date);
                $m = $months[$c->format('F')] ?? $c->format('F');
                $d = str_replace($eng, $bng, $c->format('j'));
                $y = str_replace($eng, $bng, $c->format('Y'));
                return "{$d} {$m} {$y}";
            }
        }
        if (!function_exists('engToBangla')) {
            function engToBangla($number)
            {
                $number = round($number, 2);
                $parts = explode('.', sprintf('%.2f', $number));
                $int = $parts[0];
                $dec = $parts[1];
                $last3 = substr($int, -3);
                $rest = substr($int, 0, -3);
                $fmt = $rest ? preg_replace('/\B(?=(\d{2})+(?!\d))/', ',', $rest) . ',' . $last3 : $last3;
                $fmt = $fmt . '.' . $dec;
                return str_replace(
                    ['0', '1', '2', '3', '4', '5', '৬', '7', '8', '9'],
                    ['০', '১', '২', '৩', '৪', '৫', '৬', '৭', '৮', '৯'],
                    $fmt,
                );
            }
        }

        // ===== Totals =====
        $sumIncome = collect($summary)->sum('period_income');
        $sumExpense = collect($summary)->sum('period_expense');
        $sumPrevious = collect($summary)->sum('previous_balance');
        $sumCurrents = collect($summary)->sum('current_balance');

        $incomeWithPreviousBalance = collect($summary)->sum('incomeWithPreviousBalance');
        $expenseWithCurrentBalance = collect($summary)->sum('expenseWithCurrentBalance');

        // চারটা তহবিল আলাদা করে নাও
        $generalRow = collect($summary)->firstWhere('label', 'General') ?? [
            'period_income' => 0,
            'period_expense' => 0,
        ];
        $gurabaRow = collect($summary)->firstWhere('label', 'Guraba') ?? ['period_income' => 0, 'period_expense' => 0];
        $mahfilRow = collect($summary)->firstWhere('label', 'Mahfil') ?? ['period_income' => 0, 'period_expense' => 0];
        $otherRow = collect($summary)->firstWhere('label', 'Other') ?? ['period_income' => 0, 'period_expense' => 0];
    @endphp

    <section class="sheet">
        <div class="text-center">
            <h1 class="title">প্রাপ্তি ও প্রদান হিসাব (সকল তহবিল)</h1>
            <p class="subline">{{ engToBanglaDate($start_date) }} ইং হতে {{ engToBanglaDate($end_date) }} ইং পর্যন্ত।
            </p>
        </div>

        <div class="grid-head">
            <div>প্রাপ্তি</div>
            <div>টাকা</div>
            <div>পরিশোধ</div>
            <div>টাকা</div>
        </div>

        <div class="twocol">
            {{-- LEFT: Receipts --}}
            <div>
                <div class="list-row" style="margin-bottom:6px;">
                    <div><b>প্রাপ্ত তথ্যের উৎস</b></div>
                </div>
                <div class="list-row" style="margin-bottom:12px;">
                    <div>পুর্বের টাকা</div>
                    <div class="amt">{{ engToBangla($sumPrevious) }}</div>
                </div>

                <div class="list-row" style="margin-top:6px; margin-bottom:10px;">
                    <div><b>প্রাপ্তির বিবরণ</b></div>
                    <div class="amt">{{ engToBangla($sumIncome) }}</div>
                </div>

                <div class="ledger">
                    <div class="names">
                        <div>সাধারণ তহবিল</div>
                        <div>গোরাবা তহবিল</div>
                        <div>মাহফিল তহবিল</div>
                        <div>অন্যান্য তহবিল</div>
                    </div>
                    <div class="amounts">
                        <div class="list-row">
                            <div class="amt">{{ engToBangla($generalRow['period_income'] ?? 0) }}</div>
                        </div>
                        <div class="list-row">
                            <div class="amt">{{ engToBangla($gurabaRow['period_income'] ?? 0) }}</div>
                        </div>
                        <div class="list-row">
                            <div class="amt">{{ engToBangla($mahfilRow['period_income'] ?? 0) }}</div>
                        </div>
                        <div class="list-row">
                            <div class="amt">{{ engToBangla($otherRow['period_income'] ?? 0) }}</div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- RIGHT: Payments --}}
            <div>
                <div class="list-row" style="margin-top:20%; margin-bottom:10px;">
                    <div><b>প্রদানের বিবরণ</b></div>
                    <div class="amt">{{ engToBangla($sumExpense) }}</div>
                </div>

                <div class="ledger">
                    <div class="names">
                        <div>সাধারণ তহবিল</div>
                        <div>গোরাবা তহবিল</div>
                        <div>মাহফিল তহবিল</div>
                        <div>অন্যান্য তহবিল</div>
                    </div>
                    <div class="amounts">
                        <div class="list-row">
                            <div class="amt">{{ engToBangla($generalRow['period_expense'] ?? 0) }}</div>
                        </div>
                        <div class="list-row">
                            <div class="amt">{{ engToBangla($gurabaRow['period_expense'] ?? 0) }}</div>
                        </div>
                        <div class="list-row">
                            <div class="amt">{{ engToBangla($mahfilRow['period_expense'] ?? 0) }}</div>
                        </div>
                        <div class="list-row">
                            <div class="amt">{{ engToBangla($otherRow['period_expense'] ?? 0) }}</div>
                        </div>
                    </div>
                </div>

                <div class="list-row" style="margin-top:20px;">
                    <div>নগদ তহবিল</div>
                    <div class="amt" style="border:2px solid #000; padding:8px 10px;">
                        {{ engToBangla($sumCurrents) }}
                    </div>
                </div>
            </div>
        </div>

        {{-- নিচের দুইটা মোটা বার --}}
        <div class="row g-3 mt-3 twocol">
            <div>
                <div class="bar-strong">
                    <span style="border-top:2px solid #000; border-bottom:2px solid #000;">
                        {{ engToBangla($incomeWithPreviousBalance) }}
                    </span>
                </div>
            </div>
            <div>
                <div class="bar-strong">
                    <span style="border-top:2px solid #000; border-bottom:2px solid #000;">
                        {{ engToBangla($expenseWithCurrentBalance) }}
                    </span>
                </div>
            </div>
        </div>
    </section>

</body>

</html>
