@extends('dashboard.master')
@section('title', 'Daily Deposit Expenses')
@push('css')
    <link rel="stylesheet" href="{{ asset('backend/DataTables/datatables.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/css/toggle.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css"
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
    <?php
    $invoiceBgPath = 'back_height.jpg';
    if (isset($invoice->invoice_bg) && !empty($invoice->invoice_bg)) {
        $potentialBgFile = 'img/' . $invoice->invoice_bg;
        if (file_exists(public_path($potentialBgFile))) {
            $invoiceBgPath = $potentialBgFile;
        }
    }
    ?>
    <style>
        @media print {
            body * {
                visibility: hidden;
            }

            #printArea,
            #printArea * {
                visibility: visible;
            }

            #printArea {
                position: relative;
                left: 0;
                top: 0;
                width: 100%;
                background-image: url('{{ asset($invoiceBgPath) }}') !important;
                background-size: cover !important;
                background-position: center !important;
                background-repeat: no-repeat !important;
            }

            .container,
            .container-fluid,
            .content-wrapper>.content {
                padding: 0 !important;
            }

            .table-container {
                margin-top: 10px;
                margin-bottom: 20px;
            }

            table {
                width: 100% !important;
                page-break-inside: auto;
            }

            tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }

            .dataTables_length,
            .dataTables_filter,
            .dataTables_paginate,
            .dataTables_info,
            .print,
            .hideClass,
            .dt-buttons .hideClass {
                display: none !important;
            }

            .print-table th,
            .print-table td {
                background: transparent !important;
            }

            @page {
                size: A4 portrait;
                margin: 10mm;
            }

            thead {
                display: table-header-group;
            }

            tfoot {
                display: table-footer-group;
            }

            #print_only_previous_tr {
                display: table-row !important;
            }

            #previous_tr {
                display: none !important;
            }

            .hideClass {
                display: none !important;
            }

            .first-page-only {
                margin-top: 0;
                padding-top: 0;
            }
        }

        /* Summary bar (screen) */
        .summary-bar .card {
            border: 1px solid #e9ecef;
        }

        .summary-metric .value {
            font-weight: 700;
            font-size: 1.15rem;
        }

        .summary-metric .label {
            color: #6c757d;
            font-size: .85rem;
        }
    </style>
@endpush

@section('content')

    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon"><i class="nav-icon fas fa-mosque"></i></div>
                        <span><b>Daily Deposit Expenses</b></span>
                    </div>
                    <div class="page-title-actions">
                        <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i> Back
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">

                <div class="card">
                    <div class="card-body">
                        <div class="row hideClass">
                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label for="fund_type">Fund Type<span class="text-red">*</span></label>
                                    <select name="fund_type" id="fund_type" class="form-control">
                                        <option value="">Select One</option>
                                        <option value="1">General</option>
                                        <option value="2">Guraba</option>
                                        <option value="3">Mahfil</option>
                                        <option value="4">Others</option>
                                    </select>
                                    @error('fund_type')
                                        <span class="text-danger" role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label for="fund_id">Select Fund<span class="text-red">*</span>
                                        <span class="text-info" id="balance" style="display: none"></span>
                                    </label>
                                    <select name="fund_id" id="fund_id" class="form-control">
                                        <option value="">Select One</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label for="start_date">From Date</label>
                                    <input type="text" name="start_date" id="start_date" class="form-control datepicker"
                                        placeholder="Enter start date">
                                </div>
                            </div>

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label for="end_date">To Date</label>
                                    <input type="text" name="end_date" id="end_date" class="form-control datepicker"
                                        placeholder="Enter end date">
                                </div>
                            </div>

                            {{-- NEW: Type filter --}}
                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label for="type_filter">Type</label>
                                    <select id="type_filter" class="form-control">
                                        <option value="">All</option>
                                        <option value="1">Income</option>
                                        <option value="2">Expense</option>
                                    </select>
                                </div>
                            </div>

                            {{-- NEW: Name filter --}}
                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label for="name_term">Name</label>
                                    <input type="text" id="name_term" class="form-control"
                                        placeholder="Donor/Student/Teacher/Name">
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="purpose">Item Search</label>
                                    <div class="d-flex">
                                        <input type="text" name="purpose" id="search_term" class="form-control"
                                            placeholder="Enter search term">
                                        <button style="margin-left:2px; width:100px !important" title="Search Button"
                                            type="submit" id="search" class="btn btn-sm btn-primary float-left search">
                                            <i class="fa fa-search"></i> Search
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- ===== Summary Bar (Top) ===== --}}
                        <div class="summary-bar mb-3" id="summaryBar" style="display:none;">
                            <div class="row g-2">
                                <div class="col-sm-3">
                                    <div class="card p-3 summary-metric">
                                        <div class="label">Previous Balance</div>
                                        <div class="value" id="sum_prev">0.00 BDT</div>
                                    </div>
                                </div>
                                <div class="col-sm-3">
                                    <div class="card p-3 summary-metric">
                                        <div class="label">Period Income</div>
                                        <div class="value text-success" id="sum_income">0.00 BDT</div>
                                    </div>
                                </div>
                                <div class="col-sm-3">
                                    <div class="card p-3 summary-metric">
                                        <div class="label">Period Expense</div>
                                        <div class="value text-danger" id="sum_expense">0.00 BDT</div>
                                    </div>
                                </div>
                                <div class="col-sm-3">
                                    <div class="card p-3 summary-metric">
                                        <div class="label">Closing Balance</div>
                                        <div class="value" id="sum_closing">0.00 BDT</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        {{-- ===== End Summary Bar ===== --}}

                        <div class="card">
                            <div class="card-body" id="printArea">
                                <table id="data_table"
                                    class="table table-bordered table-striped data-table table-hover print-table">
                                    <thead>
                                        <tr class="print-only">
                                            <td colspan="6" style="padding:0;">
                                                <img src="{{ asset('img/' . $invoice->invoice_header) }}"
                                                    style="width:100%;">
                                            </td>
                                        </tr>
                                        <tr id="previous_tr" class="first-page-only">
                                            <td colspan="2"> Previous Balance</td>
                                            <td colspan="1"><b id="prevBalance"> </b> BDT</td>
                                            <td colspan="3" id="fundNameContainer"> Fund : <b id="fundName"> </b>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>SN</th>
                                            <th>Date</th>
                                            <th>Purpose</th>
                                            <th>Income</th>
                                            <th>Expense</th>
                                            <th>Current Balance</th>
                                        </tr>
                                    </thead>
                                    <tbody></tbody>
                                    <tfoot>
                                        <tr>
                                            <th colspan="3">Total</th>
                                            <th id="total_income">00.00</th>
                                            <th id="total_expense">00.00</th>
                                            <th id="total_balance">00.00</th>
                                        </tr>
                                        <tr class="print-only">
                                            <td colspan="6" style="padding:0;">
                                                <img src="{{ asset('img/' . $invoice->invoice_footer) }}"
                                                    style="width:100%;">
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>

                                <button class="btn btn-danger float-left mt-5 print" id="print">Print</button>
                            </div>
                        </div>

                    </div>
                </div>

            </div>
        </section>
    </div>
@endsection

@push('js')
    <script src="{{ asset('backend/DataTables/datatables.min.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js" crossorigin="anonymous"
        referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    <script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
    <script>
        $('.datepicker').datepicker({
            dateFormat: 'dd/m/yy'
        });

        $(document).ready(function() {
            var table;

            $('#search').on('click', function(event) {
                event.preventDefault();
                var start_date = $("#start_date").val();
                var end_date = $("#end_date").val();
                var fund_id = $("#fund_id").val();
                var search_term = $("#search_term").val();
                var type_filter = $("#type_filter").val(); // NEW
                var name_term = $("#name_term").val(); // NEW

                if (fund_id !== '') {
                    if ($.fn.DataTable.isDataTable('#data_table')) {
                        table.destroy();
                    }

                    table = $('#data_table').DataTable({
                        order: [],
                        lengthMenu: [
                            [10, 25, 50, 100, -1],
                            [10, 25, 50, 100, "All"]
                        ],
                        processing: true,
                        serverSide: true,
                        ajax: {
                            url: "{{ route('fund.balance.sheet') }}",
                            type: "GET",
                            data: function(d) {
                                d.start_date = start_date;
                                d.end_date = end_date;
                                d.fund_id = fund_id;
                                d.search_term = search_term;
                                d.type_filter = type_filter; // NEW
                                d.name_term = name_term; // NEW
                            }
                        },
                        columns: [{
                                data: null,
                                render: function(data, type, row, meta) {
                                    return meta.row + 1;
                                }
                            },
                            {
                                data: 'date',
                                render: function(data, type, row) {
                                    return (type === 'display' || type === 'filter') ?
                                        moment(data).format('D-MMM-YYYY') : data;
                                }
                            },
                            {
                                data: 'purpose',
                                name: 'purpose'
                            },
                            {
                                data: 'income',
                                name: 'income'
                            },
                            {
                                data: 'expense',
                                name: 'expense'
                            },
                            {
                                data: 'current_balance',
                                name: 'current_balance'
                            },
                        ],
                        initComplete: function(data) {
                            var prevBalance = Number(data.json.prevBalance || 0);
                            var fundName = data.json.fundName || '';

                            // Top summary: prev balance
                            $('#sum_prev').text(prevBalance.toFixed(2) + ' BDT');
                            $('#summaryBar').show();

                            // Header row (existing)
                            $('#previous_tr').show();
                            $('#prevBalance').html(prevBalance.toFixed(2));

                            if (fundName) {
                                $('#fundName').html(fundName);
                                $('#fundNameContainer').show();
                            } else {
                                $('#fundNameContainer').hide();
                            }
                        },
                        drawCallback: function(settings) {
                            var api = this.api();

                            // Period totals (from displayed rows)
                            var totalIncome = api.column(3).data().reduce(function(a, b) {
                                return parseFloat(a || 0) + parseFloat(b || 0);
                            }, 0);
                            var totalExpense = api.column(4).data().reduce(function(a, b) {
                                return parseFloat(a || 0) + parseFloat(b || 0);
                            }, 0);

                            // Latest balance is the last row's current_balance
                            var lastRowData = api.row(api.rows().count() - 1).data();
                            var latestBalance = lastRowData ? parseFloat(lastRowData
                                .current_balance || 0) : parseFloat($('#prevBalance')
                            .text() || 0);

                            // Bottom totals (existing)
                            $('#total_income').html(totalIncome.toFixed(2));
                            $('#total_expense').html(totalExpense.toFixed(2));
                            $('#total_balance').html(latestBalance.toFixed(2));

                            // Top summary (new)
                            $('#sum_income').text(totalIncome.toFixed(2) + ' BDT');
                            $('#sum_expense').text(totalExpense.toFixed(2) + ' BDT');
                            $('#sum_closing').text(latestBalance.toFixed(2) + ' BDT');

                            $('#print').show();
                        },
                        language: {
                            search: "_INPUT_",
                            searchPlaceholder: "Search records"
                        },
                    });
                } else {
                    alert('Please select a fund');
                }
            });
        });

        // Dependent fund dropdown by fund_type (unchanged)
        $(document).ready(function() {
            $('#fund_type').on('change', function() {
                var fund_type = $(this).val();
                var month = $('#month').val();

                if (fund_type) {
                    $.ajax({
                        url: "{{ route('find.fund') }}",
                        type: 'POST',
                        data: {
                            month: month,
                            fund_type: fund_type,
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(data) {
                            $('#fund_id').empty().append(
                            '<option value="">Select One</option>');
                            $.each(data, function(index, fund) {
                                $('#fund_id').append('<option value="' + fund.id +
                                    '">' + fund.name + '</option>');
                            });
                        },
                        error: function(xhr) {
                            console.log('Error:', xhr.responseText || xhr.statusText);
                        }
                    });
                } else {
                    $('#fund_id').empty().append('<option value="">Select One</option>');
                }
            });
        });

        // Print (unchanged)
        $(document).ready(function() {
            $('.print-only').hide();
            $('#print').on('click', function() {
                $('th.action, td.action').hide();
                $('.print-only').show();
                $('.hideClass').show();

                const table = $('#data_table tbody');
                const original = $('#previous_tr');

                $('#print_only_previous_tr').remove();
                if (original.length) {
                    const clone = original.clone();
                    clone.attr('id', 'print_only_previous_tr').css('display', 'table-row');
                    table.prepend(clone);
                }
                window.print();

                setTimeout(function() {
                    $('.print-only').hide();
                    $('th.action, td.action').show();
                    $('#print_only_previous_tr').remove();
                }, 500);
            });
        });
    </script>
@endpush
