<section class="sheet">

    @php
        if (!function_exists('engToBanglaDate')) {
            function engToBanglaDate($date)
            {
                $months = [
                    'January' => 'জানুয়ারি',
                    'February' => 'ফেব্রুয়ারি',
                    'March' => 'মার্চ',
                    'April' => 'এপ্রিল',
                    'May' => 'মে',
                    'June' => 'জুন',
                    'July' => 'জুলাই',
                    'August' => 'আগস্ট',
                    'September' => 'সেপ্টেম্বর',
                    'October' => 'অক্টোবর',
                    'November' => 'নভেম্বর',
                    'December' => 'ডিসেম্বর',
                ];
                $eng = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
                $bng = ['০', '১', '২', '৩', '৪', '৫', '৬', '৭', '৮', '৯'];
                $c = \Carbon\Carbon::parse($date);
                $m = $months[$c->format('F')] ?? $c->format('F');
                $d = str_replace($eng, $bng, $c->format('j'));
                $y = str_replace($eng, $bng, $c->format('Y'));
                return "{$d} {$m} {$y}";
            }
        }
        if (!function_exists('engToBangla')) {
            function engToBangla($number)
            {
                $number = round($number, 2);
                $parts = explode('.', sprintf('%.2f', $number));
                $int = $parts[0];
                $dec = $parts[1];
                $last3 = substr($int, -3);
                $rest = substr($int, 0, -3);
                $fmt = $rest ? preg_replace('/\B(?=(\d{2})+(?!\d))/', ',', $rest) . ',' . $last3 : $last3;
                $fmt = $fmt . '.' . $dec;
                return str_replace(
                    ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'],
                    ['০', '১', '২', '৩', '৪', '৫', '৬', '৭', '৮', '৯'],
                    $fmt,
                );
            }
        }

        $typeMap = [
            1 => 'ফান্ড গ্রহণ',
            2 => 'ফান্ড ব্যয়',
            3 => 'ওপেনিং',
            4 => 'সনদ',
            5 => 'দান',
            6 => 'শিক্ষার্থী ফি',
            7 => 'বোর্ডিং ফি',
            8 => 'মাহফিল দান প্রদান',
            9 => 'বাকি প্রদান',
            10 => 'বাকি গ্রহণ',
            11 => 'লোন প্রদান',
            12 => 'লোন গ্রহণ',
            13 => 'শিক্ষক বেতন',
            14 => 'ভর্তি ফি',
            15 => 'মাহফিল দান গ্রহণ',
            16 => 'স্পন্সর শিক্ষার্থী ফি',
            17 => 'শিক্ষক বোনাস',
            18 => 'ফান্ড ট্রান্সফার',
        ];

        $type =
            $fundType == '1' ? 'সাধারণ' : ($fundType == '2' ? 'গোরাবা' : ($fundType == '3' ? 'মাহফিল' : 'অন্যান্য'));
    @endphp

    <style>
        :root {
            --border: #000;
        }

        .title {
            font-weight: 800;
            font-size: 26px;
            margin: 0;
        }

        .subline {
            font-size: 14px;
            margin: 0
        }

        .grid-head {
            display: grid;
            grid-template-columns: 1fr 150px 1fr 150px;
            gap: 10px;
            margin-bottom: 10px
        }

        .grid-head>div {
            border: 2px solid var(--border);
            text-align: center;
            font-weight: 700;
            padding: 6px 8px
        }

        .twocol {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 10%
        }

        .ledger {
            display: flex;
        }

        .ledger .names {
            flex: 1;
            padding: 8px 10px
        }

        .ledger .amounts {
            flex: 0 0 150px;
            border: 2px solid var(--border);
            padding: 8px 10px
        }

        .list-row {
            font-size: 14.5px;
            display: flex;
            justify-content: space-between;
        }

        .list-row.sub {
            font-size: 13.5px;
            opacity: .95
        }

        .list-row.sub .label {
            padding-left: 16px;
            position: relative
        }

        .list-row.sub .label:before {
            content: "–";
            position: absolute;
            left: 4px
        }

        .amt {
            text-align: right
        }

        @media print {
            .ledger {
                break-inside: avoid;
                page-break-inside: avoid
            }
        }
    </style>

    <div class="text-center">
        <h1 class="title">প্রাপ্তি ও প্রদান হিসাব ({{ $type ?? 'N/A' }} তহবিল)</h1>
        <p class="subline">{{ engToBanglaDate($start_date) }} ইং হতে {{ engToBanglaDate($end_date) }} ইং পর্যন্ত।</p>
    </div>

    <div class="grid-head">
        <div>প্রাপ্তি</div>
        <div>টাকা</div>
        <div>পরিশোধ</div>
        <div>টাকা</div>
    </div>

    <div class="twocol">
        {{-- Income --}}
        <div>
            <div style="display:flex;justify-content:space-between">
                <div>পুর্বের টাকা</div>
                <div class="amt">{{ engToBangla($previous_balance ?? 0) }}</div>
            </div>
            <div style="display:flex;justify-content:space-between;margin-top:20px">
                <b>প্রাপ্তির বিবরণ</b>
                <p class="mb-0">{{ engToBangla($periodIncome) }}</p>
            </div>

            <div class="ledger">
                <div class="names">
                    @foreach ($incomeDetails ?? [] as $typeKey => $amt)
                        <div class="list-row">
                            <div class="label">{{ $typeMap[$typeKey] ?? 'টাইপ ' . $typeKey }}</div>
                        </div>
                        @foreach ($incomeTree[$typeKey]['subtypes'] ?? [] as $sub)
                            <div class="list-row sub">
                                <div class="label">{{ $sub['name'] ?? 'Fee #' . $sub['fee_id'] }}</div>
                            </div>
                        @endforeach
                    @endforeach
                </div>
                <div class="amounts">
                    @foreach ($incomeDetails ?? [] as $typeKey => $amt)
                        <div class="list-row">
                            <div class="amt">{{ engToBangla($amt) }}</div>
                        </div>
                        @foreach ($incomeTree[$typeKey]['subtypes'] ?? [] as $sub)
                            <div class="list-row sub">
                                <div class="amt">{{ engToBangla($sub['amount'] ?? 0) }}</div>
                            </div>
                        @endforeach
                    @endforeach
                </div>
            </div>
        </div>

        {{-- Expense --}}
        <div>
            <div style="display:flex;justify-content:space-between;margin-top:20%">
                <b>প্রদানের বিবরণ</b>
                <p class="mb-0">{{ engToBangla($periodExpense) }}</p>
            </div>

            <div class="ledger">
                <div class="names">
                    @foreach ($expenseDetails ?? [] as $typeKey => $amt)
                        <div class="list-row">
                            <div class="label">{{ $typeMap[$typeKey] ?? 'টাইপ ' . $typeKey }}</div>
                        </div>
                        @foreach ($expenseTree[$typeKey]['subtypes'] ?? [] as $sub)
                            <div class="list-row sub">
                                <div class="label">{{ $sub['name'] ?? 'Fee #' . $sub['fee_id'] }}</div>
                            </div>
                        @endforeach
                    @endforeach
                </div>
                <div class="amounts">
                    @foreach ($expenseDetails ?? [] as $typeKey => $amt)
                        <div class="list-row">
                            <div class="amt">{{ engToBangla($amt) }}</div>
                        </div>
                        @foreach ($expenseTree[$typeKey]['subtypes'] ?? [] as $sub)
                            <div class="list-row sub">
                                <div class="amt">{{ engToBangla($sub['amount'] ?? 0) }}</div>
                            </div>
                        @endforeach
                    @endforeach
                </div>
            </div>

            <div style="display:flex;justify-content:space-between;margin-top:30px">
                <p>নগদ তহবিল</p>
                <p class="amt" style="border:2px solid var(--border);padding:8px 10px">
                    {{ engToBangla($current_balance ?? 0) }}
                </p>
            </div>
        </div>
    </div>

    <div class="row g-3 mt-2 twocol">
        <div>
            <div class="bar-strong">
                <span style="border-top:2px solid var(--border);border-bottom:2px solid var(--border);">
                    {{ engToBangla($incomeWithPreviousBalance ?? 0) }}
                </span>
            </div>
        </div>
        <div>
            <div class="bar-strong">
                <span style="border-top:2px solid var(--border);border-bottom:2px solid var(--border);">
                    {{ engToBangla($expenseWithCurrentBalance ?? 0) }}
                </span>
            </div>
        </div>
    </div>

</section>
