@extends('dashboard.master')
@section('title', 'Receipt Payment')

@push('css')
    <link rel="stylesheet" href="{{ asset('backend/DataTables/datatables.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/css/toggle.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css"
        integrity="sha512-O03ntXoVqaGUTAeAmvQ2YSzkCvclZEcPQu1eqloPaHfJ5RuNGiS4l+3duaidD801P50J28EHyonCV06CUlTSag=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
    <?php
    $invoiceBgPath = 'back_height.jpg';
    if (isset($invoice->invoice_bg) && !empty($invoice->invoice_bg)) {
        $potentialBgFile = 'img/' . $invoice->invoice_bg;
        if (file_exists(public_path($potentialBgFile))) {
            $invoiceBgPath = $potentialBgFile;
        }
    }
    ?>
    <style>
        .btn-group .btn { min-width: 120px; }

        @media print {
            body * { visibility: hidden; }
            #printArea, #printArea * { visibility: visible; }

            #printArea {
                position: relative;
                left: 0; top: 0; width: 100%;
                background-image: url('{{ asset($invoiceBgPath) }}') !important;
                background-size: cover !important;
                background-position: center !important;
                background-repeat: no-repeat !important;
            }

            .container, .container-fluid, .content-wrapper>.content { padding: 0 !important; }
            .table-container { margin-top: 10px; margin-bottom: 20px; }

            table { width: 100% !important; page-break-inside: auto; }
            tr { page-break-inside: avoid; page-break-after: auto; }

            .dataTables_length, .dataTables_filter, .dataTables_paginate,
            .dataTables_info, .print, .hideClass, .dt-buttons .hideClass { display: none !important; }

            .print-table th, .print-table td { background: transparent !important; }

            @page { size: A4 portrait; margin: 10mm; }
            thead { display: table-header-group; }
            tfoot { display: table-footer-group; }

            .first-page-only { margin-top: 0; padding-top: 0; }
        }
    </style>
@endpush

@section('content')

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon"><i class="nav-icon fas fa-mosque"></i></div>
                    <span><b>Receipt Payment</b></span>
                </div>
                <div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i> Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-3">
                            <div class="form-group">
                                <label for="start_date">From Date</label>
                                <input type="text" name="start_date" id="start_date"
                                       class="form-control datepicker" placeholder="Enter start date">
                            </div>
                        </div>

                        <div class="col-sm-3">
                            <div class="form-group">
                                <label for="end_date">To Date</label>
                                <input type="text" name="end_date" id="end_date"
                                       class="form-control datepicker" placeholder="Enter end date">
                            </div>
                        </div>

                        <div class="col-sm-4" style="margin-top: 38px">
                            <button style="margin-left:2px; width:100px !important"
                                    title="Search Button" type="submit" id="search"
                                    class="btn btn-sm btn-primary float-left search">
                                <i class="fa fa-search"></i> Search
                            </button>

                            <button style="margin-left:8px; min-width:180px"
                                    title="Print All Funds" type="button" id="printAllBtn"
                                    class="btn btn-sm btn-success float-left">
                                <i class="fa fa-print"></i> Print All (All Funds)
                            </button>
                        </div>

                        <div class="col-sm-12" style="margin-top: 6px;">
                            <div class="btn-group btn-group-sm" role="group" aria-label="Quick ranges">
                                <button type="button" class="btn btn-outline-secondary" id="qr-yesterday">Yesterday</button>
                                <button type="button" class="btn btn-outline-secondary" id="qr-this-month">This Month</button>
                                <button type="button" class="btn btn-outline-secondary" id="qr-this-year">This Year</button>
                            </div>
                        </div>
                    </div>

                    <div class="row hideClass">
                        <div class="card-body" id="printArea">
                            <table id="data_table" class="table table-bordered table-striped data-table table-hover print-table">
                                <thead>
                                    <tr class="print-only">
                                        <td colspan="8" style="padding:0;">
                                            <img src="{{ asset('img/' . $invoice->invoice_header) }}" style="width:100%;">
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>SN</th>
                                        <th>Date</th>
                                        <th>Fund Type</th>
                                        <th>Previous Balance</th>
                                        <th>Income</th>
                                        <th>Expense</th>
                                        <th>Current Balance</th>
                                        <th class="action">Action</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="3">Total</th>
                                        <th id="total_prev">00.00</th>
                                        <th id="total_income">00.00</th>
                                        <th id="total_expense">00.00</th>
                                        <th id="total_balance">00.00</th>
                                        <th></th>
                                    </tr>
                                </tfoot>
                            </table>
                            <div class="print-only" style="padding:0;">
                                <img src="{{ asset('img/' . $invoice->invoice_footer) }}" style="width:100%;">
                            </div>
                            <button class="btn btn-danger float-left mt-5 print" id="print">Print</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

@push('js')
    <script src="{{ asset('backend/DataTables/datatables.min.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    <script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
    <script>
        // Datepicker init
        $('.datepicker').datepicker({
            dateFormat: 'dd/mm/yy'
        });

        // Helper to set both pickers using Date objects (so UI opens at selected month/day)
        function setRange(startMoment, endMoment){
            $('#start_date').datepicker('setDate', startMoment.toDate());
            $('#end_date').datepicker('setDate', endMoment.toDate());
        }

        // Quick Range Buttons
        $('#qr-yesterday').on('click', function(){
            const y = moment().subtract(1,'day');
            setRange(y, y);
            $('#search').click();
        });

        $('#qr-this-month').on('click', function(){
            const s = moment().startOf('month');
            const e = moment().endOf('month');
            setRange(s, e);
            $('#search').click();
        });

        $('#qr-this-year').on('click', function(){
            const s = moment().startOf('year');
            const e = moment().endOf('year');
            setRange(s, e);
            $('#search').click();
        });

        // DataTable logic
        $(document).ready(function() {
            var table;

            $('#search').on('click', function(event) {
                event.preventDefault();
                var start_date = $("#start_date").val();
                var end_date   = $("#end_date").val();

                if ($.fn.DataTable.isDataTable('#data_table')) {
                    table.destroy();
                }

                table = $('#data_table').DataTable({
                    order: [],
                    autoWidth: false,
                    processing: true,
                    serverSide: true,
                    lengthMenu: [[10,25,50,100,-1],[10,25,50,100,"All"]],
                    ajax: {
                        url: "{{ route('receipt.payment') }}",
                        type: "GET",
                        data: function(d) {
                            d.start_date = start_date;
                            d.end_date   = end_date;
                        }
                    },
                    columns: [
                        { data: null, render: function(data, type, row, meta) { return meta.row + 1; } },
                        { data: 'date', render: function(data, type) {
                            const m = moment(data, ['YYYY-MM-DD','DD-MMM-YYYY'], true);
                            if ((type === 'display' || type === 'filter') && m.isValid()) {
                                return m.format('D-MMM-YYYY');
                            }
                            return data ?? '';
                        }},
                        { data: 'fund_type', name: 'fund_type', defaultContent: '' },
                        { data: 'previous_balance', name: 'previous_balance', defaultContent: '00.00' },
                        { data: 'income', name: 'income', defaultContent: '00.00' },
                        { data: 'expense', name: 'expense', defaultContent: '00.00' },
                        { data: 'current_balance', name: 'current_balance', defaultContent: '00.00' },
                        { data: 'action', name: 'action', orderable: false, searchable: false, defaultContent: '' }
                    ],
                    columnDefs: [{ targets: -1, className: 'action' }],
                    drawCallback: function(settings){
                        const api = this.api();
                        const toNum = v => {
                            if (typeof v === 'string') v = v.replace(/,/g,'');
                            return parseFloat(v||0) || 0;
                        };

                        const totalPrev    = api.column(3, {page:'current'}).data().toArray().reduce((a,b)=>a+toNum(b),0);
                        const totalIncome  = api.column(4, {page:'current'}).data().toArray().reduce((a,b)=>a+toNum(b),0);
                        const totalExpense = api.column(5, {page:'current'}).data().toArray().reduce((a,b)=>a+toNum(b),0);
                        const totalBalance = api.column(6, {page:'current'}).data().toArray().reduce((a,b)=>a+toNum(b),0);

                        $('#total_prev').text(totalPrev.toFixed(2));
                        $('#total_income').text(totalIncome.toFixed(2));
                        $('#total_expense').text(totalExpense.toFixed(2));
                        $('#total_balance').text(totalBalance.toFixed(2));
                        $('#print').show();
                        api.columns.adjust();
                    }
                });
            });

            // Print logic
            $('#print').on('click', function() {
                $('th.action, td.action').hide();
                $('.print-only').show();
                $('.hideClass').show();
                window.print();

                setTimeout(function() {
                    $('.print-only').hide();
                    $('th.action, td.action').show();
                }, 500);
            });

               function toYMD(str){
        if(!str) return '';
        const m = moment(str, ['DD/MM/YYYY','D/M/YY','DD-MM-YYYY','YYYY-MM-DD'], true);
        return m.isValid() ? m.format('YYYY-MM-DD') : '';
    }

            $('#printAllBtn').on('click', function() {
                const startRaw = $('#start_date').val();
                const endRaw   = $('#end_date').val();

                const start_date = toYMD(startRaw);
                const end_date   = toYMD(endRaw);

                const baseUrl = "{{ route('receipt.payment.auditAll') }}";
                const url = baseUrl + '?start_date=' + encodeURIComponent(start_date) +
                                          '&end_date='   + encodeURIComponent(end_date);

                window.open(url, '_blank');
            });
        });
    </script>
@endpush

@endsection
