@extends('dashboard.master')
@section('title', 'Sonad Giving')

@push('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
@endpush

@section('content')
<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span><b>Sonad Giving</b></span>
				</div>

				<div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i> Back
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
                    <form class="forms-sample add-class" enctype="multipart/form-data" action="{{ route('sonad.store') }}" method="POST">
                        @csrf
                        <div class="row">

                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="receipt_no">Receipt No<span class="text-red">*</span></label>
                                    <input type="text" name="receipt_no" id="receipt_no" value="{{ $receipt_no }}" class="form-control" readonly>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="date">Date<span class="text-red">*</span></label>
                                    <input type="text" name="date" id="date" value="{{ now()->format('Y-m-d') }}" class="form-control" placeholder="date" required>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="fund_id">Select Fund<span class="text-red">*</span></label>
                                    <select name="fund_id" id="fund_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach($funds as $fund)
                                        <option value="{{ $fund->id }}">{{ $fund->name ?? '' }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-5">
                                <div class="form-group">
                                    <label for="student_id">Select Student<span class="text-red">*</span></label>
                                    <select name="student_id" id="student_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach($students as $student)
                                        <option value="{{ $student->student_id }}">{{ $student->students->name ?? '' }} | {{ $student->stuclass->name ?? '' }} | {{ $student->stusession->name ?? '' }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-5">
                                <div class="form-group">
                                    <label for="exam_id">Exam Name<span class="text-red">*</span></label>
                                    <select name="exam_id" id="exam_id" class="form-control">
                                        <option value="">Select One</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="amount">Amount<span class="text-red">*</span></label>
                                    <input type="number" name="amount" id="amount" value="{{ old('amount') }}" class="form-control" placeholder="Amount" required>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="note">Note</label>
                                    <textarea name="note" id="note" cols="2" rows="2" class="form-control">{{ old('note') }}</textarea>
                                </div>
                            </div>

                            <div class="col-sm-12">
                                <button title="Save" type="submit" class="btn btn-primary mr-2">Save</button>
                            </div>
                        </div>
                    </form>
				</div>
			</div>
		</div>
	</section>
</div>

@push('js')
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.inputmask/5.0.8/jquery.inputmask.min.js"></script>
<script>
$(function () {
    $('#date').datepicker({
        dateFormat: 'yy-mm-dd'
    });

    $('#date').inputmask('9999-99-99', {
        placeholder: 'yyyy-mm-dd',
        clearIncomplete: true
    });
});


$('#student_id').on('change', function () {
    $('#exam_id').empty().append('<option value="">Select One</option>');
    var student_id = $(this).val();
    var _token = $('meta[name="csrf-token"]').attr('content');

    if (student_id) {
        $.ajax({
            url: "{{ route('student.wise.exam') }}",
            type: "POST",
            data: {
                student_id: student_id,
                _token: _token,
            },
            success: function (response) {
                if (response.length > 0) {
                    $.each(response, function (index, item) {
                        if (item.exam) {
                            $('#exam_id').append(
                                '<option value="' + item.exam_id + '">' + item.exam.name + '</option>'
                            );
                        }
                    });
                } else {
                    alert('No exams found for this student.');
                }
            },
            error: function () {
                alert('Failed to fetch exams.');
            }
        });
    }
});

$('#exam_id').on('change', function () {
    var student_id = $('#student_id').val();
    var exam_id = $(this).val();
    var _token = $('meta[name="csrf-token"]').attr('content');

    if (student_id && exam_id) {
        $.ajax({
            url: "{{ route('check.sonad.giving') }}",
            type: "POST",
            data: {
                student_id: student_id,
                exam_id: exam_id,
                _token: _token,
            },
            success: function (response) {
                if (response.exists) {
                    toastr.error("Sonad Giving has already been submitted for this student and exam.");
                    location.reload();
                }
            },
            error: function () {
                toastr.error("Something went wrong while checking Sonad record.");
            }
        });
    }
});


@if(Session::has('error'))
    toastr.options = {
        "closeButton": true,
        "progressBar": true
    };
    toastr.error("{{ session('error') }}");
@endif
</script>
@endpush
@endsection
