<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" href="{{ asset('logo.png')}}" />
    <title>Guraba Fund Receipt</title>
    <style>
        /* .content{
            background:#deca90;
        } */
        .overlay{
            position: absolute;
            /* top: 50%; */
            opacity: 0.3;
            width: 97%;
            text-align: center;
            overflow: hidden;
            margin: 0 auto;
        }
        .overlay img{
            width: 200px;
            height: 200px;
            margin: 100px;
        }
        img{
            width: 100%;
        }
        table{
            width: 100%;
            border-collapse: collapse;
        }
        td{
            padding:10px;
            font-weight: bold;
            font-size:18px;
        }
        tr{
            background: #fff;
            margin: 26px;
            height: 46px;
            padding: 36px !important;
            border: 5px;
            border:2px solid #deca90;
        }
        .bottomrow{
            height: 70px;
            background:#ded1a9 !important;
        }
        .bangla{
            font-weight: 0;
            font-size:15px;
        }
        .value{
            margin-left: 10px;
            font-weight: 1;
        }
    </style>
</head>
<body>

   <div class="content">

    <header>
        <img  src="{{ asset('backend/invoice/header.png') }}" alt="">
    </header>
    <div class="overlay">
        <img src="{{ asset('backend/invoice/logo1.png') }}" alt="">
    </div>
    <table>
        <tr style="background: #ded1a9">
            <td>Recipt No. <span style="background: white; width:100px;">{{ $receiptNo ?? '--' }}</span> </td>
            <td style="text-align:center"><img style="width: 250px;margin: 0 auto; height:35px" src="{{ asset('backend/invoice/rosid-removebg-preview.png') }}" alt=""></td>
            <td>Date: <span style="background: white;" class="value">{{ $date ?? '--' }}</span> </span></td>
        </tr>
        <tr>
            <td colspan="3"><span class="bangla">নাম</span>/Name <span class="value">{{ $data->name ?? '--' }}</span></td>
            {{-- <td><span class="bangla">মাস</span>/Month<span class="value">{{ $data->month ?? '--' }}</span></td> --}}
        </tr>
        <tr>
             <td colspan="2"><span class="bangla">মোবাইল</span>/Mobile <span class="value">{{ $data->mobile ?? '--' }}</span></td>
             <td><span class="bangla">পরিমাণ</span>/Amount <span class="value">{{ $data->amount ?? '--' }} </span></td>
        </tr>
        <tr>
            <td colspan="3"><span class="bangla">বাবদ</span>/On Account of <span class="value">{{ $data->received_purpose ?? '--' }}</span></td>

        </tr>
        <tr>
            <td colspan="3"><span class="bangla">ঠিকানা</span>/Address <span class="value">{{ $data->address ?? '--' }}</td>
        </tr>
        <tr class="bottomrow">
            {{-- <td style="vertical-align: bottom;">
               <span style="border-top:2px dashed #fff;padding-top: 5px;font-size: 22px;"><span class="bangla">মুহ্তামিম</span>/Principal</span>
            </td> --}}
            <td></td>
            <td></td>
            <td style="text-align: center;vertical-align: bottom;
            ">  <span style="border-top:2px dashed #fff;padding-top: 5px;font-size: 22px;"><span class="bangla">আদায়কারী</span>/ Collector</span></td>
        </tr>
    </table>
    <footer>
        <img src="{{ asset('backend/invoice/footer.png') }}" alt="">
    </footer>
   </div>

   <script type="text/javascript">
    localStorage.clear();
    function auto_print() {
        window.print()
    }
    setTimeout(auto_print, 1000);
</script>
</body>
</html>
