<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" href="{{ asset('logo.png')}}" />
    <title>Money Receipt</title>
    <style>
        .content{
            background:#deca90;
        }
        img{
            width: 100%;
        }
        table{
            width: 100%;
        }
        td{
            padding:10px;
            font-weight: bold;
            font-size:18px;

        }
        tr{
            background: #fff;
            margin: 26px;
            height: 46px;
            padding: 36px !important;
            border: 5px;
        }
        .bottomrow{
            height: 100px;
            background:#deca90 !important;
        }
        .bangla{
            font-weight: 0;
            font-size:15px;
        }
        .value{
            margin-left: 30px;
            font-weight: 1;
        }
    </style>
</head>
<body>

   <div class="content">

    <header>
        <img  src="{{ asset('backend/invoice/header.png') }}" alt="">
    </header>
    <table>
        <tr>
            <td>Recipt No. {{ $data->receipt_no ?? '--' }}</td>
            <td style="width:400px;text-align:center"><img style="width: 250px;margin: 0 auto;" src="{{ asset('backend/invoice/rosid-removebg-preview.png') }}" alt=""></td>
            <td>Date: <span class="value">{{Carbon\Carbon::parse($data->date)->format('d F, Y') ?? '--' }}</span> </span></td>
        </tr>
        <tr>
            <td colspan="2"><span class="bangla">নাম</span>/Name <span class="value">{{ $data->name ?? '--' }}</span></td>
            <td><span class="bangla">মাস</span>/Month <span class="value">{{ $data->month ?? '--' }}</span></td>
        </tr>
        <tr>
            <td colspan="2"><span class="bangla">ঠিকানা</span>/Address <span class="value">{{ $data->address ?? '--' }}</td>
            <td><span class="bangla">ক্লাস</span>/Class <span class="value">{{ $data->departments->department_name ?? '--' }}</span></td>
        </tr>
        <tr>
            <td><span class="bangla">পরিমাণ</span>/Amount <span class="value">{{ $data->amount ?? '--' }} </span></td>
            <td colspan="3"><span class="bangla">বাবদ</span>/On Account of <span class="value">{{ $data->received_purpose ?? '--' }}</span></td>
        </tr>
        <tr>
            <td colspan="3"><span class="bangla">কথায়</span>/In Word <span class="value">{{ $data->in_word ?? '--' }}</span></td>
        </tr>
        <tr class="bottomrow">
            <td style="vertical-align: bottom;">
               <span style="border-top:1px dashed #fff;padding-top: 5px;font-size: 22px;"><span class="bangla">মুহ্তামিম</span>/Principal</span>
            </td>
            <td></td>
            <td style="text-align: center;vertical-align: bottom;
            ">  <span style="border-top:1px dashed #fff;padding-top: 5px;font-size: 22px;"><span class="bangla">আদায়কারী</span>/ Collector</span></td>
        </tr>
    </table>
    <footer>
        <img src="{{ asset('backend/invoice/footer.png') }}" alt="">
    </footer>
   </div>

   <script type="text/javascript">
    localStorage.clear();
    function auto_print() {
        window.print()
    }
    setTimeout(auto_print, 1000);
</script>
</body>
</html>
