@extends('dashboard.master')
@section('title', 'Create Guraba Expense')
@push('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
<style>
    .bangla{
            font-weight: 0;
            font-size:15px;
        }
</style>
@endpush

@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Create Guraba Expense</b>
					</span>
				</div>

				<div class="page-title-actions">
					<a title="Back Button" href="{{ URL::previous() }}" type="button" class="btn btn-sm btn-dark">
						<i class="fas fa-arrow-left mr-1"></i>
						Back
					</a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
					<form enctype="multipart/form-data" action="{{ route('guraba-expense.store') }}" method="POST">
						@csrf
						<div class="row">

                            <div class="col-sm-2">
								<div class="form-group">
									<label for="receipt_no">Receipt No<span class="text-red">*</span></label>
									<input type="text" name="receipt_no" id="receipt_no " value="GEXP-{{ $id + 1 }}" class="form-control" placeholder="receipt no" readonly>

								</div>
							</div>

							<div class="col-sm-3">
								<div class="form-group">
									<label for="date">Date<span class="text-red">*</span></label>
									<input type="text" name="date" id="date" value="{{ old('date')}}" class="form-control" placeholder="তারিখ লিখুন" required>

									@error('date')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

                            <div class="col-sm-4">
								<div class="form-group">
									<label for="name"><span class="bangla">ব্যয়কারির নাম </span>/Expebnse By<span class="text-red">*</span></label>
									<input type="text" name="name" id="name" value="{{ old('name') }}" class="form-control @error('name') is-invalid @enderror" placeholder="নাম লিখুন" required>

									@error('name')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-3">
								<div class="form-group">
									<label for="amount"><span class="bangla">পরিমাণ</span>/Amount <span id="balance">({{ $currentBalance ?? 0 }})</span> <span class="text-red">*</span></label>
									<input type="text" name="amount" id="amount" value="{{ old('amount') }}" class="form-control @error('amount') is-invalid @enderror" placeholder="পরিমাণ লিখুন" required>

									@error('amount')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

                            <div class="col-sm-6">
								<div class="form-group">
									<label for="purpose"><span class="bangla">ব্যয়ের কারণ </span>/Expense Reason<span class="text-red">*</span></label>
									<textarea rows="3" name="purpose" id="purpose" class="form-control" placeholder="বাবদ লিখুন" required>{!! old('purpose') !!}</textarea>

									@error('purpose')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-6">
								<div class="form-group">
									<label for="note"><span class="bangla">বিঃদ্রঃ</span>/Note</label>
									<textarea rows="3" name="note" id="note" class="form-control" placeholder="বিঃদ্রঃ লিখুন">{!! old('note') !!}</textarea>

								</div>
							</div>

						</div>

						<div class="row mt-20">
							<div class="col-sm-12">
								<button type="submit" class="btn btn-primary mr-2">Create</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</section>
</div>

@push('js')
    <script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>

    <script>
       $(function () {
           $('#date').datepicker({
               dateFormat: 'dd-MM-yy'
           });
       });

       $("#amount").on('keyup', function(){
            // let bn_numbers = ['১, ২, ৩, ৪, ৫, ৬, ৭, ৮, ৯, ০'];
            // let en_numbers = ['1, 2, 3, 4, 5, 6, 7, 8, 9, 0'];

            let balance =  $('#balance').val();
            let amount =  $('#amount').val();

        //    let bnNum = balance.replace(bn_numbers);
        //    let enNum = amount.replace(bn_numbers);


        var bengali = ['০', '১', '২', '৩', '৪', '৫', '৬', '৭', '৮', '৯'];
        var eng = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9];

        let bnNum = balance.replace(bengali, eng);
        // alert(bnNum);

        //    const changeText = (e) => {

        // // Multiple lines solution
        // const element = $("#element");
        // const textToReplace = element.text();
        // const newText = textToReplace.replace("Hi", "Bye");
        // element.text(newText);
        // };

        // // Attaching the click event on the button
        // $(document).on('click', '#changeText', changeText);

      });

       </script>
@endpush
@endsection


