@extends('dashboard.master')
@section('title', 'Guraba Expense Details')
@section('content')
@push('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet"/>
@endpush

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Guraba Expense Details</b>
					</span>
				</div>

				<div class="page-title-actions">

                    <a title="Edit" id="edit" href="{{ route('guraba-expense.edit', $data->id) }}" class="btn btn-sm btn-primary edit" title="Edit"><i class="fa fa-edit"></i> Edit</a>

                    <a title="Back" href="{{ route('guraba-expense.index') }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Guraba Expense List
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
                    <div class="row">
                        <div class="col-sm-12">
                        <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                            <tbody>
                                <tr>
                                    <td width="30%">Receipt No</td>
                                    <td>{{ $data->receipt_no ?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td>Date</td>
                                    <td>{{ $date ?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td><span class="bangla">নাম</span>/Name</td>
                                    <td>{{ $data->name ?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td><span class="bangla">পরিমাণ</span>/Amount</td>
                                    <td>{{ $data->amount ?? '--' }} টাকা </td>
                                </tr>

                                <tr>
                                    <td><span class="bangla">বাবদ</span>/On Account Of</td>
                                    <td>{{ $data->purpose ?? '--' }}</td>
                                </tr>
                                <tr>
                                    <td><span class="bangla">বিঃদ্রঃ</span>/Note</td>
                                    <td>{{ $data->note ?? '--' }}</td>
                                </tr>

                            </tbody>
                        </table>
                        </div>

                    </div>
				</div>
			</div>
		</div>
	</section>
</div>

@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script>
    //  toastr.options.timeOut = 300;
    @if(Session::has('success'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
        "timeOut" : 2000
    };

    toastr.success("{{ session('success') }}");
  @endif

 @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
 @endif
</script>
@endpush
@endsection
