@extends('dashboard.master')
@section('title', 'ড্যাশবোর্ড')

@push('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.9.1/chart.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        /* Base styles */
        .dashboard-section {
            background: #f8f9fa;
            border-radius: 12px;
            margin-bottom: 20px;
            padding: 20px 15px 10px 15px;
            box-shadow: 0 3px 10px rgba(0, 0, 0, 0.05);
            width: 100%;
        }

        .dashboard-stats {
            padding: 0;
            background: none;
            border-radius: 0;
            box-shadow: none;
            margin-bottom: 0;
            display: flex;
            flex-wrap: wrap;
        }

        .stat-card {
            background: #fff;
            border-radius: 12px;
            padding: 15px;
            margin-bottom: 15px;
            transition: all 0.3s ease;
            border: 1px solid #eee;
            position: relative;
            overflow: hidden;
            min-height: 110px;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.04);
            width: 100%;
            height: 100%;
        }

        .stat-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        }

        .stat-card .icon {
            width: 45px;
            height: 45px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 10px;
            background: rgba(0, 169, 157, 0.1);
        }

        .stat-card .icon i {
            font-size: 20px;
            color: #00a99d;
        }

        .stat-card .stat-title {
            font-size: 14px;
            color: #495057;
            margin-bottom: 4px;
            font-weight: 500;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        .stat-card .stat-value {
            font-size: 22px;
            font-weight: bold;
            color: #2c3e50;
            margin-bottom: 0;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        .stat-card .trend {
            position: absolute;
            top: 12px;
            right: 12px;
            font-size: 12px;
            padding: 3px 8px;
            border-radius: 15px;
            font-weight: 500;
        }

        .trend.up {
            background: rgba(40, 167, 69, 0.1);
            color: #28a745;
        }

        .trend.down {
            background: rgba(220, 53, 69, 0.1);
            color: #dc3545;
        }

        .chart-container {
            background: #fff;
            border-radius: 12px;
            padding: 15px;
            margin-bottom: 15px;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.04);
            width: 100%;
            position: relative;
        }

        .chart-title {
            font-size: 15px;
            font-weight: 600;
            color: #2c3e50;
            margin-bottom: 10px;
            padding-bottom: 5px;
            border-bottom: 1px solid #eee;
        }

        .section-title {
            font-size: 18px;
            font-weight: 700;
            color: #00a99d;
            margin-bottom: 15px;
            margin-top: 0;
            letter-spacing: 0.5px;
        }

        /* Responsive styles */
        @media (min-width: 1400px) {
            .stat-card .stat-value {
                font-size: 24px;
            }

            .stat-card .stat-title {
                font-size: 16px;
            }

            .chart-title {
                font-size: 16px;
            }

            .section-title {
                font-size: 20px;
            }
        }

        @media (max-width: 1399px) {
            .stat-card .stat-value {
                font-size: 22px;
            }

            .stat-card .stat-title {
                font-size: 14px;
            }

            .chart-title {
                font-size: 15px;
            }

            .section-title {
                font-size: 18px;
            }
        }

        @media (max-width: 1199px) {
            .stat-card .stat-value {
                font-size: 20px;
            }

            .stat-card .stat-title {
                font-size: 13px;
            }

            .chart-title {
                font-size: 14px;
            }

            .section-title {
                font-size: 17px;
            }
        }

        @media (max-width: 991px) {
            .stat-card .stat-value {
                font-size: 18px;
            }

            .stat-card .stat-title {
                font-size: 13px;
            }

            .chart-title {
                font-size: 14px;
            }

            .section-title {
                font-size: 16px;
            }

            .stat-card {
                min-height: 100px;
            }

            .chart-container {
                padding: 12px;
            }
        }

        @media (max-width: 767px) {
            .stat-card {
                margin-bottom: 10px;
                min-height: 90px;
                padding: 12px;
            }

            .stat-card .stat-value {
                font-size: 16px;
                margin-top: 5px;
            }

            .stat-card .stat-title {
                font-size: 12px;
                margin-bottom: 2px;
            }

            .stat-card .icon {
                width: 35px;
                height: 35px;
            }

            .stat-card .icon i {
                font-size: 16px;
            }

            .chart-title {
                font-size: 13px;
            }

            .section-title {
                font-size: 15px;
            }

            .dashboard-section {
                padding: 10px 8px 5px 8px;
                margin-bottom: 15px;
            }

            .chart-container {
                padding: 10px;
                margin-bottom: 10px;
            }

            .islamic-banner-content {
                margin: auto;
            }
            .fa-moon, .fa-star, .islamic-divider, .fa-phone-volume{
                display: none;
            }
            .dashboard-banner-contact-icon{
                display: none !important;
            }
            
        }

        @media (max-width: 575px) {
            .stat-card {
                min-height: 85px;
                padding: 10px;
            }

            .stat-card .stat-value {
                font-size: 15px;
            }

            .stat-card .stat-title {
                font-size: 11px;
            }

            .stat-card .icon {
                width: 30px;
                height: 30px;
                margin-bottom: 5px;
            }

            .stat-card .icon i {
                font-size: 14px;
            }

            .chart-title {
                font-size: 12px;
            }

            .section-title {
                font-size: 14px;
            }

            .dashboard-section {
                padding: 8px 5px 5px 5px;
                margin-bottom: 10px;
            }

            .chart-container {
                padding: 8px;
                margin-bottom: 8px;
            }
        }

        /* Chart specific responsive styles */
        .chart-container canvas {
            width: 100% !important;
            height: auto !important;
            max-height: 300px;
        }



        @media (max-width: 767px) {
            .chart-container canvas {
                max-height: 250px;
            }
        }

        @media (max-width: 575px) {
            .chart-container canvas {
                max-height: 200px;
            }
        }

        /* Grid system adjustments */
        .row {
            margin-right: -8px;
            margin-left: -8px;
        }

        .col-lg-3,
        .col-md-4,
        .col-md-6,
        .col-6 {
            padding-right: 8px;
            padding-left: 8px;
        }

        /* Ensure charts maintain aspect ratio */
        #activePieChart,
        #genderPieChart {
            height: auto !important;
            width: 100% !important;
            max-width: 400px;
            margin: 0 auto;
        }

        /* Improve chart container responsiveness */
        .chart-container {
            display: flex;
            flex-direction: column;
        }

        .chart-container canvas {
            flex: 1;
            min-height: 200px;
        }

        @media (max-width: 767.98px) {
            .dashboard-device-image {
                width: 100vw !important;
                margin-left: -16px !important;
                margin-right: -16px !important;
                padding: 0 !important;
            }

             .dashboard-banner-contact-box{
flex-direction: column            
        }


            .dashboard-device-image img.mobile-img {
                width: 100vw !important;
                min-width: 100vw !important;
                height: auto !important;
                object-fit: cover !important;
                display: block;
                padding-left: 10px !important;
                padding-right: 10px !important;
                margin: 0;
                margin-left: 15px !important;
                padding: 0;
            }
        }

        .dashboard-banner img {
            width: 100%;
            max-height: 110px;
            object-fit: cover;
            border-radius: 10px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        }

        .dashboard-banner.islamic-alt1 {
            display: flex;
            align-items: center;
            background: linear-gradient(90deg, #00a99d 0%, #28a745 100%);
            color: #fff;
            border-radius: 18px;
            padding: 18px 32px 18px 70px;
            margin-bottom: 24px;
            box-shadow: 0 4px 16px rgba(0, 169, 157, 0.10);
            position: relative;
            overflow: hidden;
            animation: fadeInBanner 1.2s ease;
        }

        .islamic-border {
            position: absolute;
            left: 0;
            top: 0;
            bottom: 0;
            width: 60px;
            background: repeating-linear-gradient(135deg,
                    #fff 0 6px,
                    transparent 6px 12px);
            opacity: 0.12;
            border-radius: 18px 0 0 18px;
            z-index: 1;
        }

        .islamic-mosque {
            position: absolute;
            left: 18px;
            top: 50%;
            transform: translateY(-50%);
            font-size: 2.8rem;
            color: #fff;
            z-index: 2;
            text-shadow: 0 2px 8px #00a99d44;
            animation: floatMosque 2.5s ease-in-out infinite alternate;
        }

        @keyframes floatMosque {
            from {
                transform: translateY(-50%) scale(1);
            }

            to {
                transform: translateY(-60%) scale(1.07);
            }
        }

        .islamic-banner-content {
            flex: 1 1 60%;
            z-index: 2;
        }

        .dashboard-banner-title {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 6px;
            line-height: 1.2;
            letter-spacing: 1px;
        }

        .dashboard-banner-subtitle {
            font-size: 1.1rem;
            font-weight: 500;
            color: #ffe082;
        }

        .dashboard-banner-right {
            display: flex;
            align-items: center;
            gap: 18px;
            background: #fff;
            color: #222;
            border-radius: 12px;
            padding: 12px 20px;
            box-shadow: 0 1px 6px rgba(0, 0, 0, 0.07);
            z-index: 2;
        }

        .dashboard-banner-contact-icon {
            background: #00a99d;
            color: #fff;
            border-radius: 50%;
            width: 48px;
            height: 48px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            margin-right: 10px;
            animation: floatPhone 2s ease-in-out infinite alternate;
        }

        @keyframes floatPhone {
            from {
                transform: translateY(0);
            }

            to {
                transform: translateY(-7px);
            }
        }

        .dashboard-banner-contact-info {
            margin-right: 18px;
            text-align: left;
        }

        .dashboard-banner-contact-label {
            font-size: 1rem;
            font-weight: 600;
            color: #333;
        }

        .dashboard-banner-contact-number {
            font-size: 1.2rem;
            font-weight: 700;
            color: #00a99d;
        }

        .dashboard-banner-contact-time {
            text-align: center;
        }

        .dashboard-banner-contact-time-label {
            font-size: 0.95rem;
            font-weight: 600;
            color: #fff;
            background: #000000;
            border-radius: 5px 5px 0 0;
            padding: 2px 10px;
            margin-bottom: 2px;
        }

        .dashboard-banner-contact-time-box {
            background: #000000;
            color: #fff;
            border-radius: 0 0 5px 5px;
            padding: 4px 10px;
            font-size: 0.95rem;
            font-weight: 500;
            line-height: 1.2;
        }
       
        @media (max-width: 991px) {
            .dashboard-banner.islamic-alt1 {
                flex-direction: column;
                align-items: flex-start;
                padding: 14px 10px 14px 60px;
            }

            .dashboard-banner-right {
                margin-top: 10px;
                flex-direction: column;
                align-items: flex-start;
                gap: 10px;
                width: 100%;
            }

            .dashboard-banner-contact-info {
                margin-right: 0;
            }

            .islamic-mosque {
                left: 10px;
                font-size: 2rem;
            }

            .islamic-border {
                width: 40px;
            }
        }

        .dashboard-banner.islamic-alt2 {
            display: flex;
            align-items: center;
            background: linear-gradient(90deg, #00a99d 0%, #28a745 100%);
            color: #fff;
            border-radius: 18px;
            padding: 18px 32px;
            margin-bottom: 24px;
            box-shadow: 0 4px 16px rgba(0, 169, 157, 0.10);
            position: relative;
            overflow: hidden;
            animation: fadeInBanner 1.2s ease;
            margin-left: 20px;
            margin-right: 20px;
        }

        .islamic-crescent-star {
            display: flex;
            flex-direction: column;
            align-items: center;
            margin-right: 24px;
            font-size: 2.5rem;
            color: #ffc107;
            animation: floatMoon 2.5s ease-in-out infinite alternate;
        }

        .islamic-crescent-star .fa-star {
            font-size: 1.2rem;
            color: #fffde4;
            margin-top: -10px;
            margin-left: 18px;
            animation: twinkleStar 1.5s infinite alternate;
        }

        .islamic-divider {
            width: 2px;
            height: 60px;
            background: repeating-linear-gradient(to bottom,
                    #fff 0 6px,
                    transparent 6px 12px);
            opacity: 0.18;
            margin-right: 24px;
            border-radius: 2px;
        }

        .islamic-banner-content {
            flex: 1 1 60%;
        }

        .dashboard-banner-title {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 6px;
            line-height: 1.2;
            letter-spacing: 1px;
        }

        .dashboard-banner-subtitle {
            font-size: 1.1rem;
            font-weight: 500;
            color: #ffe082;
        }

        .dashboard-banner-right {
            display: flex;
            align-items: center;
            gap: 18px;
            background: #fff;
            color: #222;
            border-radius: 12px;
            padding: 12px 20px;
            box-shadow: 0 1px 6px rgba(0, 0, 0, 0.07);
        }

        .dashboard-banner-contact-icon {
            background: #00a99d;
            color: #fff;
            border-radius: 50%;
            width: 48px;
            height: 48px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            margin-right: 10px;
            animation: floatPhone 2s ease-in-out infinite alternate;
        }

        @keyframes floatMoon {
            from {
                transform: translateY(0);
            }

            to {
                transform: translateY(-10px);
            }
        }

        @keyframes twinkleStar {
            from {
                opacity: 0.7;
                transform: scale(1);
            }

            to {
                opacity: 1;
                transform: scale(1.3);
            }
        }

        @keyframes fadeInBanner {
            from {
                opacity: 0;
                transform: translateY(-30px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes floatPhone {
            from {
                transform: translateY(0);
            }

            to {
                transform: translateY(-7px);
            }
        }

        .dashboard-banner-contact-info {
            margin-right: 18px;
            text-align: left;
        }

        .dashboard-banner-contact-label {
            font-size: 1rem;
            font-weight: 600;
            color: #333;
        }

        .dashboard-banner-contact-number {
            font-size: 1.2rem;
            font-weight: 700;
            color: #00a99d;
        }

        .dashboard-banner-contact-time {
            text-align: center;
        }

        .dashboard-banner-contact-time-label {
            font-size: 0.95rem;
            font-weight: 600;
            color: #fff;
            background: #000000;
            border-radius: 5px 5px 0 0;
            padding: 2px 10px;
            margin-bottom: 2px;
        }

        .dashboard-banner-contact-time-box {
            background: #000000;
            color: #fff;
            border-radius: 0 0 5px 5px;
            padding: 4px 10px;
            font-size: 0.95rem;
            font-weight: 500;
            line-height: 1.2;
        }

        .dashboard-banner-contact-box {
            display: flex;
            align-items: center
        }

        @media (max-width: 991px) {
            .dashboard-banner.islamic-alt2 {
                flex-direction: column;
                align-items: flex-start;
                padding: 14px 10px;
            }

            .dashboard-banner-right {
                margin-top: 10px;
                flex-direction: column;
                align-items: flex-start;
                gap: 10px;
                width: 100%;
            }

            .dashboard-banner-contact-info {
                margin-right: 0;
            }

            .islamic-crescent-star {
                font-size: 2rem;
                margin-right: 10px;
            }

            .islamic-divider {
                height: 40px;
                margin-right: 10px;
            }

            .dashboard-banner-contact-box {
                gap: 10px;
                margin: auto
            }

            .dashboard-banner-title {
                font-size: 1.3rem;
                text-align: center
            }

            .dashboard-banner-contact-time-box {
                font-size: 0.8rem;
            }

            .dashboard-banner-subtitle {
                text-align: center
            }

        }


        @media (min-width: 992px) {
            .chart-container {
                height: 350px !important;
            }
        }
    </style>
@endpush

@section('content')
    <div class="content-wrapper">
      

        <div class="dashboard-device-image my-2" style="width:100%;">
            {{-- <img
            src="{{ asset('pc.png') }}"
            alt="Desktop Image"
            class="img-fluid d-none d-md-inline"
            style="max-height:80px;"
        > --}}
            {{-- <img
            src="{{ asset('mobile.png') }}"
            alt="Mobile Image"
            class="d-inline d-md-none mobile-img"
        > --}}
        </div>
         @php
        $site = DB::table('settings')->first();
    @endphp

        <div class="dashboard-banner islamic-alt2">
            <div class="islamic-crescent-star">
                <i class="fas fa-moon"></i>
                <i class="fas fa-star"></i>
            </div>
            <div class="islamic-divider"></div>
            <div class="islamic-banner-content">
                <div class="dashboard-banner-title">
                   {{ $site->long_name ?? 'বেফাকুল মাদারিস মাদ্রাসা ম্যানেজমেন্ট সফটওয়্যার' }} 
                </div>
                <div class="dashboard-banner-subtitle">
                    বিঃদ্রঃ নামাজের সময় এবং শুক্রবার সাপোর্ট অফ থাকবে
                </div>
            </div>
            <div class="dashboard-banner-right">
                <div class="dashboard-banner-contact-icon">
                    <i class="fas fa-phone-volume"></i>
                </div>
                <div class="dashboard-banner-contact-box">
                    <div class="dashboard-banner-contact-info">
                        <div class="dashboard-banner-contact-label">যোগাযোগ :</div>
                        <div class="dashboard-banner-contact-number">01804909500</div>
                    </div>
                    <div class="dashboard-banner-contact-time">
                        <div class="dashboard-banner-contact-time-label" style="font-size:24px ">সাপোর্টের সময়: প্রতিদিন সকাল ১০টা থেকে সন্ধ্যা ৭টা পর্যন্ত</div>
                        <div class="dashboard-banner-contact-time-box" style="font-size: 16px">
                          নির্দিষ্ট সময়ের বাইরে ইমার্জেন্সি সাপোর্ট প্রয়োজন হলে হোয়াটসঅ্যাপে মেসেজ করুন। অনুগ্রহপূর্বক কল দেওয়া থেকে বিরত থাকুন। ধন্যবাদ। 
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <!-- ===================== ড্যাশবোর্ড (Dashboard) ===================== -->

                <!-- ১. প্রধান পরিসংখ্যান -->
                <div class="dashboard-section">
                    <div class="section-title">প্রধান পরিসংখ্যান</div>
                    <div class="row dashboard-stats">
                        <div class="col-lg-2 col-md-6 col-6">
                            <div class="stat-card">
                                <div class="icon"><i class="fas fa-user-graduate"></i></div>
                                <div class="stat-title">মোট শিক্ষার্থী</div>
                                {{-- @dd($totalStudents) --}}
                                <div class="stat-value">{{ number_format($activeStudents) }}</div>
                                <span class="trend {{ isset($studentTrend) && $studentTrend >= 0 ? 'up' : 'down' }}">
                                    <!-- Optional: Trend value or icon -->
                                </span>
                            </div>
                        </div>
                        <div class="col-lg-2 col-md-6 col-6">
                            <div class="stat-card">
                                <div class="icon"><i class="fas fa-money-bill-wave"></i></div>
                                <div class="stat-title">সর্বমোট সংগ্রহ</div>
                                <div class="stat-value">৳{{ number_format($totalIncome) }}</div>
                                <span class="trend {{ isset($incomeTrend) && $incomeTrend >= 0 ? 'up' : 'down' }}">
                                    <!-- Optional: Trend value or icon -->
                                </span>
                            </div>
                        </div>

                        <div class="col-lg-2 col-md-6 col-6">
                            <div class="stat-card">
                                <div class="icon"><i class="fas fa-coins"></i></div>
                                <div class="stat-title">সর্বমোট খরচ</div>
                                <div class="stat-value">৳{{ number_format($totalExpense) }}</div>
                                <span class="trend {{ isset($balanceTrend) && $balanceTrend >= 0 ? 'up' : 'down' }}">
                                    <!-- Optional: Trend value or icon -->
                                </span>
                            </div>
                        </div>

                        <div class="col-lg-2 col-md-6 col-6">
                            <div class="stat-card">
                                <div class="icon"><i class="fas fa-wallet"></i></div>
                                <div class="stat-title">বর্তমান ব্যালেন্স</div>
                                <div class="stat-value">৳{{ number_format($currentBalance) }}</div>
                                <span class="trend {{ isset($balanceTrend) && $balanceTrend >= 0 ? 'up' : 'down' }}">
                                    <!-- Optional: Trend value or icon -->
                                </span>
                            </div>
                        </div>
                        <div class="col-lg-2 col-md-6 col-6">
                            <div class="stat-card">
                                <div class="icon"><i class="fas fa-chalkboard-teacher"></i></div>
                                <div class="stat-title">মোট শিক্ষক</div>
                                <div class="stat-value">{{ number_format($totalTeacher) }}</div>
                                <span class="trend {{ isset($teacherTrend) && $teacherTrend >= 0 ? 'up' : 'down' }}">
                                    <!-- Optional: Trend value or icon -->
                                </span>
                            </div>
                        </div>

                        <div class="col-lg-2 col-md-6 col-6">
                            <div class="stat-card">
                                <div class="icon"><i class="fas fa-user"></i></div>
                                <div class="stat-title">মোট ইন‌অ্যাকটিভ শিক্ষার্থী</div>
                                <div class="stat-value">{{ number_format($inactiveStudents) }}</div>
                                <span class="trend {{ isset($madrasahTrend) && $madrasahTrend >= 0 ? 'up' : 'down' }}">
                                    <!-- Optional: Trend value or icon -->
                                </span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- ৫. সকল ফান্ড -->
                <div class="dashboard-section">
                    <div class="section-title">সকল ফান্ড</div>
                    <div class="row dashboard-stats">
                        @php
                            $fundTypes = [
                                1 => 'সাধারণ ফান্ড',
                                2 => 'গোরাবা ফান্ড',
                                3 => 'মাহফিল ফান্ড',
                                4 => 'অন্যান্য ফান্ড',
                            ];
                        @endphp
                        @foreach ($fundBalances as $fund)
                            @if ($fund->funds)
                                <div class="col-lg-2 col-md-4 col-6">
                                    <div class="stat-card">
                                        <div class="icon">
                                            @switch($fund->funds->fund_type)
                                                @case(1)
                                                    <i class="fas fa-money-bill-wave"></i>
                                                @break

                                                @case(2)
                                                    <i class="fas fa-hands-helping"></i>
                                                @break

                                                @case(3)
                                                    <i class="fas fa-mosque"></i>
                                                @break

                                                @default
                                                    <i class="fas fa-hand-holding-usd"></i>
                                            @endswitch
                                        </div>
                                        <div class="stat-title">{{ $fund->funds->name ?? '' }}</div>
                                        <div class="stat-value">৳{{ number_format($fund->balance ?? 0) }}</div>
                                        <span
                                            class="trend up">{{ $fundTypes[$fund->funds->fund_type] ?? 'অজানা ফান্ড' }}</span>
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    </div>
                </div>

                <!-- ৬. ড্যাশবোর্ড বিশ্লেষণ -->
                <div class="dashboard-section">
                    <div class="section-title">ড্যাশবোর্ড বিশ্লেষণ</div>
                    <div class="row">
                        <div class="col-lg-6 col-md-12 mb-3">
                            <div class="chart-container">
                                <div class="chart-title">ফান্ড বণ্টন (পাই)</div>
                                <canvas id="fundPieChart" height="350"></canvas>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-12 mb-3">
                            <div class="chart-container">
                                <div class="chart-title">মাসভিত্তিক সংগ্রহ (বার)</div>
                                <canvas id="monthBarChart"></canvas>
                            </div>
                        </div>

                        <div class="col-lg-12 col-md-12 mb-3">
                            <div class="chart-container">
                                <div class="chart-title">মাসভিত্তিক বাকি (বার)</div>
                                <canvas id="monthDueChart"></canvas>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 mb-3">
                            <div class="chart-container">
                                <div class="chart-title">লিঙ্গ অনুপাত (পাই)</div>
                                <canvas id="genderPieChart"></canvas>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 mb-3">
                            <div class="chart-container">
                                <div class="chart-title">সক্রিয় বনাম নিষ্ক্রিয় শিক্ষার্থী</div>
                                <canvas id="activePieChart"></canvas>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 mb-3">
                            <div class="chart-container">
                                <div class="chart-title">ব্যালেন্স অনুযায়ী শীর্ষ ৩টি ফান্ড</div>
                                <canvas id="topFundsBarChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- ===================== END DASHBOARD ORGANIZATION ===================== -->
            </div>
        </section>
    </div>
@endsection

@push('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.9.1/chart.min.js"></script>
    <script>
        // Store chart instances for cleanup
        let chartInstances = {};

        document.addEventListener('DOMContentLoaded', function() {
            // Fund Distribution Pie Chart
            const pieCtx = document.getElementById('fundPieChart').getContext('2d');
            chartInstances.fundPie = new Chart(pieCtx, {
                type: 'doughnut',
                data: {
                    labels: [
                        @foreach ($fundBalances as $fund)
                            '{{ $fund->funds->name ?? 'Unknown' }}',
                        @endforeach
                    ],
                    datasets: [{
                        data: [
                            @foreach ($fundBalances as $fund)
                                {{ $fund->balance ?? 0 }},
                            @endforeach
                        ],
                        backgroundColor: [
                            '#00a99d',
                            '#28a745',
                            '#17a2b8',
                            '#ffc107',
                            '#dc3545',
                            '#6f42c1',
                            '#fd7e14',
                            '#20c997'
                        ]
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: 'bottom',
                            labels: {
                                boxWidth: 12,
                                padding: 8,
                                font: {
                                    size: 11
                                }
                            }
                        }
                    },
                    cutout: '60%'
                }
            });

            // Month-wise Collection Bar Chart
            const monthBarCtx = document.getElementById('monthBarChart').getContext('2d');
            chartInstances.monthBar = new Chart(monthBarCtx, {
                type: 'bar',
                data: {
                    labels: {!! json_encode(array_keys($monthlyCollections ?? [])) !!},
                    datasets: [{
                        label: 'Collections',
                        data: {!! json_encode(array_values($monthlyCollections ?? [])) !!},
                        backgroundColor: '#00a99d',
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });


            // Month-wise Due Bar Chart
            const ctx = document.getElementById('monthDueChart').getContext('2d');

            const labels = {!! json_encode(array_keys($monthlyDue ?? [])) !!};
            const dues = {!! json_encode(array_values($monthlyDue ?? [])) !!};

            if (window.chartInstances?.monthBar) window.chartInstances.monthBar.destroy();
            window.chartInstances = window.chartInstances || {};

            window.chartInstances.monthBar = new Chart(ctx, {
                type: 'bar',
                data: {
                    labels,
                    datasets: [{
                        label: 'Due',
                        data: dues,
                        backgroundColor: '#f06548'
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            display: true
                        },
                        tooltip: {
                            callbacks: {
                                label: (ctx) =>
                                    `${ctx.dataset.label}: ${Number(ctx.parsed.y).toLocaleString()}`
                            }
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });

            // Gender Distribution Pie
            const genderPieCtx = document.getElementById('genderPieChart').getContext('2d');
            chartInstances.genderPie = new Chart(genderPieCtx, {
                type: 'pie',
                data: {
                    labels: ['Male', 'Female'],
                    datasets: [{
                        data: [{{ $maleStudents }}, {{ $femaleStudents }}],
                        backgroundColor: ['#00a99d', '#ffc107']
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            position: 'bottom'
                        }
                    }
                }
            });

            // Active vs Inactive Students Pie
            const activePieCtx = document.getElementById('activePieChart').getContext('2d');
            chartInstances.activePie = new Chart(activePieCtx, {
                type: 'pie',
                data: {
                    labels: ['Active', 'Inactive'],
                    datasets: [{
                        data: [{{ $activeStudents }}, {{ $inactiveStudents }}],
                        backgroundColor: ['#28a745', '#dc3545']
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            position: 'bottom'
                        }
                    }
                }
            });

            // Top 3 Funds by Balance Bar
            const topFundsCtx = document.getElementById('topFundsBarChart').getContext('2d');
            chartInstances.topFunds = new Chart(topFundsCtx, {
                type: 'bar',
                data: {
                    labels: [
                        @foreach ($topFunds as $fund)
                            '{{ $fund->funds->name ?? 'Unknown' }}',
                        @endforeach
                    ],
                    datasets: [{
                        label: 'Balance',
                        data: [
                            @foreach ($topFunds as $fund)
                                {{ $fund->balance ?? 0 }},
                            @endforeach
                        ],
                        backgroundColor: ['#00a99d', '#ffc107', '#17a2b8']
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });
        });

        // Cleanup function to destroy charts when not needed
        function cleanupCharts() {
            Object.values(chartInstances).forEach(chart => {
                if (chart) {
                    chart.destroy();
                }
            });
            chartInstances = {};
        }

        // Add cleanup on page unload
        window.addEventListener('beforeunload', cleanupCharts);

        // Add cleanup on tab visibility change
        document.addEventListener('visibilitychange', function() {
            if (document.hidden) {
                // Optional: Destroy charts when tab is not visible
                // cleanupCharts();
            } else {
                // Reinitialize charts when tab becomes visible again
                // You can add reinitialization logic here if needed
            }
        });
    </script>
@endpush
