<style>
    .bangla {
        font-size: 17px !important;
        line-height: 1.7 !important;
    }

    .main-sidebar {
        background-color: #f8f9fa !important;
        color: #333 !important;
    }

    .nav-sidebar .nav-item>.nav-link {
        color: #333 !important;
        transition: all 0.3s ease;
        border-radius: 8px;
    }

    .nav-sidebar .nav-item>.nav-link:hover {
        background-color: #f2fbfa !important;
    }

    .nav-pills .nav-link.active{
        background-color: #f2fbfa !important;
    }

    .nav-sidebar .nav-item.menu-open>.nav-link {
        background-color: #f2fbfa;
        color: #000 !important;
    }

    .nav-icon {
        color: #555 !important;
        transition: all 0.3s ease;
    }

    .nav-sidebar .nav-item>.nav-link:hover .nav-icon {
        color: #000 !important;
    }
</style>

@php
    $site = DB::table('settings')->first();
    $prefix = Request::route()->getPrefix();
    $route = Route::current()->getName();
    $licence = DB::table('licences')->first();
@endphp

<aside class="main-sidebar elevation-4">
    <!-- Brand Logo -->
    <a href="{{ url('/') }}" class="brand-link">
        @if (isset($site->logo))
            <img src="{{ asset('img/' . $site->logo) }}" alt="ড্যাশবোর্ড" class="brand-image img-circle elevation-3"
                style="opacity:.8">
        @else
            <img src="{{ asset('img/logo.png') }}" alt="ড্যাশবোর্ড" class="brand-image img-circle elevation-3"
                style="opacity:.8">
        @endif
        <span class="brand-text font-weight-light bangla">ড্যাশবোর্ড</span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
        <nav>
            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                data-accordion="false">

                {{-- =================== System Settings (parent click → setting.menu) =================== --}}
                @php
                    $settingsMenuItems = [
                        ['route' => 'site.settings', 'title' => 'সাইট সেটিংস', 'perm' => 'site_setting.view'],
                        ['route' => 'invoice.design', 'title' => 'ইনভয়েস ডিজাইন', 'perm' => 'invoice_design.view'],
                        ['route' => 'device.setting', 'title' => 'ডিভাইস সেটিং', 'perm' => 'device_settings.view'],
                        ['route' => 'attendance.setting', 'title' => 'হাজিরা সেটিং', 'perm' => 'hajira_settings.view'],
                        ['route' => 'sms.setting', 'title' => 'এসএমএস সেটিং', 'perm' => 'sms_settings.view'],
                        ['route' => 'sms.status', 'title' => 'এসএমএস স্ট্যাটাস', 'perm' => 'sms_status.view'],
                        ['route' => 'user', 'title' => 'ইউজার', 'perm' => 'users.view'],
                        ['route' => 'user.role.index', 'title' => 'ইউজার রোল', 'perm' => 'users_role.view'],
                        [
                            'route' => 'admission.fee',
                            'title' => 'গ্লোবাল ভর্তি ফি',
                            'perm' => 'global_admission_fee.view',
                        ],
                        ['route' => 'student.session', 'title' => 'সেশন', 'perm' => 'session.view'],
                        ['route' => 'student.class', 'title' => 'ক্লাস', 'perm' => 'class.view'],
                        ['route' => 'subjects', 'title' => 'কিতাব', 'perm' => 'subject.view'],
                        ['route' => 'subject.assign', 'title' => 'কিতাব এসাইন', 'perm' => 'subject_assign.view'],
                        ['route' => 'data.delete', 'title' => 'ডিলিট সেটিং', 'perm' => 'delete_settings.view'],
                        ['route' => 'licence', 'title' => 'লাইসেন্স সেটিং', 'perm' => 'licence_settings.view'],
                    ];

                    $currentRoute = Route::current()->getName();
                    $isAdminLike =
                        Auth::user()->type == 1 || Auth::user()->role_id == 1 || Auth::user()->canPerm('settings.view');

                    $permittedSettingsItems = collect($settingsMenuItems)
                        ->filter(function ($item) use ($isAdminLike) {
                            return $isAdminLike || Auth::user()->canPerm($item['perm'] ?? '');
                        })
                        ->values();

                    $isSettingsActiveParent =
                        $currentRoute === 'setting.menu' ||
                        $permittedSettingsItems->pluck('route')->contains($currentRoute) ||
                             Request::is('user/role*');
                @endphp

                @if ($isAdminLike || $permittedSettingsItems->isNotEmpty())
                    <li class="nav-item settings {{ $isSettingsActiveParent ? 'menu-open' : '' }}"
                        style="cursor:pointer;" data-parent-href="{{ route('setting.menu') }}">

                        <a href="{{ route('setting.menu') }}"
                            class="nav-link {{ $isSettingsActiveParent ? 'active' : '' }}"
                            style="position:relative; padding-right:16px">
                            <i class="nav-icon fa fa-cog"></i>
                            <span class="bangla">সিস্টেম সেটিংস</span>
                        </a>

                        <ul class="nav nav-treeview" style="display: {{ $isSettingsActiveParent ? 'block' : 'none' }}; background-color: #e8eaea;">
                            @foreach ($permittedSettingsItems as $item)
                                <li class="nav-item">
                                    <a href="{{ route($item['route']) }}"
                                        class="nav-link {{ $currentRoute === $item['route'] ? 'active' : '' }}">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p class="bangla">{{ $item['title'] }}</p>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                        
                    </li>
                @endif
               

                {{-- =================== Student Menu (parent click → student.menu) =================== --}}
                @php
                    $studentMenuItems = [
                        ['route' => 'student.create', 'title' => 'ভর্তি', 'perm' => 'admission.view'],
                        ['route' => 'student.index', 'title' => 'শিক্ষার্থী তালিকা', 'perm' => 'students.view'],
                        [
                            'route' => 'inactive.student',
                            'title' => 'ইন‌অ্যাকটিভ শিক্ষার্থী',
                            'perm' => 'students_inactive.view',
                        ],
                        [
                            'route' => 'students.ids',
                            'title' => 'শিক্ষার্থী আইডি কার্ড',
                            'perm' => 'students_idcard.view',
                        ],
                        ['route' => 'hostel.fees', 'title' => 'শিক্ষার্থী ফি', 'perm' => 'students_fees.view'],
                        ['route' => 'hostel.fees.assign', 'title' => 'ফি এসাইন', 'perm' => 'students_fees_assign.view'],
                        ['route' => 'special.fees', 'title' => 'স্পেশাল ফি', 'perm' => 'students_special_fees.view'],
                        [
                            'route' => 'special.fees.assign',
                            'title' => 'স্পেশাল ফি এসাইন',
                            'perm' => 'students_special_fees_assign.view',
                        ],
                        ['route' => 'payment.list.new', 'title' => 'বেতন', 'perm' => 'students_beton.list'],
                        ['route' => 'payment.due', 'title' => 'বাকি বেতন', 'perm' => 'students_beton_due.view'],
                        ['route' => 'student.attendance', 'title' => 'হাজিরা', 'perm' => 'students_hajira.view'],
                        ['route' => 'student.leave', 'title' => 'ছুটি', 'perm' => 'students_leave.view'],
                        ['route' => 'payment.list', 'title' => 'শীঘ্রই আসছে', 'perm' => 'payment.view'],
                        ['route' => 'admission.due', 'title' => 'ভর্তি বাকি', 'perm' => 'admission_due.view'] // adjust as needed
                    ];

                    $isStudentAdminLike =
                        Auth::user()->type == 1 || Auth::user()->role_id == 1 || Auth::user()->canPerm('students.view');

                    $permittedStudentItems = collect($studentMenuItems)
                        ->filter(function ($item) use ($isStudentAdminLike) {
                            return $isStudentAdminLike || Auth::user()->canPerm($item['perm'] ?? '');
                        })
                        ->values();

                    $isStudentActiveParent =
                        $currentRoute === 'student.menu' ||
                        $permittedStudentItems->pluck('route')->contains($currentRoute) ||
                        Request::is('hostel/fees/show-by-type*') ||
                        Request::is('hostel/fees/assign/show-by-type*') ||
                        Request::is('hostel/fees/assign/show*') ||
                       Request::is('special/fees/assign/show*') ||
                        Request::is('payment/list/details*') ||
                        Request::is('payment/show*') ||
                        Request::is('student/attendance/show*') ||
                        Request::is('student/leave/show*') ;
                @endphp

                @if ($isStudentAdminLike || $permittedStudentItems->isNotEmpty())
                    <li class="nav-item student {{ $isStudentActiveParent ? 'menu-open' : '' }}"
                        style="cursor:pointer;" data-parent-href="{{ route('student.menu') }}">

                        <a href="{{ route('student.menu') }}"
                            class="nav-link {{ $isStudentActiveParent ? 'active' : '' }}"
                            style="position:relative; padding-right:16px">
                            <i class="nav-icon fas fa-users"></i>
                            <span class="bangla">শিক্ষার্থী ব্যবস্থাপনা</span>
                        </a>

                        <ul class="nav nav-treeview" style="display: {{ $isStudentActiveParent ? 'block' : 'none' }};background-color: #e8eaea;">
                            @foreach ($permittedStudentItems as $item)
                                <li class="nav-item">
                                    <a href="{{ route($item['route']) }}"
                                        class="nav-link {{ $currentRoute === $item['route'] ? 'active' : '' }}">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p class="bangla">{{ $item['title'] }}</p>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </li>
                @endif

                {{-- ===== Your other single-link menus (unchanged) ===== --}}
                {{-- @if (Auth::user()->role_id == 1 || Auth::user()->canPerm('students.view'))
                    <li class="nav-item {{ $route == 'student.menu' ? 'menu-open' : '' }}">
                        <a href="{{ route('student.menu') }}" class="nav-link">
                            <i class="nav-icon fas fa-users"></i>
                            <span class="bangla">শিক্ষার্থী ব্যবস্থাপনা (শর্টকাট)</span>
                        </a>
                    </li>
                @endif --}}

                {{-- =================== Education Menu (parent click → education.menu) =================== --}}
                @php
                    $educationMenuItems = [
                        ['route' => 'exam', 'title' => 'পরীক্ষা এসাইন', 'perm' => 'exam.view'],
                        ['route' => 'subject.grade', 'title' => 'গ্লোবাল গ্রেড সিস্টেম', 'perm' => 'global_grade.view'],
                        [
                            'route' => 'subject.wise.grade',
                            'title' => 'বিষয়ভিত্তিক গ্রেড সিস্টেম',
                            'perm' => 'subject_wise_grade.view',
                        ],
                        [
                            'route' => 'exam.wise.grade',
                            'title' => 'পরীক্ষা ভিত্তিক গ্রেড সিস্টেম',
                            'perm' => 'exam_wise_grade.view',
                        ],
                        ['route' => 'exam.routing', 'title' => 'পরীক্ষা রুটিন', 'perm' => 'exam_routine.view'],
                        ['route' => 'exam.seat', 'title' => 'সিট নাম্বার', 'perm' => 'exam_seat.view'],
                        ['route' => 'admitcard', 'title' => 'প্রবেশপত্র', 'perm' => 'admitcard.view'],
                        ['route' => 'results', 'title' => 'পরীক্ষা', 'perm' => 'exam_result.view'],
                        ['route' => 'result.sheet', 'title' => 'পরীক্ষার ফলাফল', 'perm' => 'exam_result.view'],
                        [
                            'route' => 'all.results',
                            'title' => 'সকল শিক্ষার্থীর ফলাফল',
                            'perm' => 'students_exam_result.view',
                        ],
                        [
                            'route' => 'student.comment',
                            'title' => 'পরীক্ষার মন্তব্য',
                            'perm' => 'students_comment.view',
                        ],
                        ['route' => 'student.neshab', 'title' => 'নেসাব', 'perm' => 'students_nesab.view'],
                        ['route' => 'student.book', 'title' => 'পাঠ্যসূচি', 'perm' => 'students_books.view'],
                        ['route' => 'sonad', 'title' => 'সনদ', 'perm' => 'sonod.view'],
                    ];

                    $currentRoute = Route::current()->getName();

                    // Show parent if admin-like or user has at least one permitted child.
                    // Mirrors your previous rule: type==1 OR (type==2 && created_by==null).
                    $isEducationAdminLike =
                        Auth::user()->type == 1 ||
                        Auth::user()->canPerm('exam.view') ||
                        Auth::user()->canPerm('global_grade.view') ||
                        Auth::user()->canPerm('subject_wise_grade.view') ||
                        Auth::user()->canPerm('exam_wise_grade.view') ||
                        Auth::user()->canPerm('exam_routine.view') ||
                        Auth::user()->canPerm('exam_seat.view') ||
                        Auth::user()->canPerm('admitcard.view') ||
                        Auth::user()->canPerm('exam_result.view') ||
                        Auth::user()->canPerm('students_exam_result.view') ||
                        Auth::user()->canPerm('students_comment.view') ||
                        Auth::user()->canPerm('students_nesab.view') ||
                        Auth::user()->canPerm('students_books.view') ||
                        Auth::user()->canPerm('sonod.view');

                    $permittedEducationItems = collect($educationMenuItems)
                        ->filter(function ($item) use ($isEducationAdminLike) {
                            return $isEducationAdminLike || Auth::user()->canPerm($item['perm'] ?? '');
                        })
                        ->values();

                    $isEducationActiveParent =
                        $currentRoute === 'education.menu' ||
                        $permittedEducationItems->pluck('route')->contains($currentRoute) ||
                        Request::is('subject-wise-grade/exam*') ||
                        Request::is('exam-routing/show/exam*') ||
                        Request::is('exam/seat/show*') || 
                        Request::is('result/show*') || 
                        Request::is('student/comment*') || 
                        Request::is('student/comment/show*') || 
                        Request::is('student/neshab*') ||
                        Request::is('sonad/show*');
                @endphp

                @if ($isEducationAdminLike || $permittedEducationItems->isNotEmpty())
                    <li class="nav-item education {{ $isEducationActiveParent ? 'menu-open' : '' }}"
                        style="cursor:pointer;" data-parent-href="{{ route('education.menu') }}">

                        {{-- Parent: always navigate to education.menu --}}
                        <a href="{{ route('education.menu') }}"
                            class="nav-link {{ $isEducationActiveParent ? 'active' : '' }}"
                            style="position:relative; padding-right:16px">
                            <i class="nav-icon fas fa-book"></i>
                            <span class="bangla">একাডেমিক বিভাগ</span>
                        </a>

                        {{-- Submenu: visible only when active --}}
                        <ul class="nav nav-treeview"
                            style="display: {{ $isEducationActiveParent ? 'block' : 'none' }}; background-color: #e8eaea;">
                            @foreach ($permittedEducationItems as $item)
                                @continue(!(auth()->user()->role_id == 1 || auth()->user()->type == 1 || (isset($item['perm']) && auth()->user()->canPerm($item['perm']))))
                                {{-- @dd($item) --}}
                                <li class="nav-item">
                                    <a href="{{ route($item['route']) }}"
                                        class="nav-link {{ $currentRoute === $item['route'] ? 'active' : '' }}">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p class="bangla">{{ $item['title'] }}</p>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </li>
                @endif


                {{-- =================== Hujur Menu (parent click → hujur.menu) =================== --}}
                @php
                    $hujurMenuItems = [
                        ['route' => 'teacher.index', 'title' => 'শিক্ষকদের তালিকা', 'perm' => 'teachers.view'],
                        ['route' => 'teacher.all.attendance', 'title' => 'হাজিরা', 'perm' => 'teachers_hajira.view'],
                        ['route' => 'teacher.leave', 'title' => 'ছুটি', 'perm' => 'teachers_leave.view'],
                        ['route' => 'teacher.salary', 'title' => 'বেতন-ভাতা', 'perm' => 'teachers_salary.view'],
                        [
                            'route' => 'teacher.due.advance',
                            'title' => 'বাকি-অগ্রিম বেতন-ভাতা',
                            'perm' => 'teachers_advance_salary.create',
                        ],
                    ];

                    $currentRoute = Route::current()->getName();

                    $isHujurAdminLike =
                        Auth::user()->type == 1 ||
                        Auth::user()->role_id == 1 ||
                        Auth::user()->canPerm('teachers.view') ||
                        Auth::user()->canPerm('teachers_hajira.view') ||
                        Auth::user()->canPerm('teachers_leave.view') ||
                        Auth::user()->canPerm('teachers_salary.view') ||
                        Auth::user()->canPerm('teachers_advance_salary.create');

                    $permittedHujurItems = collect($hujurMenuItems)
                        ->filter(function ($item) use ($isHujurAdminLike) {
                            return $isHujurAdminLike || Auth::user()->canPerm($item['perm'] ?? '');
                        })
                        ->values();

                    $isHujurActiveParent =
                        $currentRoute === 'hujur.menu' || $permittedHujurItems->pluck('route')->contains($currentRoute)
                         || Request::is('teacher/attendance/show*') || 
                        Request::is('teacher/attendance*') || 
                        Request::is('teacher/leave*') || 
                        Request::is('teacher/salary/details*') || 
                        Request::is('teacher/salary*');
                @endphp

                @if ($isHujurAdminLike || $permittedHujurItems->isNotEmpty())
                    <li class="nav-item hujur {{ $isHujurActiveParent ? 'menu-open' : '' }}" style="cursor:pointer;"
                        data-parent-href="{{ route('hujur.menu') }}">

                        {{-- Parent: always navigate to hujur.menu --}}
                        <a href="{{ route('hujur.menu') }}"
                            class="nav-link {{ $isHujurActiveParent ? 'active' : '' }}"
                            style="position:relative; padding-right:16px">
                            <i class="nav-icon fas fa-chalkboard-teacher"></i>
                            <span class="bangla">শিক্ষক ব্যবস্থাপনা</span>
                        </a>

                        {{-- Submenu: visible only when active --}}
                        <ul class="nav nav-treeview" style="display: {{ $isHujurActiveParent ? 'block' : 'none' }}; background-color: #e8eaea;">
                            @foreach ($permittedHujurItems as $item)
                                <li class="nav-item">
                                    <a href="{{ route($item['route']) }}"
                                        class="nav-link {{ $currentRoute === $item['route'] ? 'active' : '' }}">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p class="bangla">{{ $item['title'] }}</p>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </li>
                @endif


                {{-- =================== Administration Menu (parent click → administration.menu) =================== --}}
                @php
                    $administrationMenuItems = [
                       ['route' => 'staff.create', 'title' => 'কর্মচারী নিয়োগ', 'perm' => 'niyog.create'],
                        ['route' => 'staff.index', 'title' => 'কর্মচারী তালিকা', 'perm' => 'niyog.view'],
                            ['route' => 'staff.salary', 'title' => 'কর্মচারী বেতন-ভাতা', 'perm' => 'niyog.create'],
                        ['route' => 'teacher.assign', 'title' => 'শিক্ষক এসাইন', 'perm' => 'teachers_assign.view'],
                        [
                            'route' => 'teacher.book.distribute',
                            'title' => 'কিতাব বন্টন',
                            'perm' => 'teachers_book_distribute.view',
                        ],
                        [
                            'route' => 'responsibilities',
                            'title' => 'দায়িত্ব',
                            'perm' => 'teachers_responsibilities.view',
                        ],
                        [
                            'route' => 'teacher.responsibility',
                            'title' => 'দায়িত্ব বন্টন',
                            'perm' => 'teachers_responsibilities.view',
                        ],
                        [
                            'route' => 'teacher.discharge',
                            'title' => 'শিক্ষক ডিসচার্জ',
                            'perm' => 'teachers_discharge.view',
                        ],
                    ];

                    $currentRoute = Route::current()->getName();

                    // Show parent if admin-like (type==1 / role_id==1) or user has general/admin permission.
                    $isAdministrationAdminLike =
                        Auth::user()->type == 1 ||
                        Auth::user()->role_id == 1 ||
                        Auth::user()->canPerm('administration.view') || // keep if you have a parent-level perm
                        Auth::user()->canPerm('niyog.create') ||
                        Auth::user()->canPerm('teachers_assign.view') ||
                        Auth::user()->canPerm('teachers_book_distribute.view') ||
                        Auth::user()->canPerm('teachers_responsibilities.view') ||
                        Auth::user()->canPerm('teachers_discharge.view');

                    $permittedAdministrationItems = collect($administrationMenuItems)
                        ->filter(function ($item) use ($isAdministrationAdminLike) {
                            return $isAdministrationAdminLike || Auth::user()->canPerm($item['perm'] ?? '');
                        })
                        ->values();

                    $isAdministrationActiveParent =
                        $currentRoute === 'administration.menu' ||
                        $permittedAdministrationItems->pluck('route')->contains($currentRoute) ||
                        Request::is('staff/*') || 
                        Request::is('teacher/book*') || 
                        Request::is('teacher/responsibility*') || 
                        Request::is('teacher/discharge*');
                @endphp

                @if ($isAdministrationAdminLike || $permittedAdministrationItems->isNotEmpty())
                    <li class="nav-item administration {{ $isAdministrationActiveParent ? 'menu-open' : '' }}"
                        style="cursor:pointer;" data-parent-href="{{ route('administration.menu') }}">

                        {{-- Parent: always navigate to administration.menu --}}
                        <a href="{{ route('administration.menu') }}"
                            class="nav-link {{ $isAdministrationActiveParent ? 'active' : '' }}"
                            style="position:relative; padding-right:16px">
                            <i class="nav-icon fas fa-cogs"></i>
                            <span class="bangla">প্রশাসনিক বিভাগ</span>
                        </a>

                        {{-- Submenu: visible only when active --}}
                        <ul class="nav nav-treeview"
                            style="display: {{ $isAdministrationActiveParent ? 'block' : 'none' }}; background-color: #e8eaea;">
                            @foreach ($permittedAdministrationItems as $item)
                                <li class="nav-item">
                                    <a href="{{ route($item['route']) }}"
                                        class="nav-link {{ $currentRoute === $item['route'] ? 'active' : '' }}">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p class="bangla">{{ $item['title'] }}</p>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </li>
                @endif


                {{-- =================== Accounting Menu (parent click → accounting.menu) =================== --}}
                @php
                    $accountingMenuItems = [
                        ['route' => 'funds', 'title' => 'ফান্ড', 'perm' => 'fund.view'],
                        ['route' => 'expense.type', 'title' => 'ব্যয়ের ধরন', 'perm' => 'expense_type.view'],
                        ['route' => 'fund.expense', 'title' => 'ব্যয়', 'perm' => 'expense.view'],
                        ['route' => 'general.fund', 'title' => 'সাধারণ জমা-খরচ', 'perm' => 'general_fund.view'],
                        ['route' => 'guraba.fund', 'title' => 'গোরাবা জমা-খরচ', 'perm' => 'guraba_fund.view'],
                        [
                            'route' => 'fund.balance.sheet',
                            'title' => 'দৈনিক জমা খরচ',
                            'perm' => 'daily_deposit_expense.view',
                        ],
                        ['route' => 'mahfil.take', 'title' => 'অনুষ্ঠান মাহফিল জমা', 'perm' => 'mahfil_taken.view'],
                        ['route' => 'mahfil', 'title' => 'অনুষ্ঠান মাহফিল খরচ', 'perm' => 'mahfil_expense.view'],
                        ['route' => 'annual.accounting', 'title' => 'বাৎসরিক রিপোর্ট', 'perm' => 'annual_report.view'],
                        ['route' => 'properties', 'title' => 'সম্পদ ও আসবাবপত্র', 'perm' => 'property.view'],
                        ['route' => 'receipt.payment', 'title' => 'অডিট রিপোর্ট', 'perm' => 'audit_report.view'],
                    ];

                    $currentRoute = Route::current()->getName();

                    $isAccountingAdminLike =
                        Auth::user()->type == 1 ||
                        Auth::user()->role_id == 1 ||
                        Auth::user()->canPerm('fund.view') ||
                        Auth::user()->canPerm('expense_type.view') ||
                        Auth::user()->canPerm('expense.view') ||
                        Auth::user()->canPerm('general_fund.view') ||
                        Auth::user()->canPerm('guraba_fund.view') ||
                        Auth::user()->canPerm('daily_deposit_expense.view') ||
                        Auth::user()->canPerm('mahfil_taken.view') ||
                        Auth::user()->canPerm('mahfil_expense.view') ||
                        Auth::user()->canPerm('annual_report.view') ||
                        Auth::user()->canPerm('property.view') ||
                        Auth::user()->canPerm('audit_report.view');

                    $permittedAccountingItems = collect($accountingMenuItems)
                        ->filter(function ($item) use ($isAccountingAdminLike) {
                            return $isAccountingAdminLike || Auth::user()->canPerm($item['perm'] ?? '');
                        })
                        ->values();

                    $isAccountingActiveParent =
                        $currentRoute === 'accounting.menu' ||
                        $permittedAccountingItems->pluck('route')->contains($currentRoute) ||
                        Request::is('expense/type*') ||
                        Request::is('expense*') ||
                        Request::is('general/fund*') ||
                        Request::is('guraba/fund*') ||
                        Request::is('daily/deposit/expense*') ||
                        Request::is('mahfil/take*') ||
                        Request::is('mahfil*') ||
                        Request::is('annual/accounting*') ||
                        Request::is('properties*') ||
                        Request::is('receipt/payment*') ||
                        Request::is('fund/collect*');
                @endphp

                @if ($isAccountingAdminLike || $permittedAccountingItems->isNotEmpty())
                    <li class="nav-item accounting {{ $isAccountingActiveParent ? 'menu-open' : '' }}"
                        style="cursor:pointer;" data-parent-href="{{ route('accounting.menu') }}">

                        {{-- Parent: always navigate to accounting.menu --}}
                        <a href="{{ route('accounting.menu') }}"
                            class="nav-link {{ $isAccountingActiveParent ? 'active' : '' }}"
                            style="position:relative; padding-right:16px">
                            <i class="nav-icon fas fa-calculator"></i>
                            <span class="bangla">হিসাব ও অর্থ বিভাগ</span>
                        </a>

                        {{-- Submenu: visible only when active --}}
                        <ul class="nav nav-treeview"
                            style="display: {{ $isAccountingActiveParent ? 'block' : 'none' }}; background-color: #e8eaea;">
                            @foreach ($permittedAccountingItems as $item)
                                <li class="nav-item">
                                    <a href="{{ route($item['route']) }}"
                                        class="nav-link {{ $currentRoute === $item['route'] ? 'active' : '' }}">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p class="bangla">{{ $item['title'] }}</p>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </li>
                @endif


                {{-- =================== Roshid Menu (parent click → roshid.menu) =================== --}}
                @php
                    $roshidMenuItems = [
                        ['route' => 'roshid.stock', 'title' => 'রশিদ স্টক', 'perm' => 'stock.view'],
                        ['route' => 'roshid.distribute', 'title' => 'রশিদ প্রদান', 'perm' => 'distribute.view'],
                        ['route' => 'roshid.taken', 'title' => 'রশিদ গ্রহণ', 'perm' => 'taken.view'],
                    ];

                    $currentRoute = Route::current()->getName();

                    // Show parent if admin-like (type==1/5 or role_id==1) or user has any relevant permission
                    $isRoshidAdminLike =
                        Auth::user()->type == 1 ||
                        Auth::user()->role_id == 1 ||
                        Auth::user()->canPerm('stock.view') ||
                        Auth::user()->canPerm('distribute.view') ||
                        Auth::user()->canPerm('taken.view');

                    $permittedRoshidItems = collect($roshidMenuItems)
                        ->filter(function ($item) use ($isRoshidAdminLike) {
                            return $isRoshidAdminLike || Auth::user()->canPerm($item['perm'] ?? '');
                        })
                        ->values();

                    $isRoshidActiveParent =
                        $currentRoute === 'roshid.menu' ||
                        $permittedRoshidItems->pluck('route')->contains($currentRoute) ||
                        Request::is('roshid/stock*') ||
                        Request::is('roshid/distribute*') ||
                        Request::is('roshid/taken*');
                @endphp

                @if ($isRoshidAdminLike || $permittedRoshidItems->isNotEmpty())
                    <li class="nav-item roshid {{ $isRoshidActiveParent ? 'menu-open' : '' }}"
                        style="cursor:pointer;" data-parent-href="{{ route('roshid.menu') }}">

                        {{-- Parent: always navigate to roshid.menu --}}
                        <a href="{{ route('roshid.menu') }}"
                            class="nav-link {{ $isRoshidActiveParent ? 'active' : '' }}"
                            style="position:relative; padding-right:16px">
                            <i class="nav-icon fas fa-file-invoice"></i>
                            <span class="bangla">রশিদ ব্যবস্থাপনা</span>
                        </a>

                        {{-- Submenu: visible only when active --}}
                        <ul class="nav nav-treeview"
                            style="display: {{ $isRoshidActiveParent ? 'block' : 'none' }}; background-color: #e8eaea;">
                            @foreach ($permittedRoshidItems as $item)
                                <li class="nav-item">
                                    <a href="{{ route($item['route']) }}"
                                        class="nav-link {{ $currentRoute === $item['route'] ? 'active' : '' }}">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p class="bangla">{{ $item['title'] }}</p>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </li>
                @endif


                {{-- =================== Sponsor & Donation Menu (parent click → sponsor.donation.menu) =================== --}}
                @php
                    $sponsorDonationMenuItems = [
                        ['route' => 'donar.type', 'title' => 'দাতার ধরন', 'perm' => 'donar.type.view'],
                        ['route' => 'donar.list', 'title' => 'দাতা', 'perm' => 'donar.list.view'],
                        ['route' => 'donation.type', 'title' => 'অনুদানের ধরন', 'perm' => 'donation.type.view'],
                        ['route' => 'donations', 'title' => 'অনুদান', 'perm' => 'donation.view'],
                    ];

                    $currentRoute = Route::current()->getName();

                    $isSponsorDonationAdminLike =
                        Auth::user()->type == 1 ||
                        Auth::user()->role_id == 1 ||
                        Auth::user()->canPerm('donar.type.view') ||
                        Auth::user()->canPerm('donar.list.view') ||
                        Auth::user()->canPerm('donation.type.view') ||
                        Auth::user()->canPerm('donation.view');

                    $permittedSponsorDonationItems = collect($sponsorDonationMenuItems)
                        ->filter(function ($item) use ($isSponsorDonationAdminLike) {
                            return $isSponsorDonationAdminLike || Auth::user()->canPerm($item['perm'] ?? '');
                        })
                        ->values();

                    $isSponsorDonationActiveParent =
                        $currentRoute === 'sponsor.donation.menu' ||
                        $permittedSponsorDonationItems->pluck('route')->contains($currentRoute) ||
                        Request::is('donations*');
                @endphp

                @if ($isSponsorDonationAdminLike || $permittedSponsorDonationItems->isNotEmpty())
                    <li class="nav-item sponsor-donation {{ $isSponsorDonationActiveParent ? 'menu-open' : '' }}"
                        style="cursor:pointer;" data-parent-href="{{ route('sponsor.donation.menu') }}">

                        {{-- Parent: always navigate to sponsor.donation.menu --}}
                        <a href="{{ route('sponsor.donation.menu') }}"
                            class="nav-link {{ $isSponsorDonationActiveParent ? 'active' : '' }}"
                            style="position:relative; padding-right:16px">
                            <i class="nav-icon fas fa-hand-holding-usd"></i>
                            <span class="bangla">স্পনসর ও অনুদান বিভাগ</span>
                        </a>

                        {{-- Submenu: visible only when active --}}
                        <ul class="nav nav-treeview"
                            style="display: {{ $isSponsorDonationActiveParent ? 'block' : 'none' }}; background-color: #e8eaea;">
                            @foreach ($permittedSponsorDonationItems as $item)
                                <li class="nav-item">
                                    <a href="{{ route($item['route']) }}"
                                        class="nav-link {{ $currentRoute === $item['route'] ? 'active' : '' }}">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p class="bangla">{{ $item['title'] }}</p>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </li>
                @endif


                {{-- =================== Loan Menu (parent click → loan.menu) =================== --}}
                @php
                    $loanMenuItems = [
                        ['route' => 'loan.given', 'title' => 'ঋণ প্রদান', 'perm' => 'given.view'],
                        ['route' => 'loan.taken', 'title' => 'ঋণ গ্রহণ', 'perm' => 'taken.view'],
                        ['route' => 'shop', 'title' => 'দোকান', 'perm' => 'shop.view'],
                        ['route' => 'due.taken', 'title' => 'বাকি গ্রহণ', 'perm' => 'due.taken.view'],
                        ['route' => 'due.given', 'title' => 'বাকি প্রদান', 'perm' => 'due.given.view'],
                    ];

                    $currentRoute = Route::current()->getName();

                    // Show parent if admin-like (type==1/5 or role_id==1) or user has any relevant permission
                    $isLoanAdminLike =
                        Auth::user()->type == 1 ||
                        Auth::user()->role_id == 1 ||
                        Auth::user()->canPerm('given.view') ||
                        Auth::user()->canPerm('taken.view') ||
                        Auth::user()->canPerm('shop.view') ||
                        Auth::user()->canPerm('due.taken.view') ||
                        Auth::user()->canPerm('due.given.view');

                    $permittedLoanItems = collect($loanMenuItems)
                        ->filter(function ($item) use ($isLoanAdminLike) {
                            return $isLoanAdminLike || Auth::user()->canPerm($item['perm'] ?? '');
                        })
                        ->values();

                    $isLoanActiveParent =
                        $currentRoute === 'loan.menu' || $permittedLoanItems->pluck('route')->contains($currentRoute) ||
                        Request::is('loan/given*') || Request::is('loan/taken*') ||
                        Request::is('shop*') || Request::is('due/taken*') || Request::is('due/given*');
                @endphp

                @if ($isLoanAdminLike || $permittedLoanItems->isNotEmpty())
                    <li class="nav-item loan {{ $isLoanActiveParent ? 'menu-open' : '' }}" style="cursor:pointer;"
                        data-parent-href="{{ route('loan.menu') }}">

                        {{-- Parent: always navigate to loan.menu --}}
                        <a href="{{ route('loan.menu') }}"
                            class="nav-link {{ $isLoanActiveParent ? 'active' : '' }}"
                            style="position:relative; padding-right:16px">
                            <i class="nav-icon fas fa-money-check-alt"></i>
                            <span class="bangla">ঋণ ও বাকি ব্যবস্থাপনা</span>
                        </a>

                        {{-- Submenu: visible only when active --}}
                        <ul class="nav nav-treeview" style="display: {{ $isLoanActiveParent ? 'block' : 'none' }}; background-color: #e8eaea;">
                            @foreach ($permittedLoanItems as $item)
                                <li class="nav-item">
                                    <a href="{{ route($item['route']) }}"
                                        class="nav-link {{ $currentRoute === $item['route'] ? 'active' : '' }}">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p class="bangla">{{ $item['title'] }}</p>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </li>
                @endif


                {{-- =================== Sponsor Menu (parent click → sponsor.menu) =================== --}}
                @php
                    $sponsorMenuItems = [
                        // ['route' => 'donar.list', 'title' => 'স্পনসর', 'perm' => 'donar.list.view'],
                        ['route' => 'student.sponsor', 'title' => 'এতিম স্পনসর', 'perm' => 'sponsor_students.view'],
                        [
                            'route' => 'sponsor.amount.take.list',
                            'title' => 'স্পনসর পেমেন্ট',
                            'perm' => 'amount.take.list.payment.view',
                        ],
                        [
                            'route' => 'sponsor.due.advance',
                            'title' => 'স্পনসর পেমেন্ট বাকি-অগ্রিম',
                            'perm' => 'due.advance.view',
                        ],
                    ];

                    $currentRoute = Route::current()->getName();

                    // Show parent if admin-like (type==1/5 or role_id==1) or any related permission exists
                    $isSponsorAdminLike =
                        Auth::user()->type == 1 ||
                        Auth::user()->role_id == 1 ||
                        Auth::user()->canPerm('donar.list.view') ||
                        Auth::user()->canPerm('sponsor_students.view') ||
                        Auth::user()->canPerm('amount.take.list.payment.view') ||
                        Auth::user()->canPerm('due.advance.view');

                    $permittedSponsorItems = collect($sponsorMenuItems)
                        ->filter(function ($item) use ($isSponsorAdminLike) {
                            return $isSponsorAdminLike || Auth::user()->canPerm($item['perm'] ?? '');
                        })
                        ->values();

                    $isSponsorActiveParent =
                        $currentRoute === 'sponsor.menu' ||
                        $permittedSponsorItems->pluck('route')->contains($currentRoute) ||
                         Request::is('student/sponsor/show*') ||
                          Request::is('sponsor/advance*') ||
                           Request::is('sponsor/amount/take/details*');
                @endphp

                @if ($isSponsorAdminLike || $permittedSponsorItems->isNotEmpty())
                    <li class="nav-item sponsor {{ $isSponsorActiveParent ? 'menu-open' : '' }}"
                        style="cursor:pointer;" data-parent-href="{{ route('sponsor.menu') }}">

                        {{-- Parent: always navigate to sponsor.menu --}}
                        <a href="{{ route('sponsor.menu') }}"
                            class="nav-link {{ $isSponsorActiveParent ? 'active' : '' }}"
                            style="position:relative; padding-right:16px">
                            <i class="nav-icon fas fa-donate"></i>
                            <span class="bangla">এতিম স্পনসর বিভাগ</span>
                        </a>

                        {{-- Submenu: visible only when active --}}
                        <ul class="nav nav-treeview"
                            style="display: {{ $isSponsorActiveParent ? 'block' : 'none' }}; background-color: #e8eaea;">
                            @foreach ($permittedSponsorItems as $item)
                                <li class="nav-item">
                                    <a href="{{ route($item['route']) }}"
                                        class="nav-link {{ $currentRoute === $item['route'] ? 'active' : '' }}">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p class="bangla">{{ $item['title'] }}</p>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </li>
                @endif

                {{-- =================== Boarding Menu (parent click → boarding.menu) =================== --}}
                @php
                    $boardingMenuItems = [
                        ['route' => 'boarding.create', 'title' => 'বোর্ডিং বাজার', 'perm' => 'bazar.create'],
                        ['route' => 'boarding', 'title' => 'বোর্ডিং খরচ', 'perm' => 'list.view'],
                    ];

                    $currentRoute = Route::current()->getName();

                    $isBoardingAdminLike =
                        Auth::user()->type == 1 ||
                        Auth::user()->role_id == 1 ||
                        Auth::user()->canPerm('bazar.create') ||
                        Auth::user()->canPerm('list.view');

                    $permittedBoardingItems = collect($boardingMenuItems)
                        ->filter(function ($item) use ($isBoardingAdminLike) {
                            return $isBoardingAdminLike || Auth::user()->canPerm($item['perm'] ?? '');
                        })
                        ->values();

                    $isBoardingActiveParent =
                        $currentRoute === 'boarding.menu' ||
                        $permittedBoardingItems->pluck('route')->contains($currentRoute);
                @endphp

                @if ($isBoardingAdminLike || $permittedBoardingItems->isNotEmpty())
                    <li class="nav-item boarding {{ $isBoardingActiveParent ? 'menu-open' : '' }}"
                        style="cursor:pointer;" data-parent-href="{{ route('boarding.menu') }}">

                        {{-- Parent: always navigate to boarding.menu --}}
                        <a href="{{ route('boarding.menu') }}"
                            class="nav-link {{ $isBoardingActiveParent ? 'active' : '' }}"
                            style="position:relative; padding-right:16px">
                            <i class="nav-icon fas fa-building"></i>
                            <span class="bangla">বোর্ডিং ব্যবস্থাপনা</span>
                        </a>

                        {{-- Submenu: visible only when active --}}
                        <ul class="nav nav-treeview"
                            style="display: {{ $isBoardingActiveParent ? 'block' : 'none' }}; background-color: #e8eaea;">
                            @foreach ($permittedBoardingItems as $item)
                                <li class="nav-item">
                                    <a href="{{ route($item['route']) }}"
                                        class="nav-link {{ $currentRoute === $item['route'] ? 'active' : '' }}">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p class="bangla">{{ $item['title'] }}</p>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </li>
                @endif

                {{-- =================== Notice Menu (parent click → notice.menu) =================== --}}
                @php
                    $noticeMenuItems = [
                        ['route' => 'group.notice', 'title' => 'গ্রুপ নোটিশ', 'perm' => 'group.notice.view'],
                        ['route' => 'single.notice', 'title' => 'সিঙ্গেল নোটিশ', 'perm' => 'single.notice.view'],
                        ['route' => 'notices', 'title' => 'নোটিশ বিজ্ঞাপন', 'perm' => 'notices.view'],
                    ];

                    $currentRoute = Route::current()->getName();

                    // Show parent if admin-like or has any related permission
                    $isNoticeAdminLike =
                        Auth::user()->type == 1 ||
                        Auth::user()->role_id == 1 ||
                        Auth::user()->canPerm('group.notice.view') ||
                        Auth::user()->canPerm('single.notice.view') ||
                        Auth::user()->canPerm('notices.view');

                    $permittedNoticeItems = collect($noticeMenuItems)
                        ->filter(function ($item) use ($isNoticeAdminLike) {
                            return $isNoticeAdminLike || Auth::user()->canPerm($item['perm'] ?? '');
                        })
                        ->values();

                    $isNoticeActiveParent =
                        $currentRoute === 'notice.menu' ||
                        $permittedNoticeItems->pluck('route')->contains($currentRoute) ||
                        Request::is('notice*');
                @endphp

                @if ($isNoticeAdminLike || $permittedNoticeItems->isNotEmpty())
                    <li class="nav-item notice {{ $isNoticeActiveParent ? 'menu-open' : '' }}"
                        style="cursor:pointer;" data-parent-href="{{ route('notice.menu') }}">

                        {{-- Parent: always navigate to notice.menu --}}
                        <a href="{{ route('notice.menu') }}"
                            class="nav-link {{ $isNoticeActiveParent ? 'active' : '' }}"
                            style="position:relative; padding-right:16px">
                            <i class="nav-icon fas fa-bell"></i>
                            <span class="bangla">নোটিশ ও ঘোষণাপত্র</span>
                        </a>

                        {{-- Submenu: visible only when active --}}
                        <ul class="nav nav-treeview"
                            style="display: {{ $isNoticeActiveParent ? 'block' : 'none' }};background-color: #e8eaea;">
                            @foreach ($permittedNoticeItems as $item)
                                <li class="nav-item">
                                    <a href="{{ route($item['route']) }}"
                                        class="nav-link {{ $currentRoute === $item['route'] ? 'active' : '' }}">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p class="bangla">{{ $item['title'] }}</p>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </li>
                @endif


                @if (Auth::user()->type == 1 || Auth::user()->type == 5)
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="modal" data-target="#calculatorModal">
                            <i class="nav-icon fas fa-calculator"></i>
                            <span class="bangla">ক্যালকুলেটর</span>
                        </a>
                    </li>
                @endif

                <li class="nav-item {{ $route == 'help.line' ? 'menu-open' : '' }}">
                    <a href="{{ route('help.line') }}" class="nav-link">
                        <i class="nav-icon fas fa-phone"></i>
                        <span class="bangla">হেল্পলাইন ও সাপোর্ট</span>
                    </a>
                </li>

                  <li class="nav-item {{ $route == 'studentInfo-by-registration' ? 'menu-open' : '' }}">
                    <a href="{{ route('studentInfo-by-registration') }}" class="nav-link" target="_blank">
                        <i class="nav-icon fas fa-user"></i>
                        <span class="bangla">শিক্ষার্থী তথ্য</span>
                    </a>
                </li>
            </ul>
        </nav>
    </div>
</aside>

{{-- ================= Calculator Modal (kept) ================= --}}
<div class="modal fade" id="calculatorModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-xl" style="max-width: 500px;">
        <div class="modal-content" style="height: 500px;">
            <div class="modal-header">
                <h5 class="modal-title">ক্যালকুলেটর</h5>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>
            <div class="modal-body text-center d-flex flex-column">
                <div class="mb-3">
                    <input type="text" id="calc-display" class="form-control text-right py-3"
                        style="font-size: 1.5rem;" readonly>
                </div>
                <div class="d-grid gap-2 flex-grow-1">
                    <div class="btn-group btn-group-lg d-flex mb-2">
                        <button class="btn btn-secondary flex-fill" onclick="calcPress('7')">7</button>
                        <button class="btn btn-secondary flex-fill" onclick="calcPress('8')">8</button>
                        <button class="btn btn-secondary flex-fill" onclick="calcPress('9')">9</button>
                        <button class="btn btn-warning flex-fill" onclick="calcPress('/')">÷</button>
                    </div>
                    <div class="btn-group btn-group-lg d-flex mb-2">
                        <button class="btn btn-secondary flex-fill" onclick="calcPress('4')">4</button>
                        <button class="btn btn-secondary flex-fill" onclick="calcPress('5')">5</button>
                        <button class="btn btn-secondary flex-fill" onclick="calcPress('6')">6</button>
                        <button class="btn btn-warning flex-fill" onclick="calcPress('*')">×</button>
                    </div>
                    <div class="btn-group btn-group-lg d-flex mb-2">
                        <button class="btn btn-secondary flex-fill" onclick="calcPress('1')">1</button>
                        <button class="btn btn-secondary flex-fill" onclick="calcPress('2')">2</button>
                        <button class="btn btn-secondary flex-fill" onclick="calcPress('3')">3</button>
                        <button class="btn btn-warning flex-fill" onclick="calcPress('-')">−</button>
                    </div>
                    <div class="btn-group btn-group-lg d-flex mb-2">
                        <button class="btn btn-secondary flex-fill" onclick="calcPress('0')">0</button>
                        <button class="btn btn-secondary flex-fill" onclick="calcPress('.')">.</button>
                        <button class="btn btn-success flex-fill" onclick="calculate()">=</button>
                        <button class="btn btn-warning flex-fill" onclick="calcPress('+')">+</button>
                    </div>
                    <div class="btn-group btn-group-lg d-flex">
                        <button class="btn btn-danger flex-fill" onclick="clearCalc()">Clear</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    #calculatorModal .modal-content {
        transition: all 0.3s ease;
    }

    #calculatorModal .btn {
        font-size: 1.2rem;
        padding: 0.75rem;
    }
</style>

<script>
    // ===== Calculator =====
    let calcDisplay = '';
    let resultShown = false;

    function updateDisplay() {
        const display = document.getElementById('calc-display');
        display.value = calcDisplay;
        display.scrollLeft = display.scrollWidth;
    }

    function calcPress(val) {
        if (resultShown && !['+', '-', '*', '/'].includes(val)) {
            calcDisplay = '';
        }
        resultShown = false;
        calcDisplay += val;
        updateDisplay();
    }

    function calculate() {
        try {
            calcDisplay = eval(calcDisplay).toString();
        } catch (error) {
            calcDisplay = 'Error';
        }
        updateDisplay();
        resultShown = true;
    }

    function clearCalc() {
        calcDisplay = '';
        updateDisplay();
        resultShown = false;
    }

    document.addEventListener('keydown', function(event) {
        const key = event.key;
        if (!isNaN(key) || ['+', '-', '*', '/', '.'].includes(key)) {
            calcPress(key);
        } else if (key === 'Enter' || key === '=') {
            event.preventDefault();
            calculate();
        } else if (key.toLowerCase() === 'c') {
            clearCalc();
        } else if (key === 'Backspace') {
            calcDisplay = calcDisplay.slice(0, -1);
            updateDisplay();
        }
    });

    document.addEventListener('DOMContentLoaded', function() {
        var modal = document.getElementById('calculatorModal');
        if (modal) {
            modal.addEventListener('hidden.bs.modal', function() {
                if (document.activeElement) document.activeElement.blur();
            });
        }
    });

    // ===== Make entire parent <li> clickable for BOTH .settings and .student =====
    document.addEventListener('DOMContentLoaded', function() {
        // Make entire parent <li> clickable for settings + student + education
        document.querySelectorAll(
            '.nav-item.settings, .nav-item.student, .nav-item.education, .nav-item.hujur, .nav-item.administration, .nav-item.accounting, .nav-item.roshid, .nav-item.sponsor-donation, .nav-item.loan, .nav-item.sponsor, .nav-item.boarding,  .nav-item.notice'
        ).forEach(
            function(li) {
                li.addEventListener('click', function(e) {
                    // যদি child link এ ক্লিক হয়, normal আচরণ
                    const anchor = e.target.closest('a.nav-link');
                    const isChildLink = anchor && anchor.closest('.nav.nav-treeview');
                    if (isChildLink) return;

                    // parent route এ নিয়ে যান
                    const parentHref = li.getAttribute('data-parent-href');
                    if (parentHref) {
                        e.preventDefault();
                        e.stopPropagation(); // AdminLTE treeview toggle রোধ
                        window.location.href = parentHref;
                    }
                });

                // নিরাপত্তার জন্য parent anchor ক্লিকেও toggle রোধ + navigate
                const parentAnchor = li.querySelector(':scope > a.nav-link');
                if (parentAnchor) {
                    parentAnchor.addEventListener('click', function(e) {
                        // child হলে ছাড়ুন
                        if (parentAnchor.closest('.nav.nav-treeview')) return;
                        const parentHref = li.getAttribute('data-parent-href');
                        if (parentHref) {
                            e.preventDefault();
                            e.stopPropagation();
                            window.location.href = parentHref;
                        }
                    });
                }
            });
    });
</script>
