@extends('dashboard.master')
@section('title', 'Mahfil Details')
@section('content')
 <?php
    $invoiceBgPath = 'back_height.jpg';
    if (isset($invoice->invoice_bg) && !empty($invoice->invoice_bg)) {
        $potentialBgFile = 'img/' . $invoice->invoice_bg;
        if (file_exists(public_path($potentialBgFile))) {
            $invoiceBgPath = $potentialBgFile;
        }
    }
    ?>
     <style>
        .printArea {
            background-image: url('{{ asset($invoiceBgPath) }}');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            padding: 20px;
        }

        @media print {
            body * {
                visibility: hidden;
            }

            .printArea,
            .printArea * {
                visibility: visible;
            }

            .printArea {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
                background-image: url('{{ asset($invoiceBgPath) }}') !important;
                background-size: cover !important;
                background-position: center !important;
                background-repeat: no-repeat !important;
            }

            .container,
            .container-fluid,
            .content-wrapper>.content {
                padding: 0 !important;
            }

            .print-table th,
            .print-table td {
                background: transparent !important;
            }
        }
    </style>

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Mahfil Details</b>
					</span>
				</div>

				<div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
                    <a title="Print" id="printButton" type="button" class="btn btn-sm btn-danger">
                        <i class="fas fa-file mr-1"></i>
                        Print
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body printArea">
                    <img id="header-img" src="{{ asset('img/' . $invoice->invoice_header) }}" alt="Header" style="width:100%; height:150px; margin-bottom:20px;">
					<table id="data_table" class="table table-bordered table-striped data-table table-hover print-table">
                        <thead>
                            <tr>
                                <th width="30%">Receipt No </th>
                                <td width="70%">{{ str_pad($data->fundDetails->receipt_no ?? '-', 2, '0', STR_PAD_LEFT) }}</td>
                            </tr>
                            <tr>
                                <th width="30%">Date</th>
                                <td width="70%">{{ \Carbon\Carbon::parse($data->date)->format('d-M-Y') ?? '' }}</td>
                            </tr>
                            <tr>
                                <th width="30%">Fund Name</th>
                                <td width="70%">{{ $data->funds->name ?? '' }}</td>
                            </tr>
                            <tr>
                                <th width="30%">Given To</th>
                                <td width="70%">{{ $data->name ?? '' }}</td>
                            </tr>
                            <tr>
                                <th width="30%">Amount</th>
                                <td width="70%">{{ $data->amount ?? '' }}</td>
                            </tr>
                            <tr>
                                <th width="30%">Address</th>
                                <td width="70%">{{ $data->address ?? '' }}</td>
                            </tr>
                            <tr>
                                <th width="30%">Note</th>
                                <td width="70%">{{ $data->note ?? '' }}</td>
                            </tr>
                        </thead>
                    </table>

                    <div id="footer-img">
                        <img src="{{ asset('img/' . $invoice->invoice_footer) }}" alt="Footer" style="width:100%; height:150px; margin-top:20px;">
                    </div>

				</div>
			</div>
		</div>
	</section>
</div>
@push('js')

  <script>
            $('#printButton').on('click', function() {
                window.print();
            });
        </script>
@endpush

@endsection
